/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class SOAPBody
extends MessageElement
implements javax.xml.soap.SOAPBody {
    private static Log log = LogFactory.getLog(SOAPBody.class.getName());
    private SOAPConstants soapConstants;
    private boolean disableFormatting = false;
    private boolean doSAAJEncodingCompliance = false;
    private static ArrayList knownEncodingStyles = new ArrayList();

    SOAPBody(SOAPEnvelope sOAPEnvelope, SOAPConstants sOAPConstants) {
        super(sOAPConstants.getEnvelopeURI(), "Body");
        this.soapConstants = sOAPConstants;
        try {
            this.setParentElement(sOAPEnvelope);
        }
        catch (SOAPException sOAPException) {
            log.fatal(Messages.getMessage("exception00"), sOAPException);
        }
    }

    public SOAPBody(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext, SOAPConstants sOAPConstants) throws AxisFault {
        super(string, string2, string3, attributes, deserializationContext);
        this.soapConstants = sOAPConstants;
    }

    public void setParentElement(SOAPElement sOAPElement) throws SOAPException {
        if (sOAPElement == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullParent00"));
        }
        try {
            SOAPEnvelope sOAPEnvelope = (SOAPEnvelope)sOAPElement;
            super.setParentElement(sOAPEnvelope);
            this.setEnvelope(sOAPEnvelope);
        }
        catch (Throwable throwable) {
            throw new SOAPException(throwable);
        }
    }

    public void disableFormatting() {
        this.disableFormatting = true;
    }

    public void setEncodingStyle(String string) throws SOAPException {
        if (string == null) {
            string = "";
        }
        if (this.doSAAJEncodingCompliance && !knownEncodingStyles.contains(string)) {
            throw new IllegalArgumentException(Messages.getMessage("badEncodingStyle1", string));
        }
        super.setEncodingStyle(string);
    }

    protected void outputImpl(SerializationContext serializationContext) throws Exception {
        boolean bl = serializationContext.getPretty();
        if (!this.disableFormatting) {
            serializationContext.setPretty(true);
        } else {
            serializationContext.setPretty(false);
        }
        List list = this.getChildren();
        if (list == null || list.isEmpty()) {
            // empty if block
        }
        serializationContext.startElement(new QName(this.soapConstants.getEnvelopeURI(), "Body"), this.getAttributesEx());
        if (list != null) {
            for (MessageElement messageElement : list) {
                messageElement.output(serializationContext);
            }
        }
        serializationContext.outputMultiRefs();
        serializationContext.endElement();
        serializationContext.setPretty(bl);
    }

    Vector getBodyElements() throws AxisFault {
        this.initializeChildren();
        return new Vector(this.getChildren());
    }

    SOAPBodyElement getFirstBody() throws AxisFault {
        if (!this.hasChildNodes()) {
            return null;
        }
        return (SOAPBodyElement)this.getChildren().get(0);
    }

    void addBodyElement(SOAPBodyElement sOAPBodyElement) {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("addBody00"));
        }
        try {
            this.addChildElement(sOAPBodyElement);
        }
        catch (SOAPException sOAPException) {
            log.fatal(Messages.getMessage("exception00"), sOAPException);
        }
    }

    void removeBodyElement(SOAPBodyElement sOAPBodyElement) {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("removeBody00"));
        }
        this.removeChild(sOAPBodyElement);
    }

    void clearBody() {
        this.removeContents();
    }

    SOAPBodyElement getBodyByName(String string, String string2) throws AxisFault {
        QName qName = new QName(string, string2);
        return (SOAPBodyElement)this.getChildElement(qName);
    }

    public javax.xml.soap.SOAPBodyElement addBodyElement(Name name) throws SOAPException {
        SOAPBodyElement sOAPBodyElement = new SOAPBodyElement(name);
        this.addChildElement(sOAPBodyElement);
        return sOAPBodyElement;
    }

    public javax.xml.soap.SOAPFault addFault(Name name, String string, Locale locale) throws SOAPException {
        AxisFault axisFault = new AxisFault(new QName(name.getURI(), name.getLocalName()), string, "", new Element[0]);
        SOAPFault sOAPFault = new SOAPFault(axisFault);
        this.addChildElement(sOAPFault);
        return sOAPFault;
    }

    public javax.xml.soap.SOAPFault addFault(Name name, String string) throws SOAPException {
        AxisFault axisFault = new AxisFault(new QName(name.getURI(), name.getLocalName()), string, "", new Element[0]);
        SOAPFault sOAPFault = new SOAPFault(axisFault);
        this.addChildElement(sOAPFault);
        return sOAPFault;
    }

    public javax.xml.soap.SOAPBodyElement addDocument(Document document) throws SOAPException {
        SOAPBodyElement sOAPBodyElement = new SOAPBodyElement(document.getDocumentElement());
        this.addChildElement(sOAPBodyElement);
        return sOAPBodyElement;
    }

    public javax.xml.soap.SOAPFault addFault() throws SOAPException {
        AxisFault axisFault = new AxisFault(new QName("http://xml.apache.org/axis/", "Server.generalException"), "", "", new Element[0]);
        SOAPFault sOAPFault = new SOAPFault(axisFault);
        this.addChildElement(sOAPFault);
        return sOAPFault;
    }

    public javax.xml.soap.SOAPFault getFault() {
        List list = this.getChildren();
        if (list != null) {
            for (Object e : list) {
                if (!(e instanceof javax.xml.soap.SOAPFault)) continue;
                return (javax.xml.soap.SOAPFault)e;
            }
        }
        return null;
    }

    public boolean hasFault() {
        return this.getFault() != null;
    }

    public void addChild(MessageElement messageElement) throws SOAPException {
        messageElement.setEnvelope(this.getEnvelope());
        super.addChild(messageElement);
    }

    public SOAPElement addChildElement(SOAPElement sOAPElement) throws SOAPException {
        SOAPElement sOAPElement2 = super.addChildElement(sOAPElement);
        this.setDirty(true);
        return sOAPElement2;
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        SOAPBodyElement sOAPBodyElement = new SOAPBodyElement(name);
        this.addChildElement(sOAPBodyElement);
        return sOAPBodyElement;
    }

    public SOAPElement addChildElement(String string) throws SOAPException {
        SOAPBodyElement sOAPBodyElement = new SOAPBodyElement(this.getNamespaceURI(), string);
        this.addChildElement(sOAPBodyElement);
        return sOAPBodyElement;
    }

    public SOAPElement addChildElement(String string, String string2) throws SOAPException {
        SOAPBodyElement sOAPBodyElement = new SOAPBodyElement(this.getNamespaceURI(string2), string);
        sOAPBodyElement.setPrefix(string2);
        this.addChildElement(sOAPBodyElement);
        return sOAPBodyElement;
    }

    public SOAPElement addChildElement(String string, String string2, String string3) throws SOAPException {
        SOAPBodyElement sOAPBodyElement = new SOAPBodyElement(string3, string);
        sOAPBodyElement.setPrefix(string2);
        sOAPBodyElement.addNamespaceDeclaration(string2, string3);
        this.addChildElement(sOAPBodyElement);
        return sOAPBodyElement;
    }

    public void setSAAJEncodingCompliance(boolean bl) {
        this.doSAAJEncodingCompliance = true;
    }

    static {
        knownEncodingStyles.add("http://schemas.xmlsoap.org/soap/encoding/");
        knownEncodingStyles.add("http://www.w3.org/2003/05/soap-encoding");
        knownEncodingStyles.add("");
        knownEncodingStyles.add("http://www.w3.org/2003/05/soap-envelope/encoding/none");
    }
}

