/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.Detail;
import org.apache.axis.message.NodeImpl;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.Messages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class SOAPFault
extends SOAPBodyElement
implements javax.xml.soap.SOAPFault {
    protected AxisFault fault;
    protected String prefix;
    private Locale locale;
    protected Detail detail = null;

    public SOAPFault(String string, String string2, String string3, Attributes attributes, DeserializationContext deserializationContext) throws AxisFault {
        super(string, string2, string3, attributes, deserializationContext);
    }

    public SOAPFault(AxisFault axisFault) {
        this.fault = axisFault;
    }

    public void outputImpl(SerializationContext serializationContext) throws Exception {
        SOAP11Constants sOAP11Constants = serializationContext.getMessageContext() == null ? SOAPConstants.SOAP11_CONSTANTS : serializationContext.getMessageContext().getSOAPConstants();
        this.namespaceURI = sOAP11Constants.getEnvelopeURI();
        this.name = "Fault";
        serializationContext.registerPrefixForURI(this.prefix, sOAP11Constants.getEnvelopeURI());
        serializationContext.startElement(new QName(this.getNamespaceURI(), this.getName()), this.attributes);
        if (this.fault instanceof AxisFault) {
            int n;
            Object[] objectArray;
            Object object;
            AxisFault axisFault = this.fault;
            if (axisFault.getFaultCode() != null) {
                if (sOAP11Constants == SOAPConstants.SOAP12_CONSTANTS) {
                    object = serializationContext.qName2String(axisFault.getFaultCode());
                    serializationContext.startElement(Constants.QNAME_FAULTCODE_SOAP12, null);
                    serializationContext.startElement(Constants.QNAME_FAULTVALUE_SOAP12, null);
                    serializationContext.writeSafeString((String)object);
                    serializationContext.endElement();
                    objectArray = axisFault.getFaultSubCodes();
                    if (objectArray != null) {
                        for (n = 0; n < objectArray.length; ++n) {
                            object = serializationContext.qName2String((QName)objectArray[n]);
                            serializationContext.startElement(Constants.QNAME_FAULTSUBCODE_SOAP12, null);
                            serializationContext.startElement(Constants.QNAME_FAULTVALUE_SOAP12, null);
                            serializationContext.writeSafeString((String)object);
                            serializationContext.endElement();
                        }
                        for (n = 0; n < objectArray.length; ++n) {
                            serializationContext.endElement();
                        }
                    }
                    serializationContext.endElement();
                } else {
                    object = serializationContext.qName2String(axisFault.getFaultCode());
                    serializationContext.startElement(Constants.QNAME_FAULTCODE, null);
                    serializationContext.writeSafeString((String)object);
                    serializationContext.endElement();
                }
            }
            if (axisFault.getFaultString() != null) {
                if (sOAP11Constants == SOAPConstants.SOAP12_CONSTANTS) {
                    serializationContext.startElement(Constants.QNAME_FAULTREASON_SOAP12, null);
                    object = new AttributesImpl();
                    ((AttributesImpl)object).addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", "en");
                    serializationContext.startElement(Constants.QNAME_TEXT_SOAP12, (Attributes)object);
                } else {
                    serializationContext.startElement(Constants.QNAME_FAULTSTRING, null);
                }
                serializationContext.writeSafeString(axisFault.getFaultString());
                serializationContext.endElement();
                if (sOAP11Constants == SOAPConstants.SOAP12_CONSTANTS) {
                    serializationContext.endElement();
                }
            }
            if (axisFault.getFaultActor() != null) {
                if (sOAP11Constants == SOAPConstants.SOAP12_CONSTANTS) {
                    serializationContext.startElement(Constants.QNAME_FAULTROLE_SOAP12, null);
                } else {
                    serializationContext.startElement(Constants.QNAME_FAULTACTOR, null);
                }
                serializationContext.writeSafeString(axisFault.getFaultActor());
                serializationContext.endElement();
            }
            if (axisFault.getFaultNode() != null && sOAP11Constants == SOAPConstants.SOAP12_CONSTANTS) {
                serializationContext.startElement(Constants.QNAME_FAULTNODE_SOAP12, null);
                serializationContext.writeSafeString(axisFault.getFaultNode());
                serializationContext.endElement();
            }
            if ((object = this.getFaultQName(this.fault.getClass(), serializationContext)) == null && this.fault.detail != null) {
                object = this.getFaultQName(this.fault.detail.getClass(), serializationContext);
            }
            if (object == null) {
                object = new QName("", "faultData");
            }
            if ((objectArray = axisFault.getFaultDetails()) != null) {
                if (sOAP11Constants == SOAPConstants.SOAP12_CONSTANTS) {
                    serializationContext.startElement(Constants.QNAME_FAULTDETAIL_SOAP12, null);
                } else {
                    serializationContext.startElement(Constants.QNAME_FAULTDETAILS, null);
                }
                axisFault.writeDetails((QName)object, serializationContext);
                for (n = 0; n < objectArray.length; ++n) {
                    serializationContext.writeDOMElement((Element)objectArray[n]);
                }
                if (this.detail != null) {
                    Iterator iterator = this.detail.getChildren().iterator();
                    while (iterator.hasNext()) {
                        ((NodeImpl)iterator.next()).output(serializationContext);
                    }
                }
                serializationContext.endElement();
            }
        }
        serializationContext.endElement();
    }

    private QName getFaultQName(Class clazz, SerializationContext serializationContext) {
        QName qName = null;
        if (!clazz.equals(AxisFault.class)) {
            OperationDesc operationDesc;
            FaultDesc faultDesc = null;
            if (serializationContext.getMessageContext() != null && (operationDesc = serializationContext.getMessageContext().getOperation()) != null) {
                faultDesc = operationDesc.getFaultByClass(clazz);
            }
            if (faultDesc != null) {
                qName = faultDesc.getQName();
            }
        }
        return qName;
    }

    public AxisFault getFault() {
        return this.fault;
    }

    public void setFault(AxisFault axisFault) {
        this.fault = axisFault;
    }

    public void setFaultCode(String string) throws SOAPException {
        this.fault.setFaultCodeAsString(string);
    }

    public String getFaultCode() {
        return this.fault.getFaultCode().getLocalPart();
    }

    public void setFaultActor(String string) throws SOAPException {
        this.fault.setFaultActor(string);
    }

    public String getFaultActor() {
        return this.fault.getFaultActor();
    }

    public void setFaultString(String string) throws SOAPException {
        this.fault.setFaultString(string);
    }

    public String getFaultString() {
        return this.fault.getFaultString();
    }

    public javax.xml.soap.Detail getDetail() {
        List list = this.getChildren();
        if (list == null || list.size() <= 0) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (!(e instanceof javax.xml.soap.Detail)) continue;
            return (javax.xml.soap.Detail)e;
        }
        return null;
    }

    public javax.xml.soap.Detail addDetail() throws SOAPException {
        if (this.getDetail() != null) {
            throw new SOAPException(Messages.getMessage("valuePresent"));
        }
        Detail detail = this.convertToDetail(this.fault);
        this.addChildElement(detail);
        return detail;
    }

    public void setFaultCode(Name name) throws SOAPException {
        String string;
        String string2 = name.getURI();
        String string3 = name.getLocalName();
        this.prefix = string = name.getPrefix();
        QName qName = new QName(string2, string3);
        this.fault.setFaultCode(qName);
    }

    public Name getFaultCodeAsName() {
        QName qName = this.fault.getFaultCode();
        String string = qName.getNamespaceURI();
        String string2 = qName.getLocalPart();
        return new PrefixedQName(string, string2, this.prefix);
    }

    public void setFaultString(String string, Locale locale) throws SOAPException {
        this.fault.setFaultString(string);
        this.locale = locale;
    }

    public Locale getFaultStringLocale() {
        return this.locale;
    }

    private Detail convertToDetail(AxisFault axisFault) throws SOAPException {
        this.detail = new Detail();
        Element[] elementArray = axisFault.getFaultDetails();
        axisFault.setFaultDetail(new Element[0]);
        for (int i = 0; i < elementArray.length; ++i) {
            Element element = elementArray[i];
            DetailEntry detailEntry = this.detail.addDetailEntry(new PrefixedQName(element.getNamespaceURI(), element.getLocalName(), element.getPrefix()));
            SOAPFault.copyChildren(detailEntry, element);
        }
        return this.detail;
    }

    private static void copyChildren(SOAPElement sOAPElement, Element element) throws SOAPException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                sOAPElement.addTextNode(node.getNodeValue());
                break;
            }
            if (node.getNodeType() != 1) continue;
            String string = node.getNamespaceURI();
            SOAPElement sOAPElement2 = null;
            sOAPElement2 = string == null ? sOAPElement.addChildElement(node.getLocalName()) : sOAPElement.addChildElement(node.getLocalName(), node.getPrefix(), string);
            SOAPFault.copyChildren(sOAPElement2, (Element)node);
        }
    }
}

