/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.monitor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SOAPMonitorService
extends HttpServlet {
    private static ServerSocket server_socket = null;
    private static Vector connections = null;

    public static void publishMessage(Long l, Integer n, String string, String string2) {
        if (connections != null) {
            Enumeration enumeration = connections.elements();
            while (enumeration.hasMoreElements()) {
                ConnectionThread connectionThread = (ConnectionThread)enumeration.nextElement();
                connectionThread.publishMessage(l, n, string, string2);
            }
        }
    }

    public void init() throws ServletException {
        if (connections == null) {
            connections = new Vector();
        }
        if (server_socket == null) {
            ServletConfig servletConfig = super.getServletConfig();
            String string = servletConfig.getInitParameter("SOAPMonitorPort");
            if (string == null) {
                string = "0";
            }
            try {
                server_socket = new ServerSocket(Integer.parseInt(string));
            }
            catch (Exception exception) {
                server_socket = null;
            }
            if (server_socket != null) {
                new Thread(new ServerSocketThread()).start();
            }
        }
    }

    public void destroy() {
        Enumeration enumeration = connections.elements();
        while (enumeration.hasMoreElements()) {
            ConnectionThread connectionThread = (ConnectionThread)enumeration.nextElement();
            connectionThread.close();
        }
        if (server_socket != null) {
            try {
                server_socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            server_socket = null;
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        int n = 0;
        if (server_socket != null) {
            n = server_socket.getLocalPort();
        }
        httpServletResponse.setContentType("text/html");
        httpServletResponse.getWriter().println("<html>");
        httpServletResponse.getWriter().println("<head>");
        httpServletResponse.getWriter().println("<title>SOAP Monitor</title>");
        httpServletResponse.getWriter().println("</head>");
        httpServletResponse.getWriter().println("<body>");
        httpServletResponse.getWriter().println("<object classid=\"clsid:8AD9C840-044E-11D1-B3E9-00805F499D93\" width=100% height=100% codebase=\"http://java.sun.com/products/plugin/1.3/jinstall-13-win32.cab#Version=1,3,0,0\">");
        httpServletResponse.getWriter().println("<param name=code value=SOAPMonitorApplet.class>");
        httpServletResponse.getWriter().println("<param name=\"type\" value=\"application/x-java-applet;version=1.3\">");
        httpServletResponse.getWriter().println("<param name=\"scriptable\" value=\"false\">");
        httpServletResponse.getWriter().println("<param name=\"port\" value=\"" + n + "\">");
        httpServletResponse.getWriter().println("<comment>");
        httpServletResponse.getWriter().println("<embed type=\"application/x-java-applet;version=1.3\" code=SOAPMonitorApplet.class width=100% height=100% port=\"" + n + "\" scriptable=false pluginspage=\"http://java.sun.com/products/plugin/1.3/plugin-install.html\">");
        httpServletResponse.getWriter().println("<noembed>");
        httpServletResponse.getWriter().println("</comment>");
        httpServletResponse.getWriter().println("</noembed>");
        httpServletResponse.getWriter().println("</embed>");
        httpServletResponse.getWriter().println("</object>");
        httpServletResponse.getWriter().println("</body>");
        httpServletResponse.getWriter().println("</html>");
    }

    class ConnectionThread
    implements Runnable {
        private Socket socket = null;
        private ObjectInputStream in = null;
        private ObjectOutputStream out = null;
        private boolean closed = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectionThread(Socket socket) {
            this.socket = socket;
            try {
                this.out = new ObjectOutputStream(this.socket.getOutputStream());
                this.out.flush();
                this.in = new ObjectInputStream(this.socket.getInputStream());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Vector vector = connections;
            synchronized (vector) {
                connections.addElement(this);
            }
        }

        public void close() {
            this.closed = true;
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            try {
                while (!this.closed) {
                    object = this.in.readObject();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = connections;
            synchronized (object) {
                connections.removeElement(this);
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.out = null;
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.in = null;
            }
            this.close();
        }

        public synchronized void publishMessage(Long l, Integer n, String string, String string2) {
            if (this.out != null) {
                try {
                    switch (n) {
                        case 0: {
                            this.out.writeObject(n);
                            this.out.writeObject(l);
                            this.out.writeObject(string);
                            this.out.writeObject(string2);
                            this.out.flush();
                            break;
                        }
                        case 1: {
                            this.out.writeObject(n);
                            this.out.writeObject(l);
                            this.out.writeObject(string2);
                            this.out.flush();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class ServerSocketThread
    implements Runnable {
        ServerSocketThread() {
        }

        public void run() {
            while (server_socket != null) {
                try {
                    Socket socket = server_socket.accept();
                    new Thread(new ConnectionThread(socket)).start();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

