/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.providers.java;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Vector;
import javax.wsdl.OperationType;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.NodeImpl;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCHeaderParam;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.providers.java.JavaProvider;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;
import org.xml.sax.SAXException;

public class RPCProvider
extends JavaProvider {
    protected static Log log = LogFactory.getLog(RPCProvider.class.getName());

    public void processMessage(MessageContext messageContext, SOAPEnvelope sOAPEnvelope, SOAPEnvelope sOAPEnvelope2, Object object) throws Exception {
        Object object2;
        Object object3;
        Serializable serializable;
        Object object4;
        Object object5;
        if (log.isDebugEnabled()) {
            log.debug("Enter: RPCProvider.processMessage()");
        }
        SOAPService sOAPService = messageContext.getService();
        ServiceDesc serviceDesc = sOAPService.getServiceDescription();
        OperationDesc operationDesc = messageContext.getOperation();
        Vector vector = sOAPEnvelope.getBodyElements();
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage("bodyElems00", "" + vector.size()));
            if (vector.size() > 0) {
                log.debug(Messages.getMessage("bodyIs00", "" + vector.get(0)));
            }
        }
        RPCElement rPCElement = null;
        for (int i = 0; rPCElement == null && i < vector.size(); ++i) {
            if (!(vector.get(i) instanceof RPCElement)) {
                Serializable serializable2;
                object5 = (SOAPBodyElement)vector.get(i);
                if (!((MessageElement)object5).isRoot() || operationDesc == null || ((MessageElement)object5).getID() != null || (serializable2 = operationDesc.getParameter(i)) == null) continue;
                object4 = ((MessageElement)object5).getValueAsType(((ParameterDesc)serializable2).getTypeQName());
                rPCElement = new RPCElement("", operationDesc.getName(), new Object[]{object4});
                continue;
            }
            rPCElement = (RPCElement)vector.get(i);
        }
        if (rPCElement == null) {
            if (!serviceDesc.getStyle().equals(Style.DOCUMENT)) {
                throw new Exception(Messages.getMessage("noBody00"));
            }
            ArrayList arrayList = serviceDesc.getOperations();
            for (Serializable serializable2 : arrayList) {
                if (((OperationDesc)serializable2).getNumInParams() != 0) continue;
                messageContext.setOperation((OperationDesc)serializable2);
                rPCElement = new RPCElement(((OperationDesc)serializable2).getName());
                break;
            }
            if (rPCElement == null) {
                throw new Exception(Messages.getMessage("noBody00"));
            }
        }
        String string = rPCElement.getMethodName();
        object5 = null;
        try {
            object5 = rPCElement.getParams();
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                throw sAXException.getException();
            }
            throw sAXException;
        }
        int n = ((Vector)object5).size();
        operationDesc = messageContext.getOperation();
        if (operationDesc == null) {
            object4 = new QName(rPCElement.getNamespaceURI(), rPCElement.getName());
            operationDesc = serviceDesc.getOperationByElementQName((QName)object4);
            if (operationDesc == null) {
                SOAPConstants sOAPConstants;
                SOAPConstants sOAPConstants2 = sOAPConstants = messageContext == null ? SOAPConstants.SOAP11_CONSTANTS : messageContext.getSOAPConstants();
                if (sOAPConstants == SOAPConstants.SOAP12_CONSTANTS) {
                    AxisFault axisFault = new AxisFault(Constants.FAULT_SOAP12_SENDER, Messages.getMessage("noSuchOperation", string), null, null);
                    axisFault.addFaultSubCode(Constants.FAULT_SUBCODE_PROC_NOT_PRESENT);
                    throw new SAXException(axisFault);
                }
                throw new AxisFault("Client", Messages.getMessage("noSuchOperation", string), null, null);
            }
            messageContext.setOperation(operationDesc);
        }
        object4 = new Object[operationDesc.getNumParams()];
        ArrayList<RPCParam> arrayList = new ArrayList<RPCParam>();
        for (int i = 0; i < n; ++i) {
            RPCParam rPCParam = (RPCParam)((Vector)object5).get(i);
            Object object6 = rPCParam.getObjectValue();
            serializable = rPCParam.getParamDesc();
            if (serializable != null && ((ParameterDesc)serializable).getJavaType() != null) {
                object3 = ((ParameterDesc)serializable).getJavaType();
                object6 = JavaUtils.convert(object6, (Class)object3);
                rPCParam.setObjectValue(object6);
                if (((ParameterDesc)serializable).getMode() == 3) {
                    arrayList.add(rPCParam);
                }
            }
            if (serializable == null || ((ParameterDesc)serializable).getOrder() == -1) {
                object4[i] = object6;
            } else {
                object4[((ParameterDesc)serializable).getOrder()] = object6;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("  " + Messages.getMessage("value00", "" + object4[i]));
        }
        String string2 = (String)sOAPService.getOption("allowedMethods");
        this.checkMethodName(messageContext, string2, operationDesc.getName());
        int n2 = n;
        for (int i = 0; i < ((Object[])object4).length; ++i) {
            serializable = operationDesc.getParameter(i);
            if (((ParameterDesc)serializable).getMode() == 1) continue;
            object3 = ((ParameterDesc)serializable).getJavaType();
            if (object3 != null && Holder.class.isAssignableFrom((Class<?>)object3)) {
                int n3 = n2++;
                if (((ParameterDesc)serializable).getOrder() != -1) {
                    n3 = ((ParameterDesc)serializable).getOrder();
                }
                if (object4[n3] != null) continue;
                object4[n3] = ((Class)object3).newInstance();
                object2 = new RPCParam(((ParameterDesc)serializable).getQName(), object4[n3]);
                ((RPCParam)object2).setParamDesc((ParameterDesc)serializable);
                arrayList.add((RPCParam)object2);
                continue;
            }
            throw new AxisFault(Messages.getMessage("badOutParameter00", "" + ((ParameterDesc)serializable).getQName(), operationDesc.getName()));
        }
        Object object7 = null;
        try {
            object7 = this.invokeMethod(messageContext, operationDesc.getMethod(), object, (Object[])object4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object3 = operationDesc.getMethod().toString();
            String string3 = "";
            for (int i = 0; i < ((Object[])object4).length; ++i) {
                string3 = object4[i] == null ? string3 + "null" : string3 + object4[i].getClass().getName();
                if (i + 1 >= ((Object[])object4).length) continue;
                string3 = string3 + ",";
            }
            log.info(Messages.getMessage("dispatchIAE00", new String[]{object3, string3}), illegalArgumentException);
            throw new AxisFault(Messages.getMessage("dispatchIAE00", new String[]{object3, string3}), illegalArgumentException);
        }
        if (OperationType.ONE_WAY.equals(operationDesc.getMep())) {
            return;
        }
        serializable = new RPCElement(string + "Response");
        ((NodeImpl)serializable).setPrefix(rPCElement.getPrefix());
        ((MessageElement)serializable).setNamespaceURI(rPCElement.getNamespaceURI());
        ((MessageElement)serializable).setEncodingStyle(messageContext.getEncodingStyle());
        if (operationDesc.getMethod().getReturnType() != Void.TYPE) {
            object3 = operationDesc.getReturnQName();
            if (object3 == null) {
                String string4 = rPCElement.getNamespaceURI();
                if (string4 == null || string4.length() == 0) {
                    string4 = serviceDesc.getDefaultNamespace();
                }
                object3 = new QName(messageContext.isEncoded() ? "" : string4, string + "Return");
            }
            RPCParam rPCParam = new RPCParam((QName)object3, object7);
            rPCParam.setParamDesc(operationDesc.getReturnParamDesc());
            if (!operationDesc.isReturnHeader()) {
                if (messageContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS && serviceDesc.getStyle().equals(Style.RPC)) {
                    object2 = new RPCParam(Constants.QNAME_RPC_RESULT, object3);
                    ((RPCParam)object2).setXSITypeGeneration(Boolean.FALSE);
                    ((RPCElement)serializable).addParam((RPCParam)object2);
                }
                ((RPCElement)serializable).addParam(rPCParam);
            } else {
                sOAPEnvelope2.addHeader(new RPCHeaderParam(rPCParam));
            }
        }
        if (!arrayList.isEmpty()) {
            for (RPCParam rPCParam : arrayList) {
                object2 = (Holder)rPCParam.getObjectValue();
                Object object8 = JavaUtils.getHolderValue(object2);
                ParameterDesc parameterDesc = rPCParam.getParamDesc();
                rPCParam.setObjectValue(object8);
                if (parameterDesc != null && parameterDesc.isOutHeader()) {
                    sOAPEnvelope2.addHeader(new RPCHeaderParam(rPCParam));
                    continue;
                }
                ((RPCElement)serializable).addParam(rPCParam);
            }
        }
        sOAPEnvelope2.addBodyElement((SOAPBodyElement)serializable);
    }

    protected Object invokeMethod(MessageContext messageContext, Method method, Object object, Object[] objectArray) throws Exception {
        return method.invoke(object, objectArray);
    }

    protected void checkMethodName(MessageContext messageContext, String string, String string2) throws Exception {
    }
}

