/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.server;

import java.util.Map;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.Constants;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.AxisClient;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.configuration.EngineConfigurationFactoryFinder;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.server.AxisServerFactory;
import org.apache.axis.server.DefaultAxisServerFactory;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class AxisServer
extends AxisEngine {
    protected static Log log = LogFactory.getLog(AxisServer.class.getName());
    private static Log tlog = LogFactory.getLog("org.apache.axis.TIME");
    private static AxisServerFactory factory = null;
    private AxisEngine clientEngine;
    private boolean running = true;

    public static AxisServer getServer(Map map) throws AxisFault {
        if (factory == null) {
            String string = AxisProperties.getProperty("axis.ServerFactory");
            if (string != null) {
                try {
                    Class clazz = ClassUtils.forName(string);
                    if (AxisServerFactory.class.isAssignableFrom(clazz)) {
                        factory = (AxisServerFactory)clazz.newInstance();
                    }
                }
                catch (Exception exception) {
                    log.error(Messages.getMessage("exception00"), exception);
                }
            }
            if (factory == null) {
                factory = new DefaultAxisServerFactory();
            }
        }
        return factory.getServer(map);
    }

    public AxisServer() {
        this(EngineConfigurationFactoryFinder.newFactory().getServerEngineConfig());
    }

    public AxisServer(EngineConfiguration engineConfiguration) {
        super(engineConfiguration);
        this.setShouldSaveConfig(true);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        this.init();
        this.running = true;
    }

    public void stop() {
        this.running = false;
    }

    public synchronized AxisEngine getClientEngine() {
        if (this.clientEngine == null) {
            this.clientEngine = new AxisClient();
        }
        return this.clientEngine;
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        block33: {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            long l6 = 0L;
            if (tlog.isDebugEnabled()) {
                l = System.currentTimeMillis();
            }
            if (log.isDebugEnabled()) {
                log.debug("Enter: AxisServer::invoke");
            }
            if (!this.isRunning()) {
                throw new AxisFault("Server.disabled", Messages.getMessage("serverDisabled00"), null, null);
            }
            String string = null;
            Handler handler = null;
            MessageContext messageContext2 = AxisServer.getCurrentMessageContext();
            try {
                AxisServer.setCurrentMessageContext(messageContext);
                string = messageContext.getStrProp("engine.handler");
                if (string != null) {
                    handler = this.getHandler(string);
                    if (handler == null) {
                        ClassLoader classLoader = messageContext.getClassLoader();
                        try {
                            log.debug(Messages.getMessage("tryingLoad00", string));
                            Class clazz = ClassUtils.forName(string, true, classLoader);
                            handler = (Handler)clazz.newInstance();
                        }
                        catch (Exception exception) {
                            handler = null;
                        }
                    }
                    if (tlog.isDebugEnabled()) {
                        l2 = System.currentTimeMillis();
                    }
                    if (handler == null) {
                        throw new AxisFault("Server.error", Messages.getMessage("noHandler00", string), null, null);
                    }
                    handler.invoke(messageContext);
                    if (tlog.isDebugEnabled()) {
                        l3 = System.currentTimeMillis();
                        tlog.debug("AxisServer.invoke " + string + " invoke=" + (l3 - l2) + " pre=" + (l2 - l));
                    }
                    break block33;
                }
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("defaultLogic00"));
                }
                string = messageContext.getTransportName();
                SimpleTargetedChain simpleTargetedChain = null;
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("transport01", "AxisServer.invoke", string));
                }
                if (tlog.isDebugEnabled()) {
                    l2 = System.currentTimeMillis();
                }
                if (string != null && (handler = this.getTransport(string)) != null && handler instanceof SimpleTargetedChain && (handler = (simpleTargetedChain = (SimpleTargetedChain)handler).getRequestHandler()) != null) {
                    handler.invoke(messageContext);
                }
                if (tlog.isDebugEnabled()) {
                    l3 = System.currentTimeMillis();
                }
                if ((handler = this.getGlobalRequest()) != null) {
                    handler.invoke(messageContext);
                }
                if ((handler = messageContext.getService()) == null) {
                    Message message = messageContext.getRequestMessage();
                    message.getSOAPEnvelope().getFirstBody();
                    handler = messageContext.getService();
                    if (handler == null) {
                        throw new AxisFault("Server.NoService", Messages.getMessage("noService05", "" + messageContext.getTargetService()), null, null);
                    }
                }
                if (tlog.isDebugEnabled()) {
                    l4 = System.currentTimeMillis();
                }
                this.initSOAPConstants(messageContext);
                try {
                    handler.invoke(messageContext);
                }
                catch (AxisFault axisFault) {
                    handler = this.getGlobalRequest();
                    if (handler != null) {
                        handler.onFault(messageContext);
                    }
                    throw axisFault;
                }
                if (tlog.isDebugEnabled()) {
                    l5 = System.currentTimeMillis();
                }
                if ((handler = this.getGlobalResponse()) != null) {
                    handler.invoke(messageContext);
                }
                if (simpleTargetedChain != null && (handler = simpleTargetedChain.getResponseHandler()) != null) {
                    handler.invoke(messageContext);
                }
                if (tlog.isDebugEnabled()) {
                    l6 = System.currentTimeMillis();
                    tlog.debug("AxisServer.invoke2  preTr=" + (l2 - l) + " tr=" + (l3 - l2) + " preInvoke=" + (l4 - l3) + " invoke=" + (l5 - l4) + " postInvoke=" + (l6 - l5) + " " + messageContext.getTargetService() + "." + (messageContext.getOperation() == null ? "" : messageContext.getOperation().getName()));
                }
            }
            catch (AxisFault axisFault) {
                throw axisFault;
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
            finally {
                AxisServer.setCurrentMessageContext(messageContext2);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: AxisServer::invoke");
        }
    }

    private void initSOAPConstants(MessageContext messageContext) throws AxisFault {
        Message message = messageContext.getRequestMessage();
        if (message == null) {
            return;
        }
        SOAPEnvelope sOAPEnvelope = message.getSOAPEnvelope();
        if (sOAPEnvelope == null) {
            return;
        }
        SOAPConstants sOAPConstants = sOAPEnvelope.getSOAPConstants();
        if (sOAPConstants == null) {
            return;
        }
        messageContext.setSOAPConstants(sOAPConstants);
    }

    public void generateWSDL(MessageContext messageContext) throws AxisFault {
        block21: {
            if (log.isDebugEnabled()) {
                log.debug("Enter: AxisServer::generateWSDL");
            }
            if (!this.isRunning()) {
                throw new AxisFault("Server.disabled", Messages.getMessage("serverDisabled00"), null, null);
            }
            String string = null;
            Handler handler = null;
            MessageContext messageContext2 = AxisServer.getCurrentMessageContext();
            try {
                AxisServer.setCurrentMessageContext(messageContext);
                string = messageContext.getStrProp("engine.handler");
                if (string != null) {
                    handler = this.getHandler(string);
                    if (handler == null) {
                        ClassLoader classLoader = messageContext.getClassLoader();
                        try {
                            log.debug(Messages.getMessage("tryingLoad00", string));
                            Class clazz = ClassUtils.forName(string, true, classLoader);
                            handler = (Handler)clazz.newInstance();
                        }
                        catch (Exception exception) {
                            throw new AxisFault("Server.error", Messages.getMessage("noHandler00", string), null, null);
                        }
                    }
                    handler.generateWSDL(messageContext);
                    break block21;
                }
                log.debug(Messages.getMessage("defaultLogic00"));
                string = messageContext.getTransportName();
                SimpleTargetedChain simpleTargetedChain = null;
                if (log.isDebugEnabled()) {
                    log.debug(Messages.getMessage("transport01", "AxisServer.generateWSDL", string));
                }
                if (string != null && (handler = this.getTransport(string)) != null && handler instanceof SimpleTargetedChain && (handler = (simpleTargetedChain = (SimpleTargetedChain)handler).getRequestHandler()) != null) {
                    handler.generateWSDL(messageContext);
                }
                if ((handler = this.getGlobalRequest()) != null) {
                    handler.generateWSDL(messageContext);
                }
                if ((handler = messageContext.getService()) == null) {
                    Message message = messageContext.getRequestMessage();
                    if (message != null) {
                        message.getSOAPEnvelope().getFirstBody();
                        handler = messageContext.getService();
                    }
                    if (handler == null) {
                        throw new AxisFault(Constants.QNAME_NO_SERVICE_FAULT_CODE, Messages.getMessage("noService05", "" + messageContext.getTargetService()), null, null);
                    }
                }
                handler.generateWSDL(messageContext);
                handler = this.getGlobalResponse();
                if (handler != null) {
                    handler.generateWSDL(messageContext);
                }
                if (simpleTargetedChain != null && (handler = simpleTargetedChain.getResponseHandler()) != null) {
                    handler.generateWSDL(messageContext);
                }
            }
            catch (AxisFault axisFault) {
                throw axisFault;
            }
            catch (Exception exception) {
                throw AxisFault.makeFault(exception);
            }
            finally {
                AxisServer.setCurrentMessageContext(messageContext2);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: AxisServer::generateWSDL");
        }
    }
}

