/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.server;

import java.io.File;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.server.AxisServer;
import org.apache.axis.server.AxisServerFactory;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class DefaultAxisServerFactory
implements AxisServerFactory {
    protected static Log log = LogFactory.getLog(DefaultAxisServerFactory.class.getName());

    public AxisServer getServer(Map map) throws AxisFault {
        log.debug("Enter: DefaultAxisServerFactory::getServer");
        AxisServer axisServer = DefaultAxisServerFactory.createServer(map);
        if (axisServer != null) {
            File file;
            String string;
            if (map != null) {
                axisServer.setOptionDefault("attachments.Directory", (String)map.get("axis.attachments.Directory"));
                axisServer.setOptionDefault("attachments.Directory", (String)map.get("servlet.realpath"));
            }
            if ((string = (String)axisServer.getOption("attachments.Directory")) != null && !(file = new File(string)).isDirectory()) {
                file.mkdirs();
            }
        }
        log.debug("Exit: DefaultAxisServerFactory::getServer");
        return axisServer;
    }

    private static AxisServer createServer(Map map) {
        EngineConfiguration engineConfiguration = DefaultAxisServerFactory.getEngineConfiguration(map);
        return engineConfiguration == null ? new AxisServer() : new AxisServer(engineConfiguration);
    }

    private static EngineConfiguration getEngineConfiguration(Map map) {
        String string;
        log.debug("Enter: DefaultAxisServerFactory::getEngineConfiguration");
        EngineConfiguration engineConfiguration = null;
        if (map != null) {
            try {
                engineConfiguration = (EngineConfiguration)map.get("engineConfig");
            }
            catch (ClassCastException classCastException) {
                log.warn(Messages.getMessage("engineConfigWrongClass00"), classCastException);
            }
        }
        if (engineConfiguration == null && (string = AxisProperties.getProperty("axis.engineConfigClass")) != null) {
            try {
                Class clazz = ClassUtils.forName(string);
                engineConfiguration = (EngineConfiguration)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.warn(Messages.getMessage("engineConfigNoClass00", string), classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                log.warn(Messages.getMessage("engineConfigNoInstance00", string), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.warn(Messages.getMessage("engineConfigIllegalAccess00", string), illegalAccessException);
            }
            catch (ClassCastException classCastException) {
                log.warn(Messages.getMessage("engineConfigWrongClass01", string), classCastException);
            }
        }
        log.debug("Exit: DefaultAxisServerFactory::getEngineConfiguration");
        return engineConfiguration;
    }
}

