/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.configuration.EngineConfigurationFactoryFinder;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AxisServlet;
import org.apache.axis.utils.JavaUtils;
import org.apache.commons.logging.Log;

public class AxisServletBase
extends HttpServlet {
    protected AxisServer axisServer = null;
    private static Log log = LogFactory.getLog(AxisServlet.class.getName());
    private static boolean isDebug = false;
    private static int loadCounter = 0;
    private static Object loadCounterLock = new Object();
    protected static final String ATTR_AXIS_ENGINE = "AxisEngine";
    private String webInfPath = null;
    private String homeDir = null;
    private boolean isDevelopment;
    private static final String INIT_PROPERTY_DEVELOPMENT_SYSTEM = "axis.development.system";

    public void init() throws ServletException {
        ServletContext servletContext = this.getServletConfig().getServletContext();
        this.webInfPath = servletContext.getRealPath("/WEB-INF");
        this.homeDir = servletContext.getRealPath("/");
        isDebug = log.isDebugEnabled();
        if (log.isDebugEnabled()) {
            log.debug("In AxisServletBase init");
        }
        this.isDevelopment = JavaUtils.isTrueExplicitly(this.getOption(servletContext, INIT_PROPERTY_DEVELOPMENT_SYSTEM, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        super.destroy();
        if (this.axisServer != null) {
            AxisServer axisServer = this.axisServer;
            synchronized (axisServer) {
                if (this.axisServer != null) {
                    this.axisServer.cleanup();
                    this.axisServer = null;
                    AxisServletBase.storeEngine(this, null);
                }
            }
        }
    }

    public AxisServer getEngine() throws AxisFault {
        if (this.axisServer == null) {
            this.axisServer = AxisServletBase.getEngine(this);
        }
        return this.axisServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AxisServer getEngine(HttpServlet httpServlet) throws AxisFault {
        ServletContext servletContext;
        AxisServer axisServer = null;
        if (isDebug) {
            log.debug("Enter: getEngine()");
        }
        ServletContext servletContext2 = servletContext = httpServlet.getServletContext();
        synchronized (servletContext2) {
            axisServer = AxisServletBase.retrieveEngine(httpServlet);
            if (axisServer == null) {
                Map map = AxisServletBase.getEngineEnvironment(httpServlet);
                axisServer = AxisServer.getServer(map);
                axisServer.setName(httpServlet.getServletName());
                AxisServletBase.storeEngine(httpServlet, axisServer);
            }
        }
        if (isDebug) {
            log.debug("Exit: getEngine()");
        }
        return axisServer;
    }

    private static void storeEngine(HttpServlet httpServlet, AxisServer axisServer) {
        ServletContext servletContext = httpServlet.getServletContext();
        String string = httpServlet.getServletName();
        if (axisServer == null) {
            servletContext.removeAttribute(string + ATTR_AXIS_ENGINE);
            AxisServer axisServer2 = (AxisServer)servletContext.getAttribute(ATTR_AXIS_ENGINE);
            if (axisServer2 != null && httpServlet.getServletName().equals(axisServer2.getName())) {
                servletContext.removeAttribute(ATTR_AXIS_ENGINE);
            }
        } else {
            if (servletContext.getAttribute(ATTR_AXIS_ENGINE) == null) {
                servletContext.setAttribute(ATTR_AXIS_ENGINE, axisServer);
            }
            servletContext.setAttribute(string + ATTR_AXIS_ENGINE, axisServer);
        }
    }

    private static AxisServer retrieveEngine(HttpServlet httpServlet) {
        Object object = httpServlet.getServletContext().getAttribute(httpServlet.getServletName() + ATTR_AXIS_ENGINE);
        if (object == null) {
            object = httpServlet.getServletContext().getAttribute(ATTR_AXIS_ENGINE);
        }
        if (object instanceof AxisServer) {
            AxisServer axisServer = (AxisServer)object;
            if (axisServer != null && httpServlet.getServletName().equals(axisServer.getName())) {
                return axisServer;
            }
            return null;
        }
        return null;
    }

    protected static Map getEngineEnvironment(HttpServlet httpServlet) {
        EngineConfiguration engineConfiguration;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = httpServlet.getInitParameter("axis.attachments.Directory");
        if (string != null) {
            hashMap.put("axis.attachments.Directory", string);
        }
        ServletContext servletContext = httpServlet.getServletContext();
        hashMap.put("servletContext", servletContext);
        String string2 = servletContext.getRealPath("/WEB-INF");
        if (string2 != null) {
            hashMap.put("servlet.realpath", string2 + File.separator + "attachments");
        }
        if ((engineConfiguration = EngineConfigurationFactoryFinder.newFactory(httpServlet).getServerEngineConfig()) != null) {
            hashMap.put("engineConfig", engineConfiguration);
        }
        return hashMap;
    }

    public static int getLoadCounter() {
        return loadCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void incLockCounter() {
        Object object = loadCounterLock;
        synchronized (object) {
            ++loadCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void decLockCounter() {
        Object object = loadCounterLock;
        synchronized (object) {
            --loadCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        AxisServletBase.incLockCounter();
        try {
            super.service(httpServletRequest, httpServletResponse);
        }
        finally {
            AxisServletBase.decLockCounter();
        }
    }

    protected String getWebappBase(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(httpServletRequest.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        if (httpServletRequest.getServerPort() != 80) {
            stringBuffer.append(":");
            stringBuffer.append(httpServletRequest.getServerPort());
        }
        stringBuffer.append(httpServletRequest.getContextPath());
        return stringBuffer.toString();
    }

    public ServletContext getServletContext() {
        return this.getServletConfig().getServletContext();
    }

    protected String getWebInfPath() {
        return this.webInfPath;
    }

    protected String getHomeDir() {
        return this.homeDir;
    }

    protected String getOption(ServletContext servletContext, String string, String string2) {
        String string3 = AxisProperties.getProperty(string);
        if (string3 == null) {
            string3 = this.getInitParameter(string);
        }
        if (string3 == null) {
            string3 = servletContext.getInitParameter(string);
        }
        try {
            AxisServer axisServer = AxisServletBase.getEngine(this);
            if (string3 == null && axisServer != null) {
                string3 = (String)axisServer.getOption(string);
            }
        }
        catch (AxisFault axisFault) {
            // empty catch block
        }
        return string3 != null ? string3 : string2;
    }

    public boolean isDevelopment() {
        return this.isDevelopment;
    }
}

