/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends FilterInputStream {
    protected long chunkSize = 0L;
    protected volatile boolean closed = false;
    private static final int maxCharLong = Long.toHexString(Long.MAX_VALUE).toString().length();
    private byte[] buf = new byte[maxCharLong + 2];

    private ChunkedInputStream() {
        super(null);
    }

    public ChunkedInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public synchronized int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        try {
            if (this.chunkSize < 1L && 0L == this.getChunked()) {
                return -1;
            }
            int n = this.in.read();
            if (n > 0) {
                --this.chunkSize;
            }
            return n;
        }
        catch (IOException iOException) {
            this.closed = true;
            throw iOException;
        }
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            return -1;
        }
        int n3 = 0;
        int n4 = 0;
        try {
            do {
                if (this.chunkSize < 1L && 0L == this.getChunked()) {
                    if (n3 == 0) {
                        return -1;
                    }
                    return n3;
                }
                n4 = this.in.read(byArray, n + n3, Math.min(n2 - n3, (int)Math.min(this.chunkSize, Integer.MAX_VALUE)));
                if (n4 <= 0) continue;
                n3 += n4;
                this.chunkSize -= (long)n4;
            } while (n2 - n3 > 0 && n4 > -1);
        }
        catch (IOException iOException) {
            this.closed = true;
            throw iOException;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        if (this.closed) {
            return 0L;
        }
        long l2 = 0L;
        byte[] byArray = new byte[1024];
        int n = -1;
        do {
            if ((n = this.read(byArray, 0, byArray.length)) <= 0) continue;
            l2 += (long)n;
        } while (n != -1 && l2 < l);
        return l2;
    }

    public int available() throws IOException {
        if (this.closed) {
            return 0;
        }
        int n = (int)Math.min(this.chunkSize, Integer.MAX_VALUE);
        return Math.min(n, this.in.available());
    }

    protected long getChunked() throws IOException {
        int n = 0;
        this.chunkSize = -1L;
        int n2 = -1;
        do {
            if ((n2 = this.in.read()) <= -1 || n2 == 13 || n2 == 10 || n2 == 32 || n2 == 9) continue;
            this.buf[n++] = (byte)n2;
        } while (n2 > -1 && (n2 != 10 || n == 0) && n < this.buf.length);
        if (n2 < 0) {
            this.closed = true;
        }
        String string = new String(this.buf, 0, n);
        if (n > maxCharLong) {
            this.closed = true;
            throw new IOException("Chunked input stream failed to receive valid chunk size:" + string);
        }
        try {
            this.chunkSize = Long.parseLong(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            this.closed = true;
            throw new IOException("'" + string + "' " + numberFormatException.getMessage());
        }
        if (this.chunkSize < 0L) {
            this.closed = true;
        }
        if (this.chunkSize == 0L) {
            this.closed = true;
            if (this.in.read() != -1) {
                this.in.read();
            }
        }
        if (this.chunkSize != 0L && n2 < 0) {
            throw new IOException("HTTP Chunked stream closed in middle of chunk.");
        }
        if (this.chunkSize < 0L) {
            throw new IOException("HTTP Chunk size received " + this.chunkSize + " is less than zero.");
        }
        return this.chunkSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        object = new byte[1024];
        int n = -1;
        while ((n = this.read((byte[])object, 0, ((Object)object).length)) != -1) {
        }
    }

    public void reset() throws IOException {
        throw new IOException("Don't support marked streams");
    }

    public boolean markSupported() {
        return false;
    }
}

