/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends FilterOutputStream {
    boolean eos = false;
    static final byte[] CRLF = "\r\n".getBytes();
    static final byte[] LAST_TOKEN = "0\r\n\r\n".getBytes();

    private ChunkedOutputStream() {
        super(null);
    }

    public ChunkedOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n}, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        this.out.write(Integer.toHexString(n2).getBytes());
        this.out.write(CRLF);
        this.out.write(byArray, n, n2);
        this.out.write(CRLF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eos() throws IOException {
        ChunkedOutputStream chunkedOutputStream = this;
        synchronized (chunkedOutputStream) {
            if (this.eos) {
                return;
            }
            this.eos = true;
        }
        this.out.write(LAST_TOKEN);
        this.out.flush();
    }

    public void close() throws IOException {
        this.eos();
        this.out.close();
    }
}

