/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AbstractQueryStringHandler;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;

public class QSMethodHandler
extends AbstractQueryStringHandler {
    public void invoke(MessageContext messageContext) throws AxisFault {
        this.configureFromContext(messageContext);
        AxisServer axisServer = (AxisServer)messageContext.getProperty("transport.http.plugin.engine");
        PrintWriter printWriter = (PrintWriter)messageContext.getProperty("transport.http.plugin.writer");
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpServletResponse httpServletResponse = (HttpServletResponse)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
        String string = null;
        String string2 = "";
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (string3.equalsIgnoreCase("method")) {
                string = httpServletRequest.getParameter(string3);
                continue;
            }
            string2 = string2 + "<" + string3 + ">" + httpServletRequest.getParameter(string3) + "</" + string3 + ">";
        }
        if (string == null) {
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setStatus(400);
            printWriter.println("<h2>" + Messages.getMessage("error00") + ":  " + Messages.getMessage("invokeGet00") + "</h2>");
            printWriter.println("<p>" + Messages.getMessage("noMethod01") + "</p>");
        } else {
            this.invokeEndpointFromGet(messageContext, httpServletResponse, printWriter, string, string2);
        }
    }

    private void invokeEndpointFromGet(MessageContext messageContext, HttpServletResponse httpServletResponse, PrintWriter printWriter, String string, String string2) throws AxisFault {
        String string3 = "<" + string + ">" + string2 + "</" + string + ">";
        String string4 = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body>" + string3 + "</SOAP-ENV:Body>" + "</SOAP-ENV:Envelope>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string4.getBytes());
        Message message = null;
        try {
            AxisServer axisServer = (AxisServer)messageContext.getProperty("transport.http.plugin.engine");
            Message message2 = new Message((Object)byteArrayInputStream, false);
            messageContext.setRequestMessage(message2);
            axisServer.invoke(messageContext);
            message = messageContext.getResponseMessage();
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            httpServletResponse.setHeader("Pragma", "no-cache");
            if (message == null) {
                throw new Exception(Messages.getMessage("noResponse01"));
            }
        }
        catch (AxisFault axisFault) {
            this.processAxisFault(axisFault);
            this.configureResponseFromAxisFault(httpServletResponse, axisFault);
            if (message == null) {
                message = new Message(axisFault);
                message.setMessageContext(messageContext);
            }
        }
        catch (Exception exception) {
            httpServletResponse.setStatus(500);
            message = this.convertExceptionToAxisFault(exception, message);
        }
        httpServletResponse.setContentType("text/xml");
        printWriter.println(message.getSOAPPartAsString());
    }
}

