/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.http;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.AbstractQueryStringHandler;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QSWSDLHandler
extends AbstractQueryStringHandler {
    public void invoke(MessageContext messageContext) throws AxisFault {
        block7: {
            this.configureFromContext(messageContext);
            AxisServer axisServer = (AxisServer)messageContext.getProperty("transport.http.plugin.engine");
            PrintWriter printWriter = (PrintWriter)messageContext.getProperty("transport.http.plugin.writer");
            HttpServletResponse httpServletResponse = (HttpServletResponse)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
            try {
                axisServer.generateWSDL(messageContext);
                Document document = (Document)messageContext.getProperty("WSDL");
                if (document != null) {
                    try {
                        this.updateSoapAddressLocationURLs(document, messageContext);
                    }
                    catch (RuntimeException runtimeException) {
                        this.log.warn("Failed to update soap:address location URL(s) in WSDL.", runtimeException);
                    }
                    httpServletResponse.setContentType("text/xml; charset=" + XMLUtils.getEncoding().toLowerCase());
                    this.reportWSDL(document, printWriter);
                    break block7;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("processWsdlRequest: failed to create WSDL");
                }
                this.reportNoWSDL(httpServletResponse, printWriter, "noWSDL02", null);
            }
            catch (AxisFault axisFault) {
                if (axisFault.getFaultCode().equals(Constants.QNAME_NO_SERVICE_FAULT_CODE)) {
                    this.processAxisFault(axisFault);
                    httpServletResponse.setStatus(404);
                    this.reportNoWSDL(httpServletResponse, printWriter, "noWSDL01", axisFault);
                }
                throw axisFault;
            }
        }
    }

    public void reportWSDL(Document document, PrintWriter printWriter) {
        XMLUtils.PrettyDocumentToWriter(document, printWriter);
    }

    public void reportNoWSDL(HttpServletResponse httpServletResponse, PrintWriter printWriter, String string, AxisFault axisFault) {
        httpServletResponse.setStatus(404);
        httpServletResponse.setContentType("text/html");
        printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        printWriter.println("<p>" + Messages.getMessage("noWSDL00") + "</p>");
        if (string != null) {
            printWriter.println("<p>" + Messages.getMessage(string) + "</p>");
        }
        if (axisFault != null && this.isDevelopment()) {
            this.writeFault(printWriter, axisFault);
        }
    }

    protected void updateSoapAddressLocationURLs(Document document, MessageContext messageContext) throws AxisFault {
        Set set;
        try {
            set = this.getDeployedServiceNames(messageContext);
        }
        catch (ConfigurationException configurationException) {
            throw new AxisFault("Failed to determine deployed service names.", configurationException);
        }
        NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "port");
        if (nodeList != null) {
            String string = this.getEndpointURL(messageContext);
            String string2 = string.substring(0, string.lastIndexOf("/") + 1);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                Node node = element.getAttributes().getNamedItem("name");
                if (node == null) continue;
                String string3 = node.getNodeValue();
                NodeList nodeList2 = element.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap/", "address");
                if (nodeList2 == null || nodeList2.getLength() == 0) {
                    nodeList2 = element.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap12/", "address");
                }
                if (nodeList2 == null) continue;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element element2 = (Element)nodeList2.item(j);
                    Node node2 = element2.getAttributes().getNamedItem("location");
                    if (node2 == null) continue;
                    String string4 = node2.getNodeValue();
                    String string5 = string4.substring(string4.lastIndexOf("/") + 1);
                    String string6 = this.getNewServiceName(set, string5, string3);
                    if (string6 != null) {
                        String string7 = string2 + string6;
                        node2.setNodeValue(string7);
                        this.log.debug("Setting soap:address location values in WSDL for port " + string3 + " to: " + string7);
                        continue;
                    }
                    this.log.debug("For WSDL port: " + string3 + ", unable to match port name or the last component of " + "the SOAP address url with a " + "service name deployed in server-config.wsdd.  Leaving SOAP address: " + string4 + " unmodified.");
                }
            }
        }
    }

    private String getNewServiceName(Set set, String string, String string2) {
        String string3 = null;
        if (set.contains(string)) {
            string3 = string;
        } else if (set.contains(string2)) {
            string3 = string2;
        }
        return string3;
    }

    private Set getDeployedServiceNames(MessageContext messageContext) throws ConfigurationException {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = messageContext.getAxisEngine().getConfig().getDeployedServices();
        while (iterator.hasNext()) {
            ServiceDesc serviceDesc = (ServiceDesc)iterator.next();
            hashSet.add(serviceDesc.getName());
        }
        return hashSet;
    }

    protected String getEndpointURL(MessageContext messageContext) throws AxisFault {
        String string = messageContext.getStrProp("axis.wsdlgen.serv.loc.url");
        if (string == null) {
            string = messageContext.getService().getInitializedServiceDesc(messageContext).getEndpointURL();
        }
        if (string == null) {
            string = messageContext.getStrProp("transport.url");
        }
        return string;
    }
}

