/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.axis.components.jms.JMSVendorAdapter;
import org.apache.axis.transport.jms.InvokeException;
import org.apache.axis.transport.jms.InvokeTimeoutException;
import org.apache.axis.transport.jms.JMSConnectorManager;
import org.apache.axis.transport.jms.JMSEndpoint;
import org.apache.axis.transport.jms.JMSURLHelper;
import org.apache.axis.transport.jms.MapUtils;
import org.apache.axis.transport.jms.Subscription;

public abstract class JMSConnector {
    protected int m_numRetries;
    protected long m_connectRetryInterval;
    protected long m_interactRetryInterval;
    protected long m_timeoutTime;
    protected long m_poolTimeout;
    protected AsyncConnection m_receiveConnection;
    protected SyncConnection m_sendConnection;
    protected int m_numSessions;
    protected boolean m_allowReceive;
    protected JMSVendorAdapter m_adapter;
    protected JMSURLHelper m_jmsurl;

    public JMSConnector(ConnectionFactory connectionFactory, int n, int n2, long l, long l2, long l3, boolean bl, String string, String string2, String string3, JMSVendorAdapter jMSVendorAdapter, JMSURLHelper jMSURLHelper) throws JMSException {
        this.m_numRetries = n;
        this.m_connectRetryInterval = l;
        this.m_interactRetryInterval = l2;
        this.m_timeoutTime = l3;
        this.m_poolTimeout = l3 / (long)n;
        this.m_numSessions = n2;
        this.m_allowReceive = bl;
        this.m_adapter = jMSVendorAdapter;
        this.m_jmsurl = jMSURLHelper;
        javax.jms.Connection connection = this.createConnectionWithRetry(connectionFactory, string2, string3);
        this.m_sendConnection = this.createSyncConnection(connectionFactory, connection, this.m_numSessions, "SendThread", string, string2, string3);
        this.m_sendConnection.start();
        if (this.m_allowReceive) {
            javax.jms.Connection connection2 = this.createConnectionWithRetry(connectionFactory, string2, string3);
            this.m_receiveConnection = this.createAsyncConnection(connectionFactory, connection2, "ReceiveThread", string, string2, string3);
            this.m_receiveConnection.start();
        }
    }

    public int getNumRetries() {
        return this.m_numRetries;
    }

    public int numSessions() {
        return this.m_numSessions;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.getSendConnection().getConnectionFactory();
    }

    public String getClientID() {
        return this.getSendConnection().getClientID();
    }

    public String getUsername() {
        return this.getSendConnection().getUsername();
    }

    public String getPassword() {
        return this.getSendConnection().getPassword();
    }

    public JMSVendorAdapter getVendorAdapter() {
        return this.m_adapter;
    }

    public JMSURLHelper getJMSURL() {
        return this.m_jmsurl;
    }

    protected javax.jms.Connection createConnectionWithRetry(ConnectionFactory connectionFactory, String string, String string2) throws JMSException {
        javax.jms.Connection connection = null;
        int n = 1;
        while (connection == null) {
            try {
                connection = this.internalConnect(connectionFactory, string, string2);
            }
            catch (JMSException jMSException) {
                if (!this.m_adapter.isRecoverable(jMSException, 1) || n == this.m_numRetries) {
                    throw jMSException;
                }
                try {
                    Thread.sleep(this.m_connectRetryInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++n;
        }
        return connection;
    }

    public void stop() {
        JMSConnectorManager.getInstance().removeConnectorFromPool(this);
        this.m_sendConnection.stopConnection();
        if (this.m_allowReceive) {
            this.m_receiveConnection.stopConnection();
        }
    }

    public void start() {
        this.m_sendConnection.startConnection();
        if (this.m_allowReceive) {
            this.m_receiveConnection.startConnection();
        }
        JMSConnectorManager.getInstance().addConnectorToPool(this);
    }

    public void shutdown() {
        this.m_sendConnection.shutdown();
        if (this.m_allowReceive) {
            this.m_receiveConnection.shutdown();
        }
    }

    public abstract JMSEndpoint createEndpoint(String var1) throws JMSException;

    public abstract JMSEndpoint createEndpoint(Destination var1) throws JMSException;

    protected abstract javax.jms.Connection internalConnect(ConnectionFactory var1, String var2, String var3) throws JMSException;

    protected abstract SyncConnection createSyncConnection(ConnectionFactory var1, javax.jms.Connection var2, int var3, String var4, String var5, String var6, String var7) throws JMSException;

    SyncConnection getSendConnection() {
        return this.m_sendConnection;
    }

    AsyncConnection getReceiveConnection() {
        return this.m_receiveConnection;
    }

    protected abstract AsyncConnection createAsyncConnection(ConnectionFactory var1, javax.jms.Connection var2, String var3, String var4, String var5, String var6) throws JMSException;

    private abstract class ConnectorSession {
        Session m_session;

        ConnectorSession(Session session) throws JMSException {
            this.m_session = session;
        }
    }

    protected abstract class AsyncConnection
    extends Connection {
        HashMap m_subscriptions;
        Object m_subscriptionLock;

        protected AsyncConnection(ConnectionFactory connectionFactory, javax.jms.Connection connection, String string, String string2, String string3, String string4) throws JMSException {
            super(connectionFactory, connection, string, string2, string3, string4);
            this.m_subscriptions = new HashMap();
            this.m_subscriptionLock = new Object();
        }

        protected abstract ListenerSession createListenerSession(javax.jms.Connection var1, Subscription var2) throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onShutdown() {
            Object object = this.m_subscriptionLock;
            synchronized (object) {
                for (Subscription subscription : this.m_subscriptions.keySet()) {
                    ListenerSession listenerSession = (ListenerSession)this.m_subscriptions.get(subscription);
                    if (listenerSession == null) continue;
                    listenerSession.cleanup();
                }
                this.m_subscriptions.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void subscribe(Subscription subscription) throws Exception {
            long l = System.currentTimeMillis() + JMSConnector.this.m_timeoutTime;
            Object object = this.m_subscriptionLock;
            synchronized (object) {
                if (this.m_subscriptions.containsKey(subscription)) {
                    return;
                }
                while (true) {
                    if (System.currentTimeMillis() > l) {
                        throw new InvokeTimeoutException("Cannot subscribe listener");
                    }
                    try {
                        ListenerSession listenerSession = this.createListenerSession(this.m_connection, subscription);
                        this.m_subscriptions.put(subscription, listenerSession);
                    }
                    catch (JMSException jMSException) {
                        if (!JMSConnector.this.m_adapter.isRecoverable(jMSException, 2)) {
                            throw jMSException;
                        }
                        try {
                            this.m_subscriptionLock.wait(JMSConnector.this.m_interactRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Thread.yield();
                        continue;
                    }
                    catch (NullPointerException nullPointerException) {
                        try {
                            this.m_subscriptionLock.wait(JMSConnector.this.m_interactRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Thread.yield();
                        continue;
                    }
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unsubscribe(Subscription subscription) {
            long l = System.currentTimeMillis() + JMSConnector.this.m_timeoutTime;
            Object object = this.m_subscriptionLock;
            synchronized (object) {
                if (!this.m_subscriptions.containsKey(subscription)) {
                    return;
                }
                while (true) {
                    if (System.currentTimeMillis() > l) {
                        throw new InvokeTimeoutException("Cannot unsubscribe listener");
                    }
                    Thread.yield();
                    try {
                        ListenerSession listenerSession = (ListenerSession)this.m_subscriptions.get(subscription);
                        listenerSession.cleanup();
                        this.m_subscriptions.remove(subscription);
                    }
                    catch (NullPointerException nullPointerException) {
                        try {
                            this.m_subscriptionLock.wait(JMSConnector.this.m_interactRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onConnect() throws Exception {
            Object object = this.m_subscriptionLock;
            synchronized (object) {
                for (Subscription subscription : this.m_subscriptions.keySet()) {
                    if (this.m_subscriptions.get(subscription) != null) continue;
                    this.m_subscriptions.put(subscription, this.createListenerSession(this.m_connection, subscription));
                }
                this.m_subscriptionLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onException() {
            Object object = this.m_subscriptionLock;
            synchronized (object) {
                for (Subscription subscription : this.m_subscriptions.keySet()) {
                    this.m_subscriptions.put(subscription, null);
                }
            }
        }

        protected class ListenerSession
        extends ConnectorSession {
            protected MessageConsumer m_consumer;
            protected Subscription m_subscription;

            ListenerSession(Session session, MessageConsumer messageConsumer, Subscription subscription) throws Exception {
                super(session);
                this.m_subscription = subscription;
                this.m_consumer = messageConsumer;
                Destination destination = subscription.m_endpoint.getDestination(this.m_session);
                this.m_consumer.setMessageListener(subscription.m_listener);
            }

            void cleanup() {
                try {
                    this.m_consumer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_session.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected abstract class SyncConnection
    extends Connection {
        LinkedList m_senders;
        int m_numSessions;
        Object m_senderLock;

        SyncConnection(ConnectionFactory connectionFactory, javax.jms.Connection connection, int n, String string, String string2, String string3, String string4) throws JMSException {
            super(connectionFactory, connection, string, string2, string3, string4);
            this.m_senders = new LinkedList();
            this.m_numSessions = n;
            this.m_senderLock = new Object();
        }

        protected abstract SendSession createSendSession(javax.jms.Connection var1) throws JMSException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onConnect() throws JMSException {
            Object object = this.m_senderLock;
            synchronized (object) {
                for (int i = 0; i < this.m_numSessions; ++i) {
                    this.m_senders.add(this.createSendSession(this.m_connection));
                }
                this.m_senderLock.notifyAll();
            }
        }

        byte[] call(JMSEndpoint jMSEndpoint, byte[] byArray, long l, HashMap hashMap) throws Exception {
            long l2 = System.currentTimeMillis() + l;
            while (true) {
                if (System.currentTimeMillis() > l2) {
                    throw new InvokeTimeoutException("Unable to complete call in time allotted");
                }
                SendSession sendSession = null;
                try {
                    sendSession = this.getSessionFromPool(JMSConnector.this.m_poolTimeout);
                    byte[] byArray2 = sendSession.call(jMSEndpoint, byArray, l2 - System.currentTimeMillis(), hashMap);
                    this.returnSessionToPool(sendSession);
                    if (byArray2 == null) {
                        throw new InvokeTimeoutException("Unable to complete call in time allotted");
                    }
                    return byArray2;
                }
                catch (JMSException jMSException) {
                    if (!JMSConnector.this.m_adapter.isRecoverable(jMSException, 0)) {
                        this.returnSessionToPool(sendSession);
                        throw jMSException;
                    }
                    Thread.yield();
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    Thread.yield();
                    continue;
                }
                break;
            }
        }

        void send(JMSEndpoint jMSEndpoint, byte[] byArray, HashMap hashMap) throws Exception {
            long l = System.currentTimeMillis() + JMSConnector.this.m_timeoutTime;
            while (true) {
                if (System.currentTimeMillis() > l) {
                    throw new InvokeTimeoutException("Cannot complete send in time allotted");
                }
                SendSession sendSession = null;
                try {
                    sendSession = this.getSessionFromPool(JMSConnector.this.m_poolTimeout);
                    sendSession.send(jMSEndpoint, byArray, hashMap);
                    this.returnSessionToPool(sendSession);
                }
                catch (JMSException jMSException) {
                    if (!JMSConnector.this.m_adapter.isRecoverable(jMSException, 0)) {
                        this.returnSessionToPool(sendSession);
                        throw jMSException;
                    }
                    Thread.yield();
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    Thread.yield();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onException() {
            Object object = this.m_senderLock;
            synchronized (object) {
                this.m_senders.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onShutdown() {
            Object object = this.m_senderLock;
            synchronized (object) {
                for (SendSession sendSession : this.m_senders) {
                    sendSession.cleanup();
                }
                this.m_senders.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SendSession getSessionFromPool(long l) {
            Object object = this.m_senderLock;
            synchronized (object) {
                while (this.m_senders.size() == 0) {
                    try {
                        this.m_senderLock.wait(l);
                        if (this.m_senders.size() != 0) continue;
                        return null;
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
                return (SendSession)this.m_senders.removeFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void returnSessionToPool(SendSession sendSession) {
            Object object = this.m_senderLock;
            synchronized (object) {
                this.m_senders.addLast(sendSession);
                this.m_senderLock.notifyAll();
            }
        }

        protected abstract class SendSession
        extends ConnectorSession {
            MessageProducer m_producer;

            SendSession(Session session, MessageProducer messageProducer) throws JMSException {
                super(session);
                this.m_producer = messageProducer;
            }

            protected abstract Destination createTemporaryDestination() throws JMSException;

            protected abstract void deleteTemporaryDestination(Destination var1) throws JMSException;

            protected abstract MessageConsumer createConsumer(Destination var1) throws JMSException;

            protected abstract void send(Destination var1, Message var2, int var3, int var4, long var5) throws JMSException;

            void send(JMSEndpoint jMSEndpoint, byte[] byArray, HashMap hashMap) throws Exception {
                BytesMessage bytesMessage = this.m_session.createBytesMessage();
                bytesMessage.writeBytes(byArray);
                int n = this.extractDeliveryMode(hashMap);
                int n2 = this.extractPriority(hashMap);
                long l = this.extractTimeToLive(hashMap);
                if (hashMap != null && !hashMap.isEmpty()) {
                    this.setProperties(hashMap, bytesMessage);
                }
                this.send(jMSEndpoint.getDestination(this.m_session), bytesMessage, n, n2, l);
            }

            void cleanup() {
                try {
                    this.m_producer.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.m_session.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            byte[] call(JMSEndpoint jMSEndpoint, byte[] byArray, long l, HashMap hashMap) throws Exception {
                Destination destination = this.createTemporaryDestination();
                MessageConsumer messageConsumer = this.createConsumer(destination);
                BytesMessage bytesMessage = this.m_session.createBytesMessage();
                bytesMessage.writeBytes(byArray);
                bytesMessage.setJMSReplyTo(destination);
                int n = this.extractDeliveryMode(hashMap);
                int n2 = this.extractPriority(hashMap);
                long l2 = this.extractTimeToLive(hashMap);
                if (hashMap != null && !hashMap.isEmpty()) {
                    this.setProperties(hashMap, bytesMessage);
                }
                this.send(jMSEndpoint.getDestination(this.m_session), bytesMessage, n, n2, l2);
                BytesMessage bytesMessage2 = null;
                try {
                    bytesMessage2 = (BytesMessage)messageConsumer.receive(l);
                }
                catch (ClassCastException classCastException) {
                    throw new InvokeException("Error: unexpected message type received - expected BytesMessage");
                }
                byte[] byArray2 = null;
                if (bytesMessage2 != null) {
                    byte[] byArray3 = new byte[8192];
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n3 = bytesMessage2.readBytes(byArray3);
                    while (n3 != -1) {
                        byteArrayOutputStream.write(byArray3, 0, n3);
                        n3 = bytesMessage2.readBytes(byArray3);
                    }
                    byArray2 = byteArrayOutputStream.toByteArray();
                }
                messageConsumer.close();
                this.deleteTemporaryDestination(destination);
                return byArray2;
            }

            private int extractPriority(HashMap hashMap) {
                return MapUtils.removeIntProperty(hashMap, "transport.jms.priority", 4);
            }

            private int extractDeliveryMode(HashMap hashMap) {
                return MapUtils.removeIntProperty(hashMap, "transport.jms.deliveryMode", 1);
            }

            private long extractTimeToLive(HashMap hashMap) {
                return MapUtils.removeLongProperty(hashMap, "transport.jms.ttl", 0L);
            }

            private void setProperties(HashMap hashMap, Message message) throws JMSException {
                for (Map.Entry entry : hashMap.entrySet()) {
                    this.setProperty((String)entry.getKey(), entry.getValue(), message);
                }
            }

            private void setProperty(String string, Object object, Message message) throws JMSException {
                if (string == null) {
                    return;
                }
                if (string.equals("transport.jms.jmsCorrelationID")) {
                    message.setJMSCorrelationID((String)object);
                } else if (string.equals("transport.jms.jmsCorrelationIDAsBytes")) {
                    message.setJMSCorrelationIDAsBytes((byte[])object);
                } else if (string.equals("transport.jms.jmsType")) {
                    message.setJMSType((String)object);
                } else {
                    message.setObjectProperty(string, object);
                }
            }
        }
    }

    private abstract class Connection
    extends Thread
    implements ExceptionListener {
        private ConnectionFactory m_connectionFactory;
        protected javax.jms.Connection m_connection;
        protected boolean m_isActive;
        private boolean m_needsToConnect;
        private boolean m_startConnection;
        private String m_clientID;
        private String m_username;
        private String m_password;
        private Object m_jmsLock;
        private Object m_lifecycleLock;

        protected Connection(ConnectionFactory connectionFactory, javax.jms.Connection connection, String string, String string2, String string3, String string4) throws JMSException {
            super(string);
            this.m_connectionFactory = connectionFactory;
            this.m_clientID = string2;
            this.m_username = string3;
            this.m_password = string4;
            this.m_jmsLock = new Object();
            this.m_lifecycleLock = new Object();
            if (connection != null) {
                this.m_needsToConnect = false;
                this.m_connection = connection;
                this.m_connection.setExceptionListener(this);
                if (this.m_clientID != null) {
                    this.m_connection.setClientID(this.m_clientID);
                }
            } else {
                this.m_needsToConnect = true;
            }
            this.m_isActive = true;
        }

        public ConnectionFactory getConnectionFactory() {
            return this.m_connectionFactory;
        }

        public String getClientID() {
            return this.m_clientID;
        }

        public String getUsername() {
            return this.m_username;
        }

        public String getPassword() {
            return this.m_password;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.m_isActive) {
                block14: {
                    if (this.m_needsToConnect) {
                        this.m_connection = null;
                        try {
                            this.m_connection = JMSConnector.this.internalConnect(this.m_connectionFactory, this.m_username, this.m_password);
                            this.m_connection.setExceptionListener(this);
                            if (this.m_clientID != null) {
                                this.m_connection.setClientID(this.m_clientID);
                            }
                            break block14;
                        }
                        catch (JMSException jMSException) {
                            try {
                                Thread.sleep(JMSConnector.this.m_connectRetryInterval);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                    }
                    this.m_needsToConnect = true;
                }
                try {
                    this.internalOnConnect();
                }
                catch (Exception exception) {
                    continue;
                }
                Object object = this.m_jmsLock;
                synchronized (object) {
                    try {
                        this.m_jmsLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.internalOnShutdown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startConnection() {
            Object object = this.m_lifecycleLock;
            synchronized (object) {
                if (this.m_startConnection) {
                    return;
                }
                this.m_startConnection = true;
                try {
                    this.m_connection.start();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopConnection() {
            Object object = this.m_lifecycleLock;
            synchronized (object) {
                if (!this.m_startConnection) {
                    return;
                }
                this.m_startConnection = false;
                try {
                    this.m_connection.stop();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            this.m_isActive = false;
            Object object = this.m_jmsLock;
            synchronized (object) {
                this.m_jmsLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(JMSException jMSException) {
            if (JMSConnector.this.m_adapter.isRecoverable(jMSException, 4)) {
                return;
            }
            this.onException();
            Object object = this.m_jmsLock;
            synchronized (object) {
                this.m_jmsLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void internalOnConnect() throws Exception {
            this.onConnect();
            Object object = this.m_lifecycleLock;
            synchronized (object) {
                if (this.m_startConnection) {
                    try {
                        this.m_connection.start();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }

        private final void internalOnShutdown() {
            this.stopConnection();
            this.onShutdown();
            try {
                this.m_connection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        protected abstract void onConnect() throws Exception;

        protected abstract void onShutdown();

        protected abstract void onException();
    }
}

