/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.axis.AxisFault;
import org.apache.axis.components.jms.JMSVendorAdapter;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.transport.jms.JMSConnector;
import org.apache.axis.transport.jms.JMSConnectorFactory;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class JMSConnectorManager {
    protected static Log log = LogFactory.getLog(JMSConnectorManager.class.getName());
    private static JMSConnectorManager s_instance = new JMSConnectorManager();
    private static HashMap vendorConnectorPools = new HashMap();
    private int DEFAULT_WAIT_FOR_SHUTDOWN = 90000;

    private JMSConnectorManager() {
    }

    public static JMSConnectorManager getInstance() {
        return s_instance;
    }

    public ShareableObjectPool getVendorPool(String string) {
        return (ShareableObjectPool)vendorConnectorPools.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSConnector getConnector(HashMap hashMap, HashMap hashMap2, String string, String string2, JMSVendorAdapter jMSVendorAdapter) throws AxisFault {
        JMSConnector jMSConnector = null;
        try {
            Object object;
            ShareableObjectPool shareableObjectPool = this.getVendorPool(jMSVendorAdapter.getVendorId());
            if (shareableObjectPool == null) {
                object = vendorConnectorPools;
                synchronized (object) {
                    shareableObjectPool = this.getVendorPool(jMSVendorAdapter.getVendorId());
                    if (shareableObjectPool == null) {
                        shareableObjectPool = new ShareableObjectPool();
                        vendorConnectorPools.put(jMSVendorAdapter.getVendorId(), shareableObjectPool);
                    }
                }
            }
            object = shareableObjectPool;
            synchronized (object) {
                try {
                    jMSConnector = JMSConnectorFactory.matchConnector(shareableObjectPool.getElements(), hashMap, hashMap2, string, string2, jMSVendorAdapter);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (jMSConnector == null) {
                    jMSConnector = JMSConnectorFactory.createClientConnector(hashMap, hashMap2, string, string2, jMSVendorAdapter);
                    jMSConnector.start();
                }
            }
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("cannotConnectError"), exception);
            if (exception instanceof AxisFault) {
                throw (AxisFault)exception;
            }
            throw new AxisFault("cannotConnect", exception);
        }
        return jMSConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAllConnectors() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: JMSConnectorManager::closeAllConnectors");
        }
        HashMap hashMap = vendorConnectorPools;
        synchronized (hashMap) {
            Iterator iterator = vendorConnectorPools.values().iterator();
            while (iterator.hasNext()) {
                ShareableObjectPool shareableObjectPool;
                ShareableObjectPool shareableObjectPool2 = shareableObjectPool = (ShareableObjectPool)iterator.next();
                synchronized (shareableObjectPool2) {
                    for (JMSConnector jMSConnector : shareableObjectPool.getElements()) {
                        try {
                            this.reserve(jMSConnector);
                            this.closeConnector(jMSConnector);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: JMSConnectorManager::closeAllConnectors");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeMatchingJMSConnectors(HashMap hashMap, HashMap hashMap2, String string, String string2, JMSVendorAdapter jMSVendorAdapter) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: JMSConnectorManager::closeMatchingJMSConnectors");
        }
        try {
            String string3 = jMSVendorAdapter.getVendorId();
            ShareableObjectPool shareableObjectPool = null;
            Object object = vendorConnectorPools;
            synchronized (object) {
                shareableObjectPool = this.getVendorPool(string3);
            }
            if (shareableObjectPool == null) {
                return;
            }
            object = shareableObjectPool;
            synchronized (object) {
                JMSConnector jMSConnector = null;
                while (shareableObjectPool.size() > 0 && (jMSConnector = JMSConnectorFactory.matchConnector(shareableObjectPool.getElements(), hashMap, hashMap2, string, string2, jMSVendorAdapter)) != null) {
                    this.closeConnector(jMSConnector);
                }
            }
        }
        catch (Exception exception) {
            log.warn(Messages.getMessage("failedJMSConnectorShutdown"), exception);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: JMSConnectorManager::closeMatchingJMSConnectors");
        }
    }

    private void closeConnector(JMSConnector jMSConnector) {
        jMSConnector.stop();
        jMSConnector.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectorToPool(JMSConnector jMSConnector) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: JMSConnectorManager::addConnectorToPool");
        }
        ShareableObjectPool shareableObjectPool = null;
        Object object = vendorConnectorPools;
        synchronized (object) {
            String string = jMSConnector.getVendorAdapter().getVendorId();
            shareableObjectPool = this.getVendorPool(string);
            if (shareableObjectPool == null) {
                shareableObjectPool = new ShareableObjectPool();
                vendorConnectorPools.put(string, shareableObjectPool);
            }
        }
        object = shareableObjectPool;
        synchronized (object) {
            shareableObjectPool.addObject(jMSConnector);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: JMSConnectorManager::addConnectorToPool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectorFromPool(JMSConnector jMSConnector) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: JMSConnectorManager::removeConnectorFromPool");
        }
        ShareableObjectPool shareableObjectPool = null;
        Object object = vendorConnectorPools;
        synchronized (object) {
            shareableObjectPool = this.getVendorPool(jMSConnector.getVendorAdapter().getVendorId());
        }
        if (shareableObjectPool == null) {
            return;
        }
        object = shareableObjectPool;
        synchronized (object) {
            shareableObjectPool.release(jMSConnector);
            shareableObjectPool.removeObject(jMSConnector);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: JMSConnectorManager::removeConnectorFromPool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reserve(JMSConnector jMSConnector) throws Exception {
        ShareableObjectPool shareableObjectPool = null;
        HashMap hashMap = vendorConnectorPools;
        synchronized (hashMap) {
            shareableObjectPool = this.getVendorPool(jMSConnector.getVendorAdapter().getVendorId());
        }
        if (shareableObjectPool != null) {
            shareableObjectPool.reserve(jMSConnector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(JMSConnector jMSConnector) {
        ShareableObjectPool shareableObjectPool = null;
        HashMap hashMap = vendorConnectorPools;
        synchronized (hashMap) {
            shareableObjectPool = this.getVendorPool(jMSConnector.getVendorAdapter().getVendorId());
        }
        if (shareableObjectPool != null) {
            shareableObjectPool.release(jMSConnector);
        }
    }

    public class ShareableObjectPool {
        private HashMap m_elements = new HashMap();
        private HashMap m_expiring = new HashMap();
        private int m_numElements = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addObject(Object object) {
            ReferenceCountedObject referenceCountedObject = new ReferenceCountedObject(object);
            HashMap hashMap = this.m_elements;
            synchronized (hashMap) {
                if (!this.m_elements.containsKey(object) && !this.m_expiring.containsKey(object)) {
                    this.m_elements.put(object, referenceCountedObject);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeObject(Object object, long l) {
            ReferenceCountedObject referenceCountedObject = null;
            HashMap hashMap = this.m_elements;
            synchronized (hashMap) {
                referenceCountedObject = (ReferenceCountedObject)this.m_elements.get(object);
                if (referenceCountedObject == null) {
                    return;
                }
                this.m_elements.remove(object);
                if (referenceCountedObject.count() == 0) {
                    return;
                }
                this.m_expiring.put(object, referenceCountedObject);
            }
            long l2 = System.currentTimeMillis() + l;
            while (referenceCountedObject.count() > 0) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= l2) continue;
            }
            this.m_expiring.remove(object);
        }

        public void removeObject(Object object) {
            this.removeObject(object, JMSConnectorManager.this.DEFAULT_WAIT_FOR_SHUTDOWN);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reserve(Object object) throws Exception {
            HashMap hashMap = this.m_elements;
            synchronized (hashMap) {
                if (this.m_expiring.containsKey(object)) {
                    throw new Exception("resourceUnavailable");
                }
                ReferenceCountedObject referenceCountedObject = (ReferenceCountedObject)this.m_elements.get(object);
                referenceCountedObject.increment();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release(Object object) {
            HashMap hashMap = this.m_elements;
            synchronized (hashMap) {
                ReferenceCountedObject referenceCountedObject = (ReferenceCountedObject)this.m_elements.get(object);
                referenceCountedObject.decrement();
            }
        }

        public synchronized Set getElements() {
            return this.m_elements.keySet();
        }

        public synchronized int size() {
            return this.m_elements.size();
        }

        public class ReferenceCountedObject {
            private Object m_object;
            private int m_refCount;

            public ReferenceCountedObject(Object object) {
                this.m_object = object;
                this.m_refCount = 0;
            }

            public synchronized void increment() {
                ++this.m_refCount;
            }

            public synchronized void decrement() {
                if (this.m_refCount > 0) {
                    --this.m_refCount;
                }
            }

            public synchronized int count() {
                return this.m_refCount;
            }
        }
    }
}

