/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.transport.jms.JMSConnector;
import org.apache.axis.transport.jms.JMSConnectorManager;
import org.apache.axis.transport.jms.JMSEndpoint;

public class JMSSender
extends BasicHandler {
    public void invoke(MessageContext messageContext) throws AxisFault {
        JMSConnector jMSConnector = null;
        try {
            String string;
            Object object = messageContext.getProperty("transport.jms.Destination");
            if (object == null) {
                throw new AxisFault("noDestination");
            }
            jMSConnector = (JMSConnector)messageContext.getProperty("transport.jms.Connector");
            JMSEndpoint jMSEndpoint = null;
            jMSEndpoint = object instanceof String ? jMSConnector.createEndpoint((String)object) : jMSConnector.createEndpoint((Destination)object);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            messageContext.getRequestMessage().writeTo(byteArrayOutputStream);
            HashMap hashMap = this.createSendProperties(messageContext);
            Object var7_8 = null;
            Message message = messageContext.getRequestMessage();
            Attachments attachments = message.getAttachmentsImpl();
            if (attachments != null && 0 != attachments.getAttachmentCount() && (string = attachments.getContentType()) != null && !string.trim().equals("")) {
                hashMap.put("contentType", string);
            }
            boolean bl = true;
            if (messageContext.containsProperty("transport.jms.waitForResponse")) {
                bl = (Boolean)messageContext.getProperty("transport.jms.waitForResponse");
            }
            if (bl) {
                long l = messageContext.getTimeout();
                byte[] byArray = jMSEndpoint.call(byteArrayOutputStream.toByteArray(), l, hashMap);
                Message message2 = new Message(byArray);
                messageContext.setResponseMessage(message2);
            } else {
                jMSEndpoint.send(byteArrayOutputStream.toByteArray(), hashMap);
            }
            if (jMSConnector != null) {
                JMSConnectorManager.getInstance().release(jMSConnector);
            }
        }
        catch (Exception exception) {
            try {
                throw new AxisFault("failedSend", exception);
            }
            catch (Throwable throwable) {
                if (jMSConnector != null) {
                    JMSConnectorManager.getInstance().release(jMSConnector);
                }
                throw throwable;
            }
        }
    }

    private HashMap createSendProperties(MessageContext messageContext) {
        HashMap hashMap = this.createApplicationProperties(messageContext);
        if (messageContext.containsProperty("transport.jms.priority")) {
            hashMap.put("transport.jms.priority", messageContext.getProperty("transport.jms.priority"));
        }
        if (messageContext.containsProperty("transport.jms.deliveryMode")) {
            hashMap.put("transport.jms.deliveryMode", messageContext.getProperty("transport.jms.deliveryMode"));
        }
        if (messageContext.containsProperty("transport.jms.ttl")) {
            hashMap.put("transport.jms.ttl", messageContext.getProperty("transport.jms.ttl"));
        }
        if (messageContext.containsProperty("transport.jms.jmsCorrelationID")) {
            hashMap.put("transport.jms.jmsCorrelationID", messageContext.getProperty("transport.jms.jmsCorrelationID"));
        }
        return hashMap;
    }

    protected HashMap createApplicationProperties(MessageContext messageContext) {
        HashMap hashMap = null;
        if (messageContext.containsProperty("transport.jms.msgProps")) {
            hashMap = new HashMap();
            hashMap.putAll((Map)messageContext.getProperty("transport.jms.msgProps"));
        }
        return hashMap;
    }
}

