/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.axis.components.jms.JMSVendorAdapter;
import org.apache.axis.components.jms.JMSVendorAdapterFactory;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.jms.JMSConnector;
import org.apache.axis.transport.jms.JMSConnectorFactory;
import org.apache.axis.transport.jms.JMSEndpoint;
import org.apache.axis.transport.jms.SimpleJMSWorker;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.Options;
import org.apache.commons.logging.Log;

public class SimpleJMSListener
implements MessageListener {
    protected static Log log = LogFactory.getLog(SimpleJMSListener.class.getName());
    private static boolean doThreads;
    private JMSConnector connector;
    private JMSEndpoint endpoint;
    private AxisServer server;
    private HashMap connectorProps;
    private static AxisServer myAxisServer;

    public SimpleJMSListener(HashMap hashMap, HashMap hashMap2, String string, String string2, String string3, boolean bl) throws Exception {
        doThreads = bl;
        try {
            JMSVendorAdapter jMSVendorAdapter = JMSVendorAdapterFactory.getJMSVendorAdapter();
            this.connector = JMSConnectorFactory.createServerConnector(hashMap, hashMap2, string2, string3, jMSVendorAdapter);
            this.connectorProps = hashMap;
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
            throw exception;
        }
        this.endpoint = this.connector.createEndpoint(string);
    }

    protected static AxisServer getAxisServer() {
        return myAxisServer;
    }

    protected JMSConnector getConnector() {
        return this.connector;
    }

    public void onMessage(Message message) {
        try {
            SimpleJMSWorker simpleJMSWorker = new SimpleJMSWorker(this, (BytesMessage)message);
            if (doThreads) {
                Thread thread = new Thread(simpleJMSWorker);
                thread.start();
            } else {
                simpleJMSWorker.run();
            }
        }
        catch (ClassCastException classCastException) {
            log.error(Messages.getMessage("exception00"), classCastException);
            classCastException.printStackTrace();
            return;
        }
    }

    public void start() throws Exception {
        this.endpoint.registerListener(this, this.connectorProps);
        this.connector.start();
    }

    public void shutdown() throws Exception {
        this.endpoint.unregisterListener(this);
        this.connector.stop();
        this.connector.shutdown();
    }

    public static final HashMap createConnectorMap(Options options) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (options.isFlagSet('t') > 0) {
            hashMap.put("transport.jms.domain", "TOPIC");
        }
        return hashMap;
    }

    public static final HashMap createCFMap(Options options) throws IOException {
        String string = options.isValueSet('c');
        if (string == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.load(new BufferedInputStream(new FileInputStream(string)));
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(properties);
        return hashMap;
    }

    public static void main(String[] stringArray) throws Exception {
        Options options = new Options(stringArray);
        if (options.isFlagSet('?') > 0 || options.isFlagSet('h') > 0) {
            SimpleJMSListener.printUsage();
        }
        SimpleJMSListener simpleJMSListener = new SimpleJMSListener(SimpleJMSListener.createConnectorMap(options), SimpleJMSListener.createCFMap(options), options.isValueSet('d'), options.getUser(), options.getPassword(), options.isFlagSet('s') > 0);
        simpleJMSListener.start();
    }

    public static void printUsage() {
        System.out.println("Usage: SimpleJMSListener [options]");
        System.out.println(" Opts: -? this message");
        System.out.println();
        System.out.println("       -c connection factory properties filename");
        System.out.println("       -d destination");
        System.out.println("       -t topic [absence of -t indicates queue]");
        System.out.println();
        System.out.println("       -u username");
        System.out.println("       -w password");
        System.out.println();
        System.out.println("       -s single-threaded listener");
        System.out.println("          [absence of option => multithreaded]");
        System.exit(1);
    }

    static {
        myAxisServer = new AxisServer();
    }
}

