/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.jms.JMSEndpoint;
import org.apache.axis.transport.jms.SimpleJMSListener;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class SimpleJMSWorker
implements Runnable {
    protected static Log log = LogFactory.getLog(SimpleJMSWorker.class.getName());
    SimpleJMSListener listener;
    BytesMessage message;

    public SimpleJMSWorker(SimpleJMSListener simpleJMSListener, BytesMessage bytesMessage) {
        this.listener = simpleJMSListener;
        this.message = bytesMessage;
    }

    public void run() {
        Object object;
        Object object2;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            object2 = new byte[8192];
            object = new ByteArrayOutputStream();
            int n = this.message.readBytes((byte[])object2);
            while (n != -1) {
                ((ByteArrayOutputStream)object).write((byte[])object2, 0, n);
                n = this.message.readBytes((byte[])object2);
            }
            byteArrayInputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("exception00"), exception);
            exception.printStackTrace();
            return;
        }
        object2 = SimpleJMSListener.getAxisServer();
        object = null;
        try {
            object = this.message.getStringProperty("contentType");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Message message = null;
        message = object != null && !((String)object).trim().equals("") ? new Message(byteArrayInputStream, true, (String)object, null) : new Message(byteArrayInputStream);
        MessageContext messageContext = new MessageContext((AxisEngine)object2);
        messageContext.setRequestMessage(message);
        try {
            ((AxisServer)object2).invoke(messageContext);
            message = messageContext.getResponseMessage();
        }
        catch (AxisFault axisFault) {
            message = new Message(axisFault);
            message.setMessageContext(messageContext);
        }
        catch (Exception exception) {
            message = new Message(new AxisFault(exception.toString()));
            message.setMessageContext(messageContext);
        }
        try {
            Destination destination = this.message.getJMSReplyTo();
            if (destination == null) {
                return;
            }
            JMSEndpoint jMSEndpoint = this.listener.getConnector().createEndpoint(destination);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            message.writeTo(byteArrayOutputStream);
            jMSEndpoint.send(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (messageContext.getProperty("quit.requested") != null) {
            try {
                this.listener.shutdown();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

