/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.types;

import java.io.Serializable;
import java.text.NumberFormat;
import org.apache.axis.utils.Messages;

public class MonthDay
implements Serializable {
    int month;
    int day;
    String timezone = null;

    public MonthDay(int n, int n2) throws NumberFormatException {
        this.setValue(n, n2);
    }

    public MonthDay(int n, int n2, String string) throws NumberFormatException {
        this.setValue(n, n2, string);
    }

    public MonthDay(String string) throws NumberFormatException {
        if (string.length() < 6) {
            throw new NumberFormatException(Messages.getMessage("badMonthDay00"));
        }
        if (string.charAt(0) != '-' || string.charAt(1) != '-' || string.charAt(4) != '-') {
            throw new NumberFormatException(Messages.getMessage("badMonthDay00"));
        }
        this.setValue(Integer.parseInt(string.substring(2, 4)), Integer.parseInt(string.substring(5, 7)), string.substring(7));
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int n) {
        if (n < 1 || n > 12) {
            throw new NumberFormatException(Messages.getMessage("badMonthDay00"));
        }
        this.month = n;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int n) {
        if (n < 1 || n > 31) {
            throw new NumberFormatException(Messages.getMessage("badMonthDay00"));
        }
        if (this.month == 2 && n > 29 || (this.month == 9 || this.month == 4 || this.month == 6 || this.month == 11) && n > 30) {
            throw new NumberFormatException(Messages.getMessage("badMonthDay00"));
        }
        this.day = n;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String string) {
        if (string != null && string.length() > 0) {
            if (string.charAt(0) == '+' || string.charAt(0) == '-' ? string.length() != 6 || !Character.isDigit(string.charAt(1)) || !Character.isDigit(string.charAt(2)) || string.charAt(3) != ':' || !Character.isDigit(string.charAt(4)) || !Character.isDigit(string.charAt(5)) : !string.equals("Z")) {
                throw new NumberFormatException(Messages.getMessage("badTimezone00"));
            }
            this.timezone = string;
        }
    }

    public void setValue(int n, int n2, String string) throws NumberFormatException {
        this.setMonth(n);
        this.setDay(n2);
        this.setTimezone(string);
    }

    public void setValue(int n, int n2) throws NumberFormatException {
        this.setMonth(n);
        this.setDay(n2);
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(2);
        String string = "--" + numberFormat.format(this.month) + "-" + numberFormat.format(this.day);
        if (this.timezone != null) {
            string = string + this.timezone;
        }
        return string;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof MonthDay)) {
            return false;
        }
        MonthDay monthDay = (MonthDay)object;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        boolean bl2 = bl = this.month == monthDay.month && this.day == monthDay.day;
        if (this.timezone != null) {
            bl = bl && this.timezone.equals(monthDay.timezone);
        }
        return bl;
    }

    public int hashCode() {
        return null == this.timezone ? this.month + this.day : this.month + this.day ^ this.timezone.hashCode();
    }
}

