/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.types;

import java.math.BigInteger;
import org.apache.axis.utils.Messages;

public class UnsignedLong
extends Number
implements Comparable {
    protected BigInteger lValue = BigInteger.ZERO;
    private static BigInteger MAX = new BigInteger("18446744073709551615");
    private Object __equalsCalc = null;

    public UnsignedLong() {
    }

    public UnsignedLong(double d) throws NumberFormatException {
        this.setValue(new BigInteger(Double.toString(d)));
    }

    public UnsignedLong(BigInteger bigInteger) throws NumberFormatException {
        this.setValue(bigInteger);
    }

    public UnsignedLong(long l) throws NumberFormatException {
        this.setValue(BigInteger.valueOf(l));
    }

    public UnsignedLong(String string) throws NumberFormatException {
        this.setValue(new BigInteger(string));
    }

    private void setValue(BigInteger bigInteger) {
        if (!UnsignedLong.isValid(bigInteger)) {
            throw new NumberFormatException(Messages.getMessage("badUnsignedLong00") + String.valueOf(bigInteger) + "]");
        }
        this.lValue = bigInteger;
    }

    public static boolean isValid(BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ZERO) != -1 && bigInteger.compareTo(MAX) != 1;
    }

    public String toString() {
        return this.lValue.toString();
    }

    public int hashCode() {
        if (this.lValue != null) {
            return this.lValue.hashCode();
        }
        return 0;
    }

    public synchronized boolean equals(Object object) {
        if (!(object instanceof UnsignedLong)) {
            return false;
        }
        UnsignedLong unsignedLong = (UnsignedLong)object;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.__equalsCalc != null) {
            return this.__equalsCalc == object;
        }
        this.__equalsCalc = object;
        boolean bl = this.lValue == null && unsignedLong.lValue == null || this.lValue != null && this.lValue.equals(unsignedLong.lValue);
        this.__equalsCalc = null;
        return bl;
    }

    public int compareTo(Object object) {
        if (this.lValue != null && object instanceof BigInteger) {
            return this.lValue.compareTo((BigInteger)object);
        }
        if (this.equals(object)) {
            return 0;
        }
        return 1;
    }

    public byte byteValue() {
        return this.lValue.byteValue();
    }

    public short shortValue() {
        return this.lValue.shortValue();
    }

    public int intValue() {
        return this.lValue.intValue();
    }

    public long longValue() {
        return this.lValue.longValue();
    }

    public double doubleValue() {
        return this.lValue.doubleValue();
    }

    public float floatValue() {
        return this.lValue.floatValue();
    }
}

