/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.types;

import java.io.Serializable;
import java.text.NumberFormat;
import org.apache.axis.utils.Messages;

public class Year
implements Serializable {
    int year;
    String timezone = null;

    public Year(int n) throws NumberFormatException {
        this.setValue(n);
    }

    public Year(int n, String string) throws NumberFormatException {
        this.setValue(n, string);
    }

    public Year(String string) throws NumberFormatException {
        int n;
        int n2 = 0;
        if (string.charAt(0) == '-') {
            n2 = 1;
        }
        if (string.length() < 4 + n2) {
            throw new NumberFormatException(Messages.getMessage("badYear00"));
        }
        for (n = 4 + n2; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        this.setValue(Integer.parseInt(string.substring(0, n)), string.substring(n));
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int n) {
        if (n == 0) {
            throw new NumberFormatException(Messages.getMessage("badYear00"));
        }
        this.year = n;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String string) {
        if (string != null && string.length() > 0) {
            if (string.charAt(0) == '+' || string.charAt(0) == '-' ? string.length() != 6 || !Character.isDigit(string.charAt(1)) || !Character.isDigit(string.charAt(2)) || string.charAt(3) != ':' || !Character.isDigit(string.charAt(4)) || !Character.isDigit(string.charAt(5)) : !string.equals("Z")) {
                throw new NumberFormatException(Messages.getMessage("badTimezone00"));
            }
            this.timezone = string;
        }
    }

    public void setValue(int n, String string) throws NumberFormatException {
        this.setYear(n);
        this.setTimezone(string);
    }

    public void setValue(int n) throws NumberFormatException {
        this.setYear(n);
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(4);
        String string = numberFormat.format(this.year);
        if (this.timezone != null) {
            string = string + this.timezone;
        }
        return string;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof Year)) {
            return false;
        }
        Year year = (Year)object;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        boolean bl2 = bl = this.year == year.year;
        if (this.timezone != null) {
            bl = bl && this.timezone.equals(year.timezone);
        }
        return bl;
    }

    public int hashCode() {
        return null == this.timezone ? this.year : this.year ^ this.timezone.hashCode();
    }
}

