/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.axis.AxisFault;
import org.apache.axis.InternalException;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.utils.BeanPropertyDescriptor;
import org.apache.axis.utils.FieldPropertyDescriptor;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class BeanUtils {
    public static final Object[] noArgs = new Object[0];
    protected static Log log = LogFactory.getLog(BeanUtils.class.getName());

    public static BeanPropertyDescriptor[] getPd(Class clazz) {
        return BeanUtils.getPd(clazz, null);
    }

    public static BeanPropertyDescriptor[] getPd(Class clazz, TypeDesc typeDesc) {
        BeanPropertyDescriptor[] beanPropertyDescriptorArray;
        try {
            Class clazz2 = clazz;
            PropertyDescriptor[] propertyDescriptorArray = BeanUtils.getPropertyDescriptors(clazz2);
            beanPropertyDescriptorArray = BeanUtils.processPropertyDescriptors(propertyDescriptorArray, clazz, typeDesc);
        }
        catch (Exception exception) {
            throw new InternalException(exception);
        }
        return beanPropertyDescriptorArray;
    }

    private static PropertyDescriptor[] getPropertyDescriptors(final Class clazz) {
        return (PropertyDescriptor[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PropertyDescriptor[] propertyDescriptorArray = null;
                try {
                    propertyDescriptorArray = AxisFault.class.isAssignableFrom(clazz) ? Introspector.getBeanInfo(clazz, AxisFault.class).getPropertyDescriptors() : (Throwable.class != clazz && Throwable.class.isAssignableFrom(clazz) ? Introspector.getBeanInfo(clazz, Throwable.class).getPropertyDescriptors() : Introspector.getBeanInfo(clazz).getPropertyDescriptors());
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
                return propertyDescriptorArray;
            }
        });
    }

    public static Vector getBeanAttributes(Class clazz, TypeDesc typeDesc) {
        Vector<String> vector = new Vector<String>();
        if (typeDesc == null) {
            try {
                Method method = clazz.getMethod("getAttributeElements", new Class[0]);
                String[] stringArray = (String[])method.invoke(null, noArgs);
                vector = new Vector(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    vector.add(stringArray[i]);
                }
            }
            catch (Exception exception) {
                vector.clear();
            }
        } else {
            FieldDesc[] fieldDescArray = typeDesc.getFields();
            if (fieldDescArray != null) {
                for (int i = 0; i < fieldDescArray.length; ++i) {
                    FieldDesc fieldDesc = fieldDescArray[i];
                    if (fieldDesc.isElement()) continue;
                    vector.add(fieldDesc.getFieldName());
                }
            }
        }
        return vector;
    }

    public static BeanPropertyDescriptor[] processPropertyDescriptors(PropertyDescriptor[] propertyDescriptorArray, Class clazz) {
        return BeanUtils.processPropertyDescriptors(propertyDescriptorArray, clazz, null);
    }

    public static BeanPropertyDescriptor[] processPropertyDescriptors(PropertyDescriptor[] propertyDescriptorArray, Class clazz, TypeDesc typeDesc) {
        BeanPropertyDescriptor[] beanPropertyDescriptorArray = new BeanPropertyDescriptor[propertyDescriptorArray.length];
        ArrayList<BeanPropertyDescriptor> arrayList = new ArrayList<BeanPropertyDescriptor>();
        try {
            int n;
            boolean bl;
            Object object;
            FieldDesc[] fieldDescArray;
            int n2;
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (propertyDescriptorArray[i].getName().equals("_any")) continue;
                arrayList.add(new BeanPropertyDescriptor(propertyDescriptorArray[i]));
            }
            Field[] fieldArray = clazz.getFields();
            if (fieldArray != null && fieldArray.length > 0) {
                for (n2 = 0; n2 < fieldArray.length; ++n2) {
                    fieldDescArray = fieldArray[n2];
                    String string = fieldDescArray.getDeclaringClass().getName();
                    if (string.startsWith("java.") || string.startsWith("javax.") || Modifier.isStatic(fieldDescArray.getModifiers()) || Modifier.isFinal(fieldDescArray.getModifiers()) || Modifier.isTransient(fieldDescArray.getModifiers())) continue;
                    object = fieldDescArray.getName();
                    bl = false;
                    for (n = 0; n < propertyDescriptorArray.length && !bl; ++n) {
                        String string2 = ((BeanPropertyDescriptor)arrayList.get(n)).getName();
                        if (string2.length() != ((String)object).length() || !string2.substring(0, 1).equalsIgnoreCase(((String)object).substring(0, 1))) continue;
                        bl = string2.length() == 1 || string2.substring(1).equals(((String)object).substring(1));
                    }
                    if (bl) continue;
                    arrayList.add(new FieldPropertyDescriptor(fieldDescArray.getName(), (Field)fieldDescArray));
                }
            }
            if (typeDesc != null && typeDesc.getFields(true) != null) {
                ArrayList arrayList2 = new ArrayList();
                fieldDescArray = typeDesc.getFields(true);
                for (int i = 0; i < fieldDescArray.length; ++i) {
                    object = fieldDescArray[i];
                    if (!((FieldDesc)object).isElement()) continue;
                    bl = false;
                    for (n = 0; n < arrayList.size() && !bl; ++n) {
                        if (!((FieldDesc)object).getFieldName().equals(((BeanPropertyDescriptor)arrayList.get(n)).getName())) continue;
                        arrayList2.add(arrayList.remove(n));
                        bl = true;
                    }
                }
                while (arrayList.size() > 0) {
                    arrayList2.add(arrayList.remove(0));
                }
                arrayList = arrayList2;
            }
            beanPropertyDescriptorArray = new BeanPropertyDescriptor[arrayList.size()];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                beanPropertyDescriptorArray[n2] = (BeanPropertyDescriptor)arrayList.get(n2);
            }
        }
        catch (Exception exception) {
            log.error(Messages.getMessage("badPropertyDesc00", clazz.getName()), exception);
            throw new InternalException(exception);
        }
        return beanPropertyDescriptorArray;
    }

    public static BeanPropertyDescriptor getAnyContentPD(Class clazz) {
        PropertyDescriptor[] propertyDescriptorArray = BeanUtils.getPropertyDescriptors(clazz);
        return BeanUtils.getSpecificPD(propertyDescriptorArray, "_any");
    }

    public static BeanPropertyDescriptor getSpecificPD(PropertyDescriptor[] propertyDescriptorArray, String string) {
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (!propertyDescriptor.getName().equals(string)) continue;
            return new BeanPropertyDescriptor(propertyDescriptor);
        }
        return null;
    }

    public static BeanPropertyDescriptor getSpecificPD(BeanPropertyDescriptor[] beanPropertyDescriptorArray, String string) {
        for (int i = 0; i < beanPropertyDescriptorArray.length; ++i) {
            BeanPropertyDescriptor beanPropertyDescriptor = beanPropertyDescriptorArray[i];
            if (!beanPropertyDescriptor.getName().equals(string)) continue;
            return beanPropertyDescriptor;
        }
        return null;
    }
}

