/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import org.apache.axis.utils.StringUtils;

public final class ClassUtils {
    private static ClassLoader defaultClassLoader = ClassUtils.class.getClassLoader();
    private static Hashtable classloaders = new Hashtable();

    public static void setDefaultClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            defaultClassLoader = classLoader;
        }
    }

    public static ClassLoader getDefaultClassLoader() {
        return defaultClassLoader;
    }

    public static void setClassLoader(String string, ClassLoader classLoader) {
        if (string != null && classLoader != null) {
            classloaders.put(string, classLoader);
        }
    }

    public static ClassLoader getClassLoader(String string) {
        if (string == null) {
            return null;
        }
        return (ClassLoader)classloaders.get(string);
    }

    public static void removeClassLoader(String string) {
        classloaders.remove(string);
    }

    public static Class forName(String string) throws ClassNotFoundException {
        return ClassUtils.loadClass(string);
    }

    public static Class forName(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        final String string2 = string;
        final ClassLoader classLoader2 = classLoader;
        try {
            Object t = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return Class.forName(string2, true, classLoader2);
                    }
                    catch (Throwable throwable) {
                        return throwable;
                    }
                }
            });
            if (t instanceof Class) {
                return (Class)t;
            }
            if (t instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)t;
            }
            throw new ClassNotFoundException(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return ClassUtils.loadClass(string2);
        }
    }

    private static Class loadClass(String string) throws ClassNotFoundException {
        final String string2 = string;
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    ClassLoader classLoader = ClassUtils.getClassLoader(string2);
                    return Class.forName(string2, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                        return Class.forName(string2, true, classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        try {
                            ClassLoader classLoader = ClassUtils.class.getClassLoader();
                            return Class.forName(string2, true, classLoader);
                        }
                        catch (ClassNotFoundException classNotFoundException3) {
                            try {
                                return defaultClassLoader.loadClass(string2);
                            }
                            catch (Throwable throwable) {
                                return throwable;
                            }
                        }
                    }
                }
            }
        });
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)t;
        }
        throw new ClassNotFoundException(string);
    }

    public static InputStream getResourceAsStream(Class clazz, String string, boolean bl) {
        InputStream inputStream = null;
        if (bl && Thread.currentThread().getContextClassLoader() != null) {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        }
        if (inputStream == null) {
            inputStream = ClassUtils.getResourceAsStream(clazz, string);
        }
        return inputStream;
    }

    public static InputStream getResourceAsStream(Class clazz, String string) {
        InputStream inputStream = null;
        inputStream = clazz.getClassLoader() != null ? clazz.getClassLoader().getResourceAsStream(string) : ClassLoader.getSystemClassLoader().getResourceAsStream(string);
        if (inputStream == null && Thread.currentThread().getContextClassLoader() != null) {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        }
        if (inputStream == null) {
            inputStream = clazz.getResourceAsStream(string);
        }
        return inputStream;
    }

    public static ClassLoader createClassLoader(String string, ClassLoader classLoader) throws SecurityException {
        String[] stringArray = StringUtils.split(string, System.getProperty("path.separator").charAt(0));
        URL[] uRLArray = new URL[stringArray.length];
        try {
            for (int i = 0; i < uRLArray.length; ++i) {
                uRLArray[i] = new File(stringArray[i]).toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Unable to parse classpath: " + string);
        }
        return new URLClassLoader(uRLArray, classLoader);
    }
}

