/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.NSStack;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOM2Writer {
    public static String nodeToString(Node node, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        DOM2Writer.serializeAsXML(node, stringWriter, bl);
        return stringWriter.toString();
    }

    public static void serializeAsXML(Node node, Writer writer, boolean bl) {
        DOM2Writer.serializeAsXML(node, writer, bl, false);
    }

    public static void serializeAsXML(Node node, Writer writer, boolean bl, boolean bl2) {
        PrintWriter printWriter = new PrintWriter(writer);
        if (!bl) {
            printWriter.print("<?xml version=\"1.0\" encoding=\"");
            printWriter.print(XMLUtils.getEncoding());
            printWriter.println("\"?>");
        }
        NSStack nSStack = new NSStack();
        DOM2Writer.print(node, nSStack, node, printWriter, bl2, 0);
        printWriter.flush();
    }

    private static void print(Node node, NSStack nSStack, Node node2, PrintWriter printWriter, boolean bl, int n) {
        if (node == null) {
            return;
        }
        boolean bl2 = false;
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                Object object = node.getChildNodes();
                if (object == null) break;
                int n2 = object.getLength();
                for (int i = 0; i < n2; ++i) {
                    DOM2Writer.print(object.item(i), nSStack, node2, printWriter, bl, n);
                }
                break;
            }
            case 1: {
                NamedNodeMap namedNodeMap;
                nSStack.push();
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        printWriter.print(' ');
                    }
                }
                printWriter.print('<' + node.getNodeName());
                Object object = node.getPrefix();
                String string = node.getNamespaceURI();
                if (object != null && string != null && ((String)object).length() > 0) {
                    boolean bl3 = false;
                    try {
                        String string2 = nSStack.getNamespaceURI((String)object);
                        if (string.equals(string2)) {
                            bl3 = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (!bl3) {
                        DOM2Writer.printNamespaceDecl(node, nSStack, node2, printWriter);
                    }
                }
                int n3 = (namedNodeMap = node.getAttributes()) != null ? namedNodeMap.getLength() : 0;
                for (int i = 0; i < n3; ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    printWriter.print(' ' + attr.getNodeName() + "=\"" + DOM2Writer.normalize(attr.getValue()) + '\"');
                    String string3 = attr.getPrefix();
                    String string4 = attr.getNamespaceURI();
                    if (string3 == null || string4 == null || string3.length() <= 0) continue;
                    boolean bl4 = false;
                    try {
                        String string5 = nSStack.getNamespaceURI(string3);
                        if (string4.equals(string5)) {
                            bl4 = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (bl4) continue;
                    DOM2Writer.printNamespaceDecl(attr, nSStack, node2, printWriter);
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null) {
                    int n4 = nodeList.getLength();
                    boolean bl5 = bl2 = n4 > 0;
                    if (bl2) {
                        printWriter.print('>');
                        if (bl) {
                            printWriter.print(JavaUtils.LS);
                        }
                    }
                    for (int i = 0; i < n4; ++i) {
                        DOM2Writer.print(nodeList.item(i), nSStack, node2, printWriter, bl, n + 1);
                    }
                } else {
                    bl2 = false;
                }
                if (!bl2) {
                    printWriter.print("/>");
                    if (bl) {
                        printWriter.print(JavaUtils.LS);
                    }
                }
                nSStack.pop();
                break;
            }
            case 5: {
                printWriter.print('&');
                printWriter.print(node.getNodeName());
                printWriter.print(';');
                break;
            }
            case 4: {
                printWriter.print("<![CDATA[");
                printWriter.print(node.getNodeValue());
                printWriter.print("]]>");
                break;
            }
            case 3: {
                printWriter.print(DOM2Writer.normalize(node.getNodeValue()));
                break;
            }
            case 8: {
                printWriter.print("<!--");
                printWriter.print(node.getNodeValue());
                printWriter.print("-->");
                if (!bl) break;
                printWriter.print(JavaUtils.LS);
                break;
            }
            case 7: {
                printWriter.print("<?");
                printWriter.print(node.getNodeName());
                Object object = node.getNodeValue();
                if (object != null && ((String)object).length() > 0) {
                    printWriter.print(' ');
                    printWriter.print((String)object);
                }
                printWriter.println("?>");
                if (!bl) break;
                printWriter.print(JavaUtils.LS);
                break;
            }
        }
        if (s == 1 && bl2) {
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    printWriter.print(' ');
                }
            }
            printWriter.print("</");
            printWriter.print(node.getNodeName());
            printWriter.print('>');
            if (bl) {
                printWriter.print(JavaUtils.LS);
            }
            bl2 = false;
        }
    }

    private static void printNamespaceDecl(Node node, NSStack nSStack, Node node2, PrintWriter printWriter) {
        switch (node.getNodeType()) {
            case 2: {
                DOM2Writer.printNamespaceDecl(((Attr)node).getOwnerElement(), node, nSStack, node2, printWriter);
                break;
            }
            case 1: {
                DOM2Writer.printNamespaceDecl((Element)node, node, nSStack, node2, printWriter);
            }
        }
    }

    private static void printNamespaceDecl(Element element, Node node, NSStack nSStack, Node node2, PrintWriter printWriter) {
        String string = node.getNamespaceURI();
        String string2 = node.getPrefix();
        if (!(string.equals("http://www.w3.org/2000/xmlns/") && string2.equals("xmlns") || string.equals("http://www.w3.org/XML/1998/namespace") && string2.equals("xml"))) {
            if (XMLUtils.getNamespace(string2, element, node2) == null) {
                printWriter.print(" xmlns:" + string2 + "=\"" + string + '\"');
            }
        } else {
            string2 = node.getLocalName();
            string = node.getNodeValue();
        }
        nSStack.add(string, string2);
    }

    public static String normalize(String string) {
        return XMLUtils.xmlEncodeString(string);
    }
}

