/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class LockableHashtable
extends Hashtable {
    Vector lockedEntries;
    private Hashtable parent = null;

    public LockableHashtable() {
    }

    public LockableHashtable(int n, float f) {
        super(n, f);
    }

    public LockableHashtable(Map map) {
        super(map);
    }

    public LockableHashtable(int n) {
        super(n);
    }

    public synchronized void setParent(Hashtable hashtable) {
        this.parent = hashtable;
    }

    public synchronized Hashtable getParent() {
        return this.parent;
    }

    public Set getAllKeys() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(super.keySet());
        Hashtable hashtable = this.parent;
        while (hashtable != null) {
            hashSet.addAll(hashtable.keySet());
            if (hashtable instanceof LockableHashtable) {
                hashtable = ((LockableHashtable)hashtable).getParent();
                continue;
            }
            hashtable = null;
        }
        return hashSet;
    }

    public synchronized Object get(Object object) {
        Object v = super.get(object);
        if (v == null && this.parent != null) {
            v = this.parent.get(object);
        }
        return v;
    }

    public synchronized Object put(Object object, Object object2, boolean bl) {
        if (this.lockedEntries != null && this.containsKey(object) && this.lockedEntries.contains(object)) {
            return null;
        }
        if (bl) {
            if (this.lockedEntries == null) {
                this.lockedEntries = new Vector();
            }
            this.lockedEntries.add(object);
        }
        return super.put(object, object2);
    }

    public synchronized Object put(Object object, Object object2) {
        return this.put(object, object2, false);
    }

    public synchronized Object remove(Object object) {
        if (this.lockedEntries != null && this.lockedEntries.contains(object)) {
            return null;
        }
        return super.remove(object);
    }

    public boolean isKeyLocked(Object object) {
        return this.lockedEntries != null && this.lockedEntries.contains(object);
    }
}

