/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.axis.components.logger.LogFactory;
import org.apache.commons.logging.Log;

public class NetworkUtils {
    public static final String LOCALHOST = "127.0.0.1";
    protected static Log log = LogFactory.getLog(NetworkUtils.class.getName());

    private NetworkUtils() {
    }

    public static String getLocalHostname() {
        String string;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
            if (string == null || string.length() == 0) {
                string = inetAddress.toString();
            }
        }
        catch (UnknownHostException unknownHostException) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to lookup local IP address", unknownHostException);
            }
            string = LOCALHOST;
        }
        return string;
    }
}

