/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.StringTokenizer;

public class URLHashSet
extends HashSet {
    public boolean add(URL uRL) {
        return super.add(URLHashSet.normalize(uRL));
    }

    public boolean remove(URL uRL) {
        return super.remove(URLHashSet.normalize(uRL));
    }

    public boolean contains(URL uRL) {
        return super.contains(URLHashSet.normalize(uRL));
    }

    public static URL normalize(URL uRL) {
        if (uRL.getProtocol().equals("file")) {
            try {
                File file = new File(URLHashSet.cleanup(uRL.getFile()));
                if (file.exists()) {
                    return file.toURL();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uRL;
    }

    private static String cleanup(String string) {
        int n;
        String[] stringArray = URLHashSet.tokenize(string, "/\\", false);
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2];
        while (true) {
            boolean bl = false;
            boolean bl2 = true;
            n = 0;
            for (int i = 0; i < n2 && stringArray[i] != null; ++i) {
                if (".".equals(stringArray[i])) continue;
                if ("..".equals(stringArray[i])) {
                    stringArray2[n++] = stringArray[i];
                    if (!bl) continue;
                    bl2 = false;
                    continue;
                }
                if (i + 1 < n2 && "..".equals(stringArray[i + 1])) {
                    ++i;
                    continue;
                }
                stringArray2[n++] = stringArray[i];
                bl = true;
            }
            if (bl2) break;
            stringArray = stringArray2;
            stringArray2 = new String[n2];
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (n = 0; n < n2 && stringArray2[n] != null; ++n) {
            stringBuffer.append(stringArray2[n]);
            if (n + 1 >= n2 || stringArray2[n + 1] == null) continue;
            stringBuffer.append("/");
        }
        return stringBuffer.toString();
    }

    private static String[] tokenize(String string, String string2, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, bl);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }
}

