/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils.cache;

import java.util.Hashtable;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.cache.JavaClass;

public class ClassCache {
    Hashtable classCache = new Hashtable();

    public synchronized void registerClass(String string, Class clazz) {
        if (string == null) {
            return;
        }
        JavaClass javaClass = (JavaClass)this.classCache.get(string);
        if (javaClass != null && javaClass.getJavaClass() == clazz) {
            return;
        }
        this.classCache.put(string, new JavaClass(clazz));
    }

    public synchronized void deregisterClass(String string) {
        this.classCache.remove(string);
    }

    public boolean isClassRegistered(String string) {
        return this.classCache != null && this.classCache.get(string) != null;
    }

    public JavaClass lookup(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (string == null) {
            return null;
        }
        JavaClass javaClass = (JavaClass)this.classCache.get(string);
        if (javaClass == null && classLoader != null) {
            Class clazz = ClassUtils.forName(string, true, classLoader);
            javaClass = new JavaClass(clazz);
        }
        return javaClass;
    }
}

