/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils.cache;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.utils.ClassUtils;

public class MethodCache {
    private static transient MethodCache instance;
    private static transient ThreadLocal cache;
    private static final Object NULL_OBJECT;

    private MethodCache() {
        cache = new ThreadLocal();
    }

    public static MethodCache getInstance() {
        if (instance == null) {
            instance = new MethodCache();
        }
        return instance;
    }

    private Map getMethodCache() {
        HashMap hashMap = (HashMap)cache.get();
        if (hashMap == null) {
            hashMap = new HashMap();
            cache.set(hashMap);
        }
        return hashMap;
    }

    public Method getMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        MethodKey methodKey;
        HashMap<MethodKey, Object> hashMap;
        Method method;
        Map map;
        block9: {
            Object v;
            String string2 = clazz.getName();
            map = this.getMethodCache();
            method = null;
            hashMap = null;
            methodKey = new MethodKey(string, classArray);
            hashMap = (HashMap<MethodKey, Object>)map.get(clazz);
            if (hashMap != null && (v = hashMap.get(methodKey)) != null) {
                if (v instanceof Method) {
                    return (Method)v;
                }
                return null;
            }
            try {
                method = clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (clazz.isPrimitive() || string2.startsWith("java.") || string2.startsWith("javax.")) break block9;
                try {
                    Class clazz2 = ClassUtils.forName(string2 + "_Helper");
                    method = clazz2.getMethod(string, classArray);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (hashMap == null) {
            hashMap = new HashMap<MethodKey, Object>();
            map.put(clazz, hashMap);
        }
        if (null == method) {
            hashMap.put(methodKey, NULL_OBJECT);
        } else {
            hashMap.put(methodKey, method);
        }
        return method;
    }

    static {
        NULL_OBJECT = new Object();
    }

    static class MethodKey {
        private final String methodName;
        private final Class[] parameterTypes;

        MethodKey(String string, Class[] classArray) {
            this.methodName = string;
            this.parameterTypes = classArray;
        }

        public boolean equals(Object object) {
            MethodKey methodKey = (MethodKey)object;
            return this.methodName.equals(methodKey.methodName) && Arrays.equals(this.parameterTypes, methodKey.parameterTypes);
        }

        public int hashCode() {
            return this.methodName.hashCode();
        }
    }
}

