/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.apache.axis.utils.StringUtils;
import org.apache.axis.utils.XMLUtils;

public class tcpmon
extends JFrame {
    private JTabbedPane notebook = new JTabbedPane();
    private static final int STATE_COLUMN = 0;
    private static final int TIME_COLUMN = 1;
    private static final int INHOST_COLUMN = 2;
    private static final int OUTHOST_COLUMN = 3;
    private static final int REQ_COLUMN = 4;
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 8080;
    private static ResourceBundle messages = null;

    public tcpmon(int n, String string, int n2, boolean bl) {
        super(tcpmon.getMessage("tcpmon00", "TCPMonitor"));
        this.getContentPane().add(this.notebook);
        new AdminPage(this.notebook, tcpmon.getMessage("admin00", "Admin"));
        if (n != 0) {
            Listener listener = null;
            listener = string == null ? new Listener(this.notebook, null, n, string, n2, true, null) : new Listener(this.notebook, null, n, string, n2, false, null);
            this.notebook.setSelectedIndex(1);
            listener.HTTPProxyHost = System.getProperty("http.proxyHost");
            if (listener.HTTPProxyHost != null && listener.HTTPProxyHost.equals("")) {
                listener.HTTPProxyHost = null;
            }
            if (listener.HTTPProxyHost != null) {
                String string2 = System.getProperty("http.proxyPort");
                if (string2 != null && string2.equals("")) {
                    string2 = null;
                }
                listener.HTTPProxyPort = string2 == null ? 80 : Integer.parseInt(string2);
            }
        }
        if (!bl) {
            this.setDefaultCloseOperation(3);
        }
        this.pack();
        this.setSize(600, 600);
        this.setVisible(true);
    }

    public tcpmon(int n, String string, int n2) {
        this(n, string, n2, false);
    }

    private static void setupLookAndFeel(boolean bl) throws Exception {
        String string;
        String string2 = UIManager.getCrossPlatformLookAndFeelClassName();
        if (bl) {
            string2 = UIManager.getSystemLookAndFeelClassName();
        }
        if ((string = System.getProperty("tcpmon.laf", "")).length() > 0) {
            string2 = string;
        }
        try {
            UIManager.setLookAndFeel(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        try {
            tcpmon.setupLookAndFeel(true);
            if (stringArray.length == 3) {
                int n = Integer.parseInt(stringArray[0]);
                int n2 = Integer.parseInt(stringArray[2]);
                new tcpmon(n, stringArray[1], n2);
            } else if (stringArray.length == 1) {
                int n = Integer.parseInt(stringArray[0]);
                new tcpmon(n, null, 0);
            } else if (stringArray.length != 0) {
                System.err.println(tcpmon.getMessage("usage00", "Usage:") + " tcpmon [listenPort targetHost targetPort]\n");
            } else {
                new tcpmon(0, null, 0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static String getMessage(String string, String string2) {
        try {
            if (messages == null) {
                tcpmon.initializeMessages();
            }
            return messages.getString(string);
        }
        catch (Throwable throwable) {
            return string2;
        }
    }

    private static void initializeMessages() {
        messages = ResourceBundle.getBundle("org.apache.axis.utils.tcpmon");
    }

    static class HostnameField
    extends RestrictedTextField {
        private static final String VALID_TEXT = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWZYZ-.";

        public HostnameField(int n) {
            super(n, VALID_TEXT);
        }

        public HostnameField() {
            super(VALID_TEXT);
        }
    }

    static class NumberField
    extends RestrictedTextField {
        private static final String VALID_TEXT = "0123456789";

        public NumberField() {
            super(VALID_TEXT);
        }

        public NumberField(int n) {
            super(n, VALID_TEXT);
        }

        public int getValue(int n) {
            int n2 = n;
            String string = this.getText();
            if (string != null && string.length() != 0) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return n2;
        }

        public void setValue(int n) {
            this.setText(Integer.toString(n));
        }
    }

    static class RestrictedTextField
    extends JTextField {
        protected String validText;

        public RestrictedTextField(String string) {
            this.setValidText(string);
        }

        public RestrictedTextField(int n, String string) {
            super(n);
            this.setValidText(string);
        }

        public RestrictedTextField(String string, String string2) {
            super(string);
            this.setValidText(string2);
        }

        public RestrictedTextField(String string, int n, String string2) {
            super(string, n);
            this.setValidText(string2);
        }

        private void setValidText(String string) {
            this.validText = string;
        }

        public Document createDefaultModel() {
            return new RestrictedDocument();
        }

        class RestrictedDocument
        extends PlainDocument {
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string == null) {
                    return;
                }
                int n2 = string.length();
                StringBuffer stringBuffer = new StringBuffer(string.length());
                for (int i = 0; i < n2; ++i) {
                    char c = string.charAt(i);
                    if (RestrictedTextField.this.validText.indexOf(c) < 0) continue;
                    stringBuffer.append(c);
                }
                super.insertString(n, new String(stringBuffer), attributeSet);
            }
        }
    }

    class Listener
    extends JPanel {
        public Socket inputSocket = null;
        public Socket outputSocket = null;
        public JTextField portField = null;
        public JTextField hostField = null;
        public JTextField tPortField = null;
        public JCheckBox isProxyBox = null;
        public JButton stopButton = null;
        public JButton removeButton = null;
        public JButton removeAllButton = null;
        public JCheckBox xmlFormatBox = null;
        public JCheckBox numericBox = null;
        public JButton saveButton = null;
        public JButton resendButton = null;
        public JButton switchButton = null;
        public JButton closeButton = null;
        public JTable connectionTable = null;
        public DefaultTableModel tableModel = null;
        public JSplitPane outPane = null;
        public ServerSocket sSocket = null;
        public SocketWaiter sw = null;
        public JPanel leftPanel = null;
        public JPanel rightPanel = null;
        public JTabbedPane notebook = null;
        public String HTTPProxyHost = null;
        public int HTTPProxyPort = 80;
        public int delayBytes = 0;
        public int delayTime = 0;
        public SlowLinkSimulator slowLink;
        public final Vector connections = new Vector();

        public Listener(JTabbedPane jTabbedPane, String string, int n, String string2, int n2, boolean bl, SlowLinkSimulator slowLinkSimulator) {
            this.notebook = jTabbedPane;
            if (string == null) {
                string = tcpmon.getMessage("port01", "Port") + " " + n;
            }
            this.slowLink = slowLinkSimulator != null ? slowLinkSimulator : new SlowLinkSimulator(0, 0);
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            final String string3 = tcpmon.getMessage("start00", "Start");
            this.stopButton = new JButton(string3);
            jPanel.add(this.stopButton);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel.add(new JLabel("  " + tcpmon.getMessage("listenPort01", "Listen Port:") + " ", 4));
            this.portField = new JTextField("" + n, 4);
            jPanel.add(this.portField);
            jPanel.add(new JLabel("  " + tcpmon.getMessage("host00", "Host:"), 4));
            this.hostField = new JTextField(string2, 30);
            jPanel.add(this.hostField);
            jPanel.add(new JLabel("  " + tcpmon.getMessage("port02", "Port:") + " ", 4));
            this.tPortField = new JTextField("" + n2, 4);
            jPanel.add(this.tPortField);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.isProxyBox = new JCheckBox(tcpmon.getMessage("proxy00", "Proxy"));
            jPanel.add(this.isProxyBox);
            this.isProxyBox.addChangeListener(new BasicButtonListener(this.isProxyBox){

                public void stateChanged(ChangeEvent changeEvent) {
                    JCheckBox jCheckBox = (JCheckBox)changeEvent.getSource();
                    boolean bl = jCheckBox.isSelected();
                    Listener.this.tPortField.setEnabled(!bl);
                    Listener.this.hostField.setEnabled(!bl);
                }
            });
            this.isProxyBox.setSelected(bl);
            this.portField.setEditable(false);
            this.portField.setMaximumSize(new Dimension(50, Short.MAX_VALUE));
            this.hostField.setEditable(false);
            this.hostField.setMaximumSize(new Dimension(85, Short.MAX_VALUE));
            this.tPortField.setEditable(false);
            this.tPortField.setMaximumSize(new Dimension(50, Short.MAX_VALUE));
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (tcpmon.getMessage("stop00", "Stop").equals(actionEvent.getActionCommand())) {
                        Listener.this.stop();
                    }
                    if (string3.equals(actionEvent.getActionCommand())) {
                        Listener.this.start();
                    }
                }
            });
            this.add((Component)jPanel, "North");
            this.tableModel = new DefaultTableModel(new String[]{tcpmon.getMessage("state00", "State"), tcpmon.getMessage("time00", "Time"), tcpmon.getMessage("requestHost00", "Request Host"), tcpmon.getMessage("targetHost", "Target Host"), tcpmon.getMessage("request00", "Request...")}, 0);
            this.tableModel.addRow(new Object[]{"---", tcpmon.getMessage("mostRecent00", "Most Recent"), "---", "---", "---"});
            this.connectionTable = new JTable(1, 2);
            this.connectionTable.setModel(this.tableModel);
            this.connectionTable.setSelectionMode(2);
            TableColumn tableColumn = this.connectionTable.getColumnModel().getColumn(0);
            tableColumn.setMaxWidth(tableColumn.getPreferredWidth() / 2);
            tableColumn = this.connectionTable.getColumnModel().getColumn(4);
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() * 2);
            ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    int n = Listener.this.outPane.getDividerLocation();
                    if (listSelectionModel.isSelectionEmpty()) {
                        Listener.this.setLeft(new JLabel(" " + tcpmon.getMessage("wait00", "Waiting for Connection...")));
                        Listener.this.setRight(new JLabel(""));
                        Listener.this.removeButton.setEnabled(false);
                        Listener.this.removeAllButton.setEnabled(false);
                        Listener.this.saveButton.setEnabled(false);
                        Listener.this.resendButton.setEnabled(false);
                    } else {
                        int n2 = listSelectionModel.getLeadSelectionIndex();
                        if (n2 == 0) {
                            if (Listener.this.connections.size() == 0) {
                                Listener.this.setLeft(new JLabel(" " + tcpmon.getMessage("wait00", "Waiting for connection...")));
                                Listener.this.setRight(new JLabel(""));
                                Listener.this.removeButton.setEnabled(false);
                                Listener.this.removeAllButton.setEnabled(false);
                                Listener.this.saveButton.setEnabled(false);
                                Listener.this.resendButton.setEnabled(false);
                            } else {
                                Connection connection = (Connection)Listener.this.connections.lastElement();
                                Listener.this.setLeft(connection.inputScroll);
                                Listener.this.setRight(connection.outputScroll);
                                Listener.this.removeButton.setEnabled(false);
                                Listener.this.removeAllButton.setEnabled(true);
                                Listener.this.saveButton.setEnabled(true);
                                Listener.this.resendButton.setEnabled(true);
                            }
                        } else {
                            Connection connection = (Connection)Listener.this.connections.get(n2 - 1);
                            Listener.this.setLeft(connection.inputScroll);
                            Listener.this.setRight(connection.outputScroll);
                            Listener.this.removeButton.setEnabled(true);
                            Listener.this.removeAllButton.setEnabled(true);
                            Listener.this.saveButton.setEnabled(true);
                            Listener.this.resendButton.setEnabled(true);
                        }
                    }
                    Listener.this.outPane.setDividerLocation(n);
                }
            });
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(this.connectionTable);
            jPanel2.add((Component)jScrollPane, "Center");
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            final String string4 = tcpmon.getMessage("removeSelected00", "Remove Selected");
            this.removeButton = new JButton(string4);
            jPanel3.add(this.removeButton);
            jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
            final String string5 = tcpmon.getMessage("removeAll00", "Remove All");
            this.removeAllButton = new JButton(string5);
            jPanel3.add(this.removeAllButton);
            jPanel2.add((Component)jPanel3, "South");
            this.removeButton.setEnabled(false);
            this.removeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string4.equals(actionEvent.getActionCommand())) {
                        Listener.this.remove();
                    }
                }
            });
            this.removeAllButton.setEnabled(false);
            this.removeAllButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string5.equals(actionEvent.getActionCommand())) {
                        Listener.this.removeAll();
                    }
                }
            });
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BorderLayout());
            this.leftPanel = new JPanel();
            this.leftPanel.setAlignmentX(0.0f);
            this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
            this.leftPanel.add(new JLabel("  " + tcpmon.getMessage("request01", "Request")));
            this.leftPanel.add(new JLabel(" " + tcpmon.getMessage("wait01", "Waiting for connection")));
            this.rightPanel = new JPanel();
            this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
            this.rightPanel.add(new JLabel("  " + tcpmon.getMessage("response00", "Response")));
            this.rightPanel.add(new JLabel(""));
            this.outPane = new JSplitPane(0, this.leftPanel, this.rightPanel);
            this.outPane.setDividerSize(4);
            jPanel4.add((Component)this.outPane, "Center");
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.xmlFormatBox = new JCheckBox(tcpmon.getMessage("xmlFormat00", "XML Format"));
            jPanel5.add(this.xmlFormatBox);
            this.numericBox = new JCheckBox(tcpmon.getMessage("numericEnc00", "Numeric"));
            jPanel5.add(this.numericBox);
            jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
            final String string6 = tcpmon.getMessage("save00", "Save");
            this.saveButton = new JButton(string6);
            jPanel5.add(this.saveButton);
            jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
            final String string7 = tcpmon.getMessage("resend00", "Resend");
            this.resendButton = new JButton(string7);
            jPanel5.add(this.resendButton);
            jPanel5.add(Box.createRigidArea(new Dimension(5, 0)));
            final String string8 = tcpmon.getMessage("switch00", "Switch Layout");
            this.switchButton = new JButton(string8);
            jPanel5.add(this.switchButton);
            jPanel5.add(Box.createHorizontalGlue());
            final String string9 = tcpmon.getMessage("close00", "Close");
            this.closeButton = new JButton(string9);
            jPanel5.add(this.closeButton);
            jPanel4.add((Component)jPanel5, "South");
            this.saveButton.setEnabled(false);
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string6.equals(actionEvent.getActionCommand())) {
                        Listener.this.save();
                    }
                }
            });
            this.resendButton.setEnabled(false);
            this.resendButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string7.equals(actionEvent.getActionCommand())) {
                        Listener.this.resend();
                    }
                }
            });
            this.switchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string8.equals(actionEvent.getActionCommand())) {
                        int n = Listener.this.outPane.getOrientation();
                        if (n == 0) {
                            Listener.this.outPane.setOrientation(1);
                        } else {
                            Listener.this.outPane.setOrientation(0);
                        }
                        Listener.this.outPane.setDividerLocation(0.5);
                    }
                }
            });
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string9.equals(actionEvent.getActionCommand())) {
                        Listener.this.close();
                    }
                }
            });
            JSplitPane jSplitPane = new JSplitPane(0);
            jSplitPane.setDividerSize(4);
            jSplitPane.setTopComponent(jPanel2);
            jSplitPane.setBottomComponent(jPanel4);
            jSplitPane.setDividerLocation(150);
            this.add((Component)jSplitPane, "Center");
            listSelectionModel.setSelectionInterval(0, 0);
            this.outPane.setDividerLocation(150);
            this.notebook.addTab(string, this);
            this.start();
        }

        public void setLeft(Component component) {
            this.leftPanel.removeAll();
            this.leftPanel.add(component);
        }

        public void setRight(Component component) {
            this.rightPanel.removeAll();
            this.rightPanel.add(component);
        }

        public void start() {
            int n = Integer.parseInt(this.portField.getText());
            this.portField.setText("" + n);
            int n2 = this.notebook.indexOfComponent(this);
            this.notebook.setTitleAt(n2, tcpmon.getMessage("port01", "Port") + " " + n);
            int n3 = Integer.parseInt(this.tPortField.getText());
            this.tPortField.setText("" + n3);
            this.sw = new SocketWaiter(this, n);
            this.stopButton.setText(tcpmon.getMessage("stop00", "Stop"));
            this.portField.setEditable(false);
            this.hostField.setEditable(false);
            this.tPortField.setEditable(false);
            this.isProxyBox.setEnabled(false);
        }

        public void close() {
            this.stop();
            this.notebook.remove(this);
        }

        public void stop() {
            try {
                for (int i = 0; i < this.connections.size(); ++i) {
                    Connection connection = (Connection)this.connections.get(i);
                    connection.halt();
                }
                this.sw.halt();
                this.stopButton.setText(tcpmon.getMessage("start00", "Start"));
                this.portField.setEditable(true);
                this.hostField.setEditable(true);
                this.tPortField.setEditable(true);
                this.isProxyBox.setEnabled(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void remove() {
            int n;
            ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
            int n2 = listSelectionModel.getMinSelectionIndex();
            for (int i = n = listSelectionModel.getMaxSelectionIndex(); i >= n2; --i) {
                ((Connection)this.connections.get(i - 1)).remove();
            }
            if (n2 > this.connections.size()) {
                n2 = this.connections.size();
            }
            listSelectionModel.setSelectionInterval(n2, n2);
        }

        public void removeAll() {
            ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
            listSelectionModel.clearSelection();
            while (this.connections.size() > 0) {
                ((Connection)this.connections.get(0)).remove();
            }
            listSelectionModel.setSelectionInterval(0, 0);
        }

        public void save() {
            JFileChooser jFileChooser = new JFileChooser(".");
            int n = jFileChooser.showSaveDialog(this);
            if (n == 0) {
                try {
                    File file = jFileChooser.getSelectedFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
                    n = listSelectionModel.getLeadSelectionIndex();
                    int n2 = 0;
                    Iterator iterator = this.connections.iterator();
                    while (iterator.hasNext()) {
                        Connection connection = (Connection)iterator.next();
                        if (listSelectionModel.isSelectedIndex(n2 + 1) || !iterator.hasNext() && listSelectionModel.getLeadSelectionIndex() == 0) {
                            n = Integer.parseInt(this.portField.getText());
                            fileOutputStream.write("\n==============\n".getBytes());
                            fileOutputStream.write((tcpmon.getMessage("listenPort01", "Listen Port:") + " " + n + "\n").getBytes());
                            fileOutputStream.write((tcpmon.getMessage("targetHost01", "Target Host:") + " " + this.hostField.getText() + "\n").getBytes());
                            n = Integer.parseInt(this.tPortField.getText());
                            fileOutputStream.write((tcpmon.getMessage("targetPort01", "Target Port:") + " " + n + "\n").getBytes());
                            fileOutputStream.write(("==== " + tcpmon.getMessage("request01", "Request") + " ====\n").getBytes());
                            fileOutputStream.write(connection.inputText.getText().getBytes());
                            fileOutputStream.write(("==== " + tcpmon.getMessage("response00", "Response") + " ====\n").getBytes());
                            fileOutputStream.write(connection.outputText.getText().getBytes());
                            fileOutputStream.write("\n==============\n".getBytes());
                        }
                        ++n2;
                    }
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        public void resend() {
            try {
                ListSelectionModel listSelectionModel = this.connectionTable.getSelectionModel();
                int n = listSelectionModel.getLeadSelectionIndex();
                if (n == 0) {
                    n = this.connections.size();
                }
                Connection connection = (Connection)this.connections.get(n - 1);
                if (n > 0) {
                    listSelectionModel.clearSelection();
                    listSelectionModel.setSelectionInterval(0, 0);
                }
                ByteArrayInputStream byteArrayInputStream = null;
                String string = connection.inputText.getText();
                if (string.startsWith("POST ") || string.startsWith("GET ")) {
                    String string2;
                    int n2;
                    int n3 = string.indexOf("\n\n");
                    if (n3 == -1) {
                        n3 = string.indexOf("\r\n\r\n");
                        if (n3 != -1) {
                            n3 += 4;
                        }
                    } else {
                        n3 += 2;
                    }
                    if ((n2 = (string2 = string.substring(0, n3)).indexOf("Content-Length:")) != -1) {
                        int n4 = string.length() - n3;
                        int n5 = string2.indexOf("\n", n2);
                        System.err.println("CL: " + n4);
                        System.err.println("Hdrs: '" + string2 + "'");
                        System.err.println("subTEXT: '" + string.substring(n3, n3 + n4) + "'");
                        string = string2.substring(0, n2) + "Content-Length: " + n4 + "\n" + string2.substring(n5 + 1) + string.substring(n3);
                        System.err.println("\nTEXT: '" + string + "'");
                    }
                }
                byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                new Connection(this, byteArrayInputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class Connection
    extends Thread {
        Listener listener;
        boolean active;
        String fromHost;
        String time;
        JTextArea inputText = null;
        JScrollPane inputScroll = null;
        JTextArea outputText = null;
        JScrollPane outputScroll = null;
        Socket inSocket = null;
        Socket outSocket = null;
        Thread clientThread = null;
        Thread serverThread = null;
        SocketRR rr1 = null;
        SocketRR rr2 = null;
        InputStream inputStream = null;
        String HTTPProxyHost = null;
        int HTTPProxyPort = 80;
        private SlowLinkSimulator slowLink;

        public Connection(Listener listener) {
            this.listener = listener;
            this.HTTPProxyHost = listener.HTTPProxyHost;
            this.HTTPProxyPort = listener.HTTPProxyPort;
            this.slowLink = listener.slowLink;
        }

        public Connection(Listener listener, Socket socket) {
            this(listener);
            this.inSocket = socket;
            this.start();
        }

        public Connection(Listener listener, InputStream inputStream) {
            this(listener);
            this.inputStream = inputStream;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String string;
                int n;
                String string2;
                byte[] byArray;
                String string3;
                this.active = true;
                this.HTTPProxyHost = System.getProperty("http.proxyHost");
                if (this.HTTPProxyHost != null && this.HTTPProxyHost.equals("")) {
                    this.HTTPProxyHost = null;
                }
                if (this.HTTPProxyHost != null) {
                    string3 = System.getProperty("http.proxyPort");
                    if (string3 != null && string3.equals("")) {
                        string3 = null;
                    }
                    this.HTTPProxyPort = string3 == null ? 80 : Integer.parseInt(string3);
                }
                this.fromHost = this.inSocket != null ? this.inSocket.getInetAddress().getHostName() : "resend";
                string3 = tcpmon.getMessage("dateformat00", "yyyy-MM-dd HH:mm:ss");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string3);
                this.time = simpleDateFormat.format(new Date());
                int n2 = this.listener.connections.size();
                this.listener.tableModel.insertRow(n2 + 1, new Object[]{tcpmon.getMessage("active00", "Active"), this.time, this.fromHost, this.listener.hostField.getText(), ""});
                this.listener.connections.add(this);
                this.inputText = new JTextArea(null, null, 20, 80);
                this.inputScroll = new JScrollPane(this.inputText);
                this.outputText = new JTextArea(null, null, 20, 80);
                this.outputScroll = new JScrollPane(this.outputText);
                ListSelectionModel listSelectionModel = this.listener.connectionTable.getSelectionModel();
                if (n2 == 0 || listSelectionModel.getLeadSelectionIndex() == 0) {
                    this.listener.outPane.setVisible(false);
                    int n3 = this.listener.outPane.getDividerLocation();
                    this.listener.setLeft(this.inputScroll);
                    this.listener.setRight(this.outputScroll);
                    this.listener.removeButton.setEnabled(false);
                    this.listener.removeAllButton.setEnabled(true);
                    this.listener.saveButton.setEnabled(true);
                    this.listener.resendButton.setEnabled(true);
                    this.listener.outPane.setDividerLocation(n3);
                    this.listener.outPane.setVisible(true);
                }
                String string4 = this.listener.hostField.getText();
                int n4 = Integer.parseInt(this.listener.tPortField.getText());
                int n5 = Integer.parseInt(this.listener.portField.getText());
                InputStream inputStream = this.inputStream;
                OutputStream outputStream = null;
                InputStream inputStream2 = null;
                OutputStream outputStream2 = null;
                if (inputStream == null) {
                    inputStream = this.inSocket.getInputStream();
                }
                if (this.inSocket != null) {
                    outputStream = this.inSocket.getOutputStream();
                }
                String string5 = null;
                StringBuffer stringBuffer = null;
                int n6 = this.listener.connections.indexOf(this);
                if (this.listener.isProxyBox.isSelected() || this.HTTPProxyHost != null) {
                    int n7;
                    byArray = new byte[1];
                    stringBuffer = new StringBuffer();
                    while ((n7 = inputStream.read(byArray, 0, 1)) != -1) {
                        string2 = new String(byArray);
                        stringBuffer.append(string2);
                        if (byArray[0] != 10) continue;
                    }
                    string5 = stringBuffer.toString();
                    this.inputText.append(string5);
                    if (string5.startsWith("GET ") || string5.startsWith("POST ") || string5.startsWith("PUT ") || string5.startsWith("DELETE ")) {
                        URL uRL;
                        n7 = string5.indexOf(32) + 1;
                        while (string5.charAt(n7) == ' ') {
                            ++n7;
                        }
                        n = string5.indexOf(32, n7);
                        string = string5.substring(n7, n);
                        if (string.charAt(0) == '/') {
                            string = string.substring(1);
                        }
                        if (this.listener.isProxyBox.isSelected()) {
                            uRL = new URL(string);
                            string4 = uRL.getHost();
                            n4 = uRL.getPort();
                            if (n4 == -1) {
                                n4 = 80;
                            }
                            this.listener.tableModel.setValueAt(string4, n6 + 1, 3);
                            string5 = string5.substring(0, n7) + uRL.getFile() + string5.substring(n);
                        } else {
                            uRL = new URL("http://" + string4 + ":" + n4 + "/" + string);
                            this.listener.tableModel.setValueAt(string4, n6 + 1, 3);
                            string5 = string5.substring(0, n7) + uRL.toExternalForm() + string5.substring(n);
                            string4 = this.HTTPProxyHost;
                            n4 = this.HTTPProxyPort;
                        }
                    }
                } else {
                    byArray = new byte[1];
                    stringBuffer = new StringBuffer();
                    String string6 = null;
                    while ((n = inputStream.read(byArray, 0, 1)) != -1) {
                        string2 = new String(byArray);
                        stringBuffer.append(string2);
                        if (byArray[0] != 10) continue;
                        String string7 = stringBuffer.toString();
                        stringBuffer.setLength(0);
                        if (string7.startsWith("Host: ")) {
                            string = "Host: " + string4 + ":" + n5 + "\r\n";
                            string5 = string5.concat(string);
                            break;
                        }
                        string5 = string5 == null ? string7 : string5.concat(string7);
                        if (string7.equals("\r\n") || "\n".equals(string6) && string7.equals("\n")) break;
                        string6 = string7;
                    }
                    if (string5 != null) {
                        this.inputText.append(string5);
                        n = string5.length() < 50 ? string5.length() : 50;
                        string2 = string5.substring(0, n);
                        int n8 = string2.indexOf(10);
                        if (n8 > 0) {
                            string2 = string2.substring(0, n8 - 1);
                        }
                        string2 = string2 + "                           " + "                       ";
                        string2 = string2.substring(0, 51);
                        this.listener.tableModel.setValueAt(string2, n6 + 1, 4);
                    }
                }
                if (n4 == -1) {
                    n4 = 80;
                }
                this.outSocket = new Socket(string4, n4);
                inputStream2 = this.outSocket.getInputStream();
                outputStream2 = this.outSocket.getOutputStream();
                if (string5 != null) {
                    byArray = string5.getBytes();
                    outputStream2.write(byArray);
                    this.slowLink.pump(byArray.length);
                }
                boolean bl = this.listener.xmlFormatBox.isSelected();
                boolean bl2 = this.listener.numericBox.isSelected();
                this.rr1 = new SocketRR(this, this.inSocket, inputStream, this.outSocket, outputStream2, this.inputText, bl, bl2, this.listener.tableModel, n6 + 1, "request:", this.slowLink);
                SlowLinkSimulator slowLinkSimulator = new SlowLinkSimulator(this.slowLink);
                this.rr2 = new SocketRR(this, this.outSocket, inputStream2, this.inSocket, outputStream, this.outputText, bl, bl2, null, 0, "response:", slowLinkSimulator);
                while (this.rr1 != null || this.rr2 != null) {
                    if (null != this.rr1 && this.rr1.isDone()) {
                        if (n6 >= 0 && this.rr2 != null) {
                            this.listener.tableModel.setValueAt(tcpmon.getMessage("resp00", "Resp"), 1 + n6, 0);
                        }
                        this.rr1 = null;
                    }
                    if (null != this.rr2 && this.rr2.isDone()) {
                        if (n6 >= 0 && this.rr1 != null) {
                            this.listener.tableModel.setValueAt(tcpmon.getMessage("req00", "Req"), 1 + n6, 0);
                        }
                        this.rr2 = null;
                    }
                    Connection connection = this;
                    synchronized (connection) {
                        this.wait(1000L);
                    }
                }
                this.active = false;
                if (n6 >= 0) {
                    this.listener.tableModel.setValueAt(tcpmon.getMessage("done00", "Done"), 1 + n6, 0);
                }
            }
            catch (Exception exception) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                int n = this.listener.connections.indexOf(this);
                if (n >= 0) {
                    this.listener.tableModel.setValueAt(tcpmon.getMessage("error00", "Error"), 1 + n, 0);
                }
                exception.printStackTrace(printWriter);
                printWriter.close();
                if (this.outputText != null) {
                    this.outputText.append(stringWriter.toString());
                } else {
                    System.out.println(stringWriter.toString());
                }
                this.halt();
            }
        }

        synchronized void wakeUp() {
            this.notifyAll();
        }

        public void halt() {
            try {
                if (this.rr1 != null) {
                    this.rr1.halt();
                }
                if (this.rr2 != null) {
                    this.rr2.halt();
                }
                if (this.inSocket != null) {
                    this.inSocket.close();
                }
                this.inSocket = null;
                if (this.outSocket != null) {
                    this.outSocket.close();
                }
                this.outSocket = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void remove() {
            int n = -1;
            try {
                this.halt();
                n = this.listener.connections.indexOf(this);
                this.listener.tableModel.removeRow(n + 1);
                this.listener.connections.remove(n);
            }
            catch (Exception exception) {
                System.err.println("index:=" + n + this);
                exception.printStackTrace();
            }
        }
    }

    class SocketRR
    extends Thread {
        Socket inSocket = null;
        Socket outSocket = null;
        JTextArea textArea;
        InputStream in = null;
        OutputStream out = null;
        boolean xmlFormat;
        boolean numericEnc;
        volatile boolean done = false;
        TableModel tmodel = null;
        int tableIndex = 0;
        String type = null;
        Connection myConnection = null;
        SlowLinkSimulator slowLink;

        public SocketRR(Connection connection, Socket socket, InputStream inputStream, Socket socket2, OutputStream outputStream, JTextArea jTextArea, boolean bl, boolean bl2, TableModel tableModel, int n, String string, SlowLinkSimulator slowLinkSimulator) {
            this.inSocket = socket;
            this.in = inputStream;
            this.outSocket = socket2;
            this.out = outputStream;
            this.textArea = jTextArea;
            this.xmlFormat = bl;
            this.numericEnc = bl2;
            this.tmodel = tableModel;
            this.tableIndex = n;
            this.type = string;
            this.myConnection = connection;
            this.slowLink = slowLinkSimulator;
            this.start();
        }

        public boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block59: {
                String string;
                byte[] byArray = new byte[4096];
                byte[] byArray2 = new byte[8192];
                String string2 = null;
                int n = 0;
                int n2 = 0;
                int n3 = 3;
                boolean bl = true;
                int n4 = -1;
                int n5 = -1;
                int n6 = -1;
                if (this.tmodel != null && !"".equals(string = (String)this.tmodel.getValueAt(this.tableIndex, 4))) {
                    n2 = string.length();
                }
                block14: while (!this.done) {
                    int n7;
                    int n8 = byArray.length;
                    if (n8 == 0) {
                        n8 = byArray.length;
                    }
                    if (n + n8 > byArray.length) {
                        n8 = byArray.length - n;
                    }
                    int n9 = 0;
                    while (n9 == 0) {
                        try {
                            n9 = this.in.read(byArray, n, n8);
                        }
                        catch (Exception exception) {
                            if (this.done && n == 0) break block14;
                            n9 = -1;
                            break;
                        }
                    }
                    if ((n8 = n9) == -1 && n == 0) break;
                    if (n8 == -1) {
                        this.done = true;
                    }
                    if (this.out != null && n8 > 0) {
                        this.slowLink.pump(n8);
                        this.out.write(byArray, n, n8);
                    }
                    if (this.tmodel != null && n2 < 50) {
                        String string3 = (String)this.tmodel.getValueAt(this.tableIndex, 4);
                        if ((string3 = string3 + new String(byArray, n, n8)).length() > 50) {
                            string3 = string3.substring(0, 50);
                        }
                        n2 = string3.length();
                        n7 = string3.indexOf(10);
                        if (n7 > 0) {
                            string3 = string3.substring(0, n7 - 1);
                            n2 = 50;
                        }
                        this.tmodel.setValueAt(string3, this.tableIndex, 4);
                    }
                    if (this.xmlFormat) {
                        boolean bl2 = false;
                        int n10 = n;
                        if (n8 != -1) {
                            n10 += n8;
                        }
                        int n11 = 0;
                        n = 0;
                        for (int i = 0; i < n10; ++i) {
                            if (n8 != -1 && i + 1 == n10) {
                                n = 1;
                                break;
                            }
                            n4 = -1;
                            if (byArray[i] == 60 && byArray[i + 1] != 47) {
                                n6 = n5++;
                                n4 = n5;
                                bl2 = true;
                            }
                            if (byArray[i] == 60 && byArray[i + 1] == 47) {
                                if (n6 > n5) {
                                    n4 = n5;
                                }
                                --n5;
                                bl2 = true;
                            }
                            if (byArray[i] == 47 && byArray[i + 1] == 62) {
                                --n5;
                                bl2 = true;
                            }
                            if (n4 != -1) {
                                if (n4 > 0) {
                                    byArray2[n11++] = 10;
                                }
                                for (n7 = n3 * n4; n7 > 0; --n7) {
                                    byArray2[n11++] = 32;
                                }
                            }
                            boolean bl3 = bl = byArray[i] == 10 || byArray[i] == 13;
                            if (bl2 && bl) continue;
                            byArray2[n11++] = byArray[i];
                        }
                        string2 = new String(byArray2, 0, n11, this.getEncoding());
                        if (this.numericEnc) {
                            this.textArea.append(StringUtils.escapeNumericChar(string2));
                        } else {
                            this.textArea.append(StringUtils.unescapeNumericChar(string2));
                        }
                        for (n7 = 0; n7 < n; ++n7) {
                            byArray[n7] = byArray[n10 - n + n7];
                        }
                        continue;
                    }
                    string2 = new String(byArray, 0, n8, this.getEncoding());
                    if (this.numericEnc) {
                        this.textArea.append(StringUtils.escapeNumericChar(string2));
                        continue;
                    }
                    this.textArea.append(StringUtils.unescapeNumericChar(string2));
                }
                Object var19_22 = null;
                this.done = true;
                try {
                    if (this.out != null) {
                        this.out.flush();
                        if (null != this.outSocket) {
                            this.outSocket.shutdownOutput();
                        } else {
                            this.out.close();
                        }
                        this.out = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (this.in != null) {
                        if (this.inSocket != null) {
                            this.inSocket.shutdownInput();
                        } else {
                            this.in.close();
                        }
                        this.in = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.myConnection.wakeUp();
                {
                    break block59;
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        Object var19_23 = null;
                        this.done = true;
                        try {
                            if (this.out != null) {
                                this.out.flush();
                                if (null != this.outSocket) {
                                    this.outSocket.shutdownOutput();
                                } else {
                                    this.out.close();
                                }
                                this.out = null;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (this.in != null) {
                                if (this.inSocket != null) {
                                    this.inSocket.shutdownInput();
                                } else {
                                    this.in.close();
                                }
                                this.in = null;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.myConnection.wakeUp();
                    }
                }
                catch (Throwable throwable) {
                    Object var19_24 = null;
                    this.done = true;
                    try {
                        if (this.out != null) {
                            this.out.flush();
                            if (null != this.outSocket) {
                                this.outSocket.shutdownOutput();
                            } else {
                                this.out.close();
                            }
                            this.out = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (this.in != null) {
                            if (this.inSocket != null) {
                                this.inSocket.shutdownInput();
                            } else {
                                this.in.close();
                            }
                            this.in = null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.myConnection.wakeUp();
                    throw throwable;
                }
            }
        }

        private String getEncoding() {
            try {
                return XMLUtils.getEncoding();
            }
            catch (Throwable throwable) {
                return "UTF-8";
            }
        }

        public void halt() {
            try {
                if (this.inSocket != null) {
                    this.inSocket.close();
                }
                if (this.outSocket != null) {
                    this.outSocket.close();
                }
                this.inSocket = null;
                this.outSocket = null;
                if (this.in != null) {
                    this.in.close();
                }
                if (this.out != null) {
                    this.out.close();
                }
                this.in = null;
                this.out = null;
                this.done = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static class SlowLinkSimulator {
        private int delayBytes;
        private int delayTime;
        private int currentBytes;
        private int totalBytes;

        public SlowLinkSimulator(int n, int n2) {
            this.delayBytes = n;
            this.delayTime = n2;
        }

        public SlowLinkSimulator(SlowLinkSimulator slowLinkSimulator) {
            this.delayBytes = slowLinkSimulator.delayBytes;
            this.delayTime = slowLinkSimulator.delayTime;
        }

        public int getTotalBytes() {
            return this.totalBytes;
        }

        public void pump(int n) {
            this.totalBytes += n;
            if (this.delayBytes == 0) {
                return;
            }
            this.currentBytes += n;
            if (this.currentBytes > this.delayBytes) {
                int n2 = this.currentBytes / this.delayBytes;
                long l = (long)n2 * (long)this.delayTime;
                this.currentBytes %= this.delayBytes;
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public int getCurrentBytes() {
            return this.currentBytes;
        }

        public void setCurrentBytes(int n) {
            this.currentBytes = n;
        }
    }

    class SocketWaiter
    extends Thread {
        ServerSocket sSocket = null;
        Listener listener;
        int port;
        boolean pleaseStop = false;

        public SocketWaiter(Listener listener, int n) {
            this.listener = listener;
            this.port = n;
            this.start();
        }

        public void run() {
            block4: {
                try {
                    this.listener.setLeft(new JLabel(tcpmon.getMessage("wait00", " Waiting for Connection...")));
                    this.listener.repaint();
                    this.sSocket = new ServerSocket(this.port);
                    while (true) {
                        Socket socket = this.sSocket.accept();
                        if (!this.pleaseStop) {
                            new Connection(this.listener, socket);
                            socket = null;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    if ("socket closed".equals(exception.getMessage())) break block4;
                    JLabel jLabel = new JLabel(exception.toString());
                    jLabel.setForeground(Color.red);
                    this.listener.setLeft(jLabel);
                    this.listener.setRight(new JLabel(""));
                    this.listener.stop();
                }
            }
        }

        public void halt() {
            try {
                this.pleaseStop = true;
                new Socket(tcpmon.DEFAULT_HOST, this.port);
                if (this.sSocket != null) {
                    this.sSocket.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class AdminPage
    extends JPanel {
        public JRadioButton listenerButton;
        public JRadioButton proxyButton;
        public JLabel hostLabel;
        public JLabel tportLabel;
        public NumberField port;
        public HostnameField host;
        public NumberField tport;
        public JTabbedPane noteb;
        public JCheckBox HTTPProxyBox;
        public HostnameField HTTPProxyHost;
        public NumberField HTTPProxyPort;
        public JLabel HTTPProxyHostLabel;
        public JLabel HTTPProxyPortLabel;
        public JLabel delayTimeLabel;
        public JLabel delayBytesLabel;
        public NumberField delayTime;
        public NumberField delayBytes;
        public JCheckBox delayBox;

        public AdminPage(JTabbedPane jTabbedPane, String string) {
            JPanel jPanel = null;
            JButton jButton = null;
            this.setLayout(new BorderLayout());
            this.noteb = jTabbedPane;
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel = new JPanel(gridBagLayout);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)new JLabel(tcpmon.getMessage("newTCP00", "Create a new TCP/IP Monitor...") + " "), gridBagConstraints);
            jPanel.add(Box.createRigidArea(new Dimension(1, 5)), gridBagConstraints);
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            jPanel2.add((Component)new JLabel(tcpmon.getMessage("listenPort00", "Listen Port #") + " "), gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.port = new NumberField(4);
            jPanel2.add((Component)this.port, gridBagConstraints);
            jPanel.add((Component)jPanel2, gridBagConstraints);
            jPanel.add(Box.createRigidArea(new Dimension(1, 5)), gridBagConstraints);
            ButtonGroup buttonGroup = new ButtonGroup();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)new JLabel(tcpmon.getMessage("actAs00", "Act as a...")), gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            final String string2 = tcpmon.getMessage("listener00", "Listener");
            this.listenerButton = new JRadioButton(string2);
            jPanel.add((Component)this.listenerButton, gridBagConstraints);
            buttonGroup.add(this.listenerButton);
            this.listenerButton.setSelected(true);
            this.listenerButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string2.equals(actionEvent.getActionCommand())) {
                        boolean bl = AdminPage.this.listenerButton.isSelected();
                        AdminPage.this.tport.setEnabled(bl);
                        AdminPage.this.host.setEnabled(bl);
                        AdminPage.this.hostLabel.setForeground(bl ? Color.black : Color.gray);
                        AdminPage.this.tportLabel.setForeground(bl ? Color.black : Color.gray);
                    }
                }
            });
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            jPanel.add(Box.createRigidArea(new Dimension(25, 0)));
            this.hostLabel = new JLabel(tcpmon.getMessage("targetHostname00", "Target Hostname") + " ");
            jPanel.add((Component)this.hostLabel, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.host = new HostnameField(30);
            jPanel.add((Component)this.host, gridBagConstraints);
            this.host.setText(tcpmon.DEFAULT_HOST);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            jPanel.add(Box.createRigidArea(new Dimension(25, 0)));
            this.tportLabel = new JLabel(tcpmon.getMessage("targetPort00", "Target Port #") + " ");
            jPanel.add((Component)this.tportLabel, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.tport = new NumberField(4);
            jPanel.add((Component)this.tport, gridBagConstraints);
            this.tport.setValue(8080);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            final String string3 = tcpmon.getMessage("proxy00", "Proxy");
            this.proxyButton = new JRadioButton(string3);
            jPanel.add((Component)this.proxyButton, gridBagConstraints);
            buttonGroup.add(this.proxyButton);
            this.proxyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string3.equals(actionEvent.getActionCommand())) {
                        boolean bl = AdminPage.this.proxyButton.isSelected();
                        AdminPage.this.tport.setEnabled(!bl);
                        AdminPage.this.host.setEnabled(!bl);
                        AdminPage.this.hostLabel.setForeground(bl ? Color.gray : Color.black);
                        AdminPage.this.tportLabel.setForeground(bl ? Color.gray : Color.black);
                    }
                }
            });
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            jPanel.add(Box.createRigidArea(new Dimension(1, 10)), gridBagConstraints);
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            jPanel3.setBorder(new TitledBorder(tcpmon.getMessage("options00", "Options")));
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)jPanel3, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            final String string4 = tcpmon.getMessage("proxySupport00", "HTTP Proxy Support");
            this.HTTPProxyBox = new JCheckBox(string4);
            jPanel3.add((Component)this.HTTPProxyBox, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            this.HTTPProxyHostLabel = new JLabel(tcpmon.getMessage("hostname00", "Hostname") + " ");
            jPanel3.add((Component)this.HTTPProxyHostLabel, gridBagConstraints);
            this.HTTPProxyHostLabel.setForeground(Color.gray);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.HTTPProxyHost = new HostnameField(30);
            jPanel3.add((Component)this.HTTPProxyHost, gridBagConstraints);
            this.HTTPProxyHost.setEnabled(false);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            this.HTTPProxyPortLabel = new JLabel(tcpmon.getMessage("port00", "Port #") + " ");
            jPanel3.add((Component)this.HTTPProxyPortLabel, gridBagConstraints);
            this.HTTPProxyPortLabel.setForeground(Color.gray);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.HTTPProxyPort = new NumberField(4);
            jPanel3.add((Component)this.HTTPProxyPort, gridBagConstraints);
            this.HTTPProxyPort.setEnabled(false);
            this.HTTPProxyBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string4.equals(actionEvent.getActionCommand())) {
                        boolean bl = AdminPage.this.HTTPProxyBox.isSelected();
                        Color color = bl ? Color.black : Color.gray;
                        AdminPage.this.HTTPProxyHost.setEnabled(bl);
                        AdminPage.this.HTTPProxyPort.setEnabled(bl);
                        AdminPage.this.HTTPProxyHostLabel.setForeground(color);
                        AdminPage.this.HTTPProxyPortLabel.setForeground(color);
                    }
                }
            });
            String string5 = System.getProperty("http.proxyHost");
            if (string5 != null && string5.equals("")) {
                string5 = null;
            }
            this.HTTPProxyBox.setSelected(string5 != null);
            this.HTTPProxyHost.setEnabled(string5 != null);
            this.HTTPProxyPort.setEnabled(string5 != null);
            this.HTTPProxyHostLabel.setForeground(string5 != null ? Color.black : Color.gray);
            this.HTTPProxyPortLabel.setForeground(string5 != null ? Color.black : Color.gray);
            if (string5 != null) {
                this.HTTPProxyBox.setSelected(true);
                this.HTTPProxyHost.setText(string5);
                string5 = System.getProperty("http.proxyPort");
                if (string5 != null && string5.equals("")) {
                    string5 = null;
                }
                if (string5 == null) {
                    string5 = "80";
                }
                this.HTTPProxyPort.setText(string5);
            }
            jPanel3.add(Box.createRigidArea(new Dimension(1, 10)), gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            final String string6 = tcpmon.getMessage("delay00", "Simulate Slow Connection");
            this.delayBox = new JCheckBox(string6);
            jPanel3.add((Component)this.delayBox, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            this.delayBytesLabel = new JLabel(tcpmon.getMessage("delay01", "Bytes per Pause"));
            jPanel3.add((Component)this.delayBytesLabel, gridBagConstraints);
            this.delayBytesLabel.setForeground(Color.gray);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.delayBytes = new NumberField(6);
            jPanel3.add((Component)this.delayBytes, gridBagConstraints);
            this.delayBytes.setEnabled(false);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            this.delayTimeLabel = new JLabel(tcpmon.getMessage("delay02", "Delay in Milliseconds"));
            jPanel3.add((Component)this.delayTimeLabel, gridBagConstraints);
            this.delayTimeLabel.setForeground(Color.gray);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            this.delayTime = new NumberField(6);
            jPanel3.add((Component)this.delayTime, gridBagConstraints);
            this.delayTime.setEnabled(false);
            this.delayBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string6.equals(actionEvent.getActionCommand())) {
                        boolean bl = AdminPage.this.delayBox.isSelected();
                        Color color = bl ? Color.black : Color.gray;
                        AdminPage.this.delayBytes.setEnabled(bl);
                        AdminPage.this.delayTime.setEnabled(bl);
                        AdminPage.this.delayBytesLabel.setForeground(color);
                        AdminPage.this.delayTimeLabel.setForeground(color);
                    }
                }
            });
            jPanel.add(Box.createRigidArea(new Dimension(1, 10)), gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 0;
            final String string7 = tcpmon.getMessage("add00", "Add");
            jButton = new JButton(string7);
            jPanel.add((Component)jButton, gridBagConstraints);
            this.add((Component)new JScrollPane(jPanel), "Center");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (string7.equals(actionEvent.getActionCommand())) {
                        Listener listener = null;
                        int n = AdminPage.this.port.getValue(0);
                        if (n == 0) {
                            return;
                        }
                        String string = AdminPage.this.host.getText();
                        int n2 = 0;
                        n2 = AdminPage.this.tport.getValue(0);
                        SlowLinkSimulator slowLinkSimulator = null;
                        if (AdminPage.this.delayBox.isSelected()) {
                            int n3 = AdminPage.this.delayBytes.getValue(0);
                            int n4 = AdminPage.this.delayTime.getValue(0);
                            slowLinkSimulator = new SlowLinkSimulator(n3, n4);
                        }
                        try {
                            listener = new Listener(AdminPage.this.noteb, null, n, string, n2, AdminPage.this.proxyButton.isSelected(), slowLinkSimulator);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        String string2 = AdminPage.this.HTTPProxyHost.getText();
                        if ("".equals(string2)) {
                            string2 = null;
                        }
                        listener.HTTPProxyHost = string2;
                        string2 = AdminPage.this.HTTPProxyPort.getText();
                        int n5 = AdminPage.this.HTTPProxyPort.getValue(-1);
                        if (n5 != -1) {
                            listener.HTTPProxyPort = Integer.parseInt(string2);
                        }
                        AdminPage.this.port.setText(null);
                    }
                }
            });
            jTabbedPane.addTab(string, this);
            jTabbedPane.repaint();
            jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
        }
    }
}

