/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.fromJava;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.holders.Holder;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.Constants;
import org.apache.axis.InternalException;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.SimpleType;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.encoding.ser.EnumSerializerFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.StringUtils;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.fromJava.Emitter;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.symbolTable.BaseTypeMapping;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.commons.logging.Log;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Types {
    protected static Log log = LogFactory.getLog(Types.class.getName());
    Definition def;
    Namespaces namespaces = null;
    TypeMapping tm;
    TypeMapping defaultTM;
    String targetNamespace;
    Element wsdlTypesElem = null;
    HashMap schemaTypes = null;
    HashMap schemaElementNames = null;
    HashMap schemaUniqueElementNames = null;
    HashMap wrapperMap = new HashMap();
    List stopClasses = null;
    List beanCompatErrs = new ArrayList();
    private ServiceDesc serviceDesc = null;
    private Set writtenElementQNames = new HashSet();
    Class[] mappedTypes = null;
    Emitter emitter = null;
    Document docHolder;

    public static boolean isArray(Class clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz);
    }

    private static Class getComponentType(Class clazz) {
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return Object.class;
        }
        return null;
    }

    public Types(Definition definition, TypeMapping typeMapping, TypeMapping typeMapping2, Namespaces namespaces, String string, List list, ServiceDesc serviceDesc) {
        this.def = definition;
        this.serviceDesc = serviceDesc;
        this.createDocumentFragment();
        this.tm = typeMapping;
        this.defaultTM = typeMapping2;
        this.mappedTypes = typeMapping.getAllClasses();
        this.namespaces = namespaces;
        this.targetNamespace = string;
        this.stopClasses = list;
        this.schemaElementNames = new HashMap();
        this.schemaUniqueElementNames = new HashMap();
        this.schemaTypes = new HashMap();
    }

    public Types(Definition definition, TypeMapping typeMapping, TypeMapping typeMapping2, Namespaces namespaces, String string, List list, ServiceDesc serviceDesc, Emitter emitter) {
        this(definition, typeMapping, typeMapping2, namespaces, string, list, serviceDesc);
        this.emitter = emitter;
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    public void loadInputSchema(String string) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        Document document = XMLUtils.newDocument(string);
        Element element = document.getDocumentElement();
        if (element.getLocalName().equals("schema") && Constants.isSchemaXSD(element.getNamespaceURI())) {
            Node node = this.docHolder.importNode(element, true);
            if (null == this.wsdlTypesElem) {
                this.writeWsdlTypesElement();
            }
            this.wsdlTypesElem.appendChild(node);
            BaseTypeMapping baseTypeMapping = new BaseTypeMapping(){

                public String getBaseName(QName qName) {
                    QName qName2 = new QName(qName.getNamespaceURI(), qName.getLocalPart());
                    Class clazz = Types.this.defaultTM.getClassForQName(qName2);
                    if (clazz == null) {
                        return null;
                    }
                    return JavaUtils.getTextClassName(clazz.getName());
                }
            };
            SymbolTable symbolTable = new SymbolTable(baseTypeMapping, true, false, false);
            symbolTable.populateTypes(new URL(string), document);
            this.processSymTabEntries(symbolTable);
        }
    }

    private void processSymTabEntries(SymbolTable symbolTable) {
        String string;
        TypeEntry typeEntry;
        QName qName;
        for (Map.Entry entry : symbolTable.getElementIndex().entrySet()) {
            qName = (QName)entry.getKey();
            typeEntry = (TypeEntry)entry.getValue();
            string = XMLUtils.getPrefix(qName.getNamespaceURI(), typeEntry.getNode());
            if (null != string && !"".equals(string)) {
                this.namespaces.putPrefix(qName.getNamespaceURI(), string);
                this.def.addNamespace(string, qName.getNamespaceURI());
            }
            this.addToElementsList(qName);
        }
        for (Map.Entry entry : symbolTable.getTypeIndex().entrySet()) {
            qName = (QName)entry.getKey();
            typeEntry = (TypeEntry)entry.getValue();
            string = XMLUtils.getPrefix(qName.getNamespaceURI(), typeEntry.getNode());
            if (null != string && !"".equals(string)) {
                this.namespaces.putPrefix(qName.getNamespaceURI(), string);
                this.def.addNamespace(string, qName.getNamespaceURI());
            }
            this.addToTypesList(qName);
        }
    }

    public void loadInputTypes(String string) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        Object object;
        Document document = XMLUtils.newDocument(string);
        NodeList nodeList = document.getChildNodes();
        if (nodeList.getLength() > 0 && nodeList.item(0).getLocalName().equals("definitions")) {
            nodeList = nodeList.item(0).getChildNodes();
            for (int i = 0; i < nodeList.getLength() && this.wsdlTypesElem == null; ++i) {
                object = nodeList.item(i);
                if (object.getLocalName() == null || !object.getLocalName().equals("types")) continue;
                this.wsdlTypesElem = (Element)object;
            }
        }
        if (this.wsdlTypesElem == null) {
            return;
        }
        this.wsdlTypesElem = (Element)this.docHolder.importNode(this.wsdlTypesElem, true);
        this.docHolder.appendChild(this.wsdlTypesElem);
        BaseTypeMapping baseTypeMapping = new BaseTypeMapping(){

            public String getBaseName(QName qName) {
                QName qName2 = new QName(qName.getNamespaceURI(), qName.getLocalPart());
                Class clazz = Types.this.tm.getClassForQName(qName2);
                if (clazz == null) {
                    return null;
                }
                return JavaUtils.getTextClassName(clazz.getName());
            }
        };
        object = new SymbolTable(baseTypeMapping, true, false, false);
        ((SymbolTable)object).populate(null, document);
        this.processSymTabEntries((SymbolTable)object);
    }

    public QName writeTypeForPart(Class clazz, QName qName) throws AxisFault {
        if (clazz.getName().equals("void")) {
            return null;
        }
        if (Holder.class.isAssignableFrom(clazz)) {
            clazz = JavaUtils.getHolderValueType(clazz);
        }
        if ((qName == null || Constants.isSOAP_ENC(qName.getNamespaceURI()) && "Array".equals(qName.getLocalPart())) && (qName = this.getTypeQName(clazz)) == null) {
            throw new AxisFault("Class:" + clazz.getName());
        }
        if (!this.makeTypeElement(clazz, qName, null)) {
            qName = Constants.XSD_ANYTYPE;
        }
        return qName;
    }

    public QName writeTypeAndSubTypeForPart(Class clazz, QName qName) throws AxisFault {
        QName qName2 = this.writeTypeForPart(clazz, qName);
        if (this.mappedTypes != null) {
            for (int i = 0; i < this.mappedTypes.length; ++i) {
                Class clazz2 = this.mappedTypes[i];
                if (clazz2 == null || clazz == Object.class || clazz2 == clazz || !clazz.isAssignableFrom(clazz2)) continue;
                QName qName3 = this.tm.getTypeQName(clazz2);
                if (!this.isAnonymousType(qName3)) {
                    this.writeTypeForPart(clazz2, qName3);
                }
                this.mappedTypes[i] = null;
            }
        }
        return qName2;
    }

    public QName writeElementForPart(Class clazz, QName qName) throws AxisFault {
        if (clazz.getName().equals("void")) {
            return null;
        }
        if (Holder.class.isAssignableFrom(clazz)) {
            clazz = JavaUtils.getHolderValueType(clazz);
        }
        if ((qName == null || Constants.isSOAP_ENC(qName.getNamespaceURI()) && "Array".equals(qName.getLocalPart())) && (qName = this.getTypeQName(clazz)) == null) {
            throw new AxisFault("Class:" + clazz.getName());
        }
        String string = qName.getNamespaceURI();
        if (Constants.isSchemaXSD(string) || Constants.isSOAP_ENC(string) && !"Array".equals(qName.getLocalPart())) {
            return null;
        }
        if (this.wsdlTypesElem == null) {
            this.writeWsdlTypesElement();
        }
        if (this.writeTypeAsElement(clazz, qName) == null) {
            qName = null;
        }
        return qName;
    }

    public Element writeWrapperElement(QName qName, boolean bl, boolean bl2) throws AxisFault {
        if (this.wsdlTypesElem == null) {
            this.writeWsdlTypesElement();
        }
        this.writeTypeNamespace(qName.getNamespaceURI());
        Element element = this.docHolder.createElement("element");
        this.writeSchemaElementDecl(qName, element);
        element.setAttribute("name", qName.getLocalPart());
        Element element2 = this.docHolder.createElement("complexType");
        element.appendChild(element2);
        if (bl2) {
            Element element3 = this.docHolder.createElement("sequence");
            element2.appendChild(element3);
            return element3;
        }
        return null;
    }

    public void writeWrappedParameter(Element element, String string, QName qName, Class clazz) throws AxisFault {
        Element element2;
        if (clazz == Void.TYPE) {
            return;
        }
        qName = clazz.isArray() && !clazz.equals(byte[].class) ? this.writeTypeForPart(clazz.getComponentType(), null) : this.writeTypeForPart(clazz, qName);
        if (qName == null) {
            return;
        }
        if (this.isAnonymousType(qName)) {
            element2 = this.createElementWithAnonymousType(string, clazz, false, this.docHolder);
        } else {
            element2 = this.docHolder.createElement("element");
            element2.setAttribute("name", string);
            String string2 = this.namespaces.getCreatePrefix(qName.getNamespaceURI());
            String string3 = string2 + ":" + qName.getLocalPart();
            element2.setAttribute("type", string3);
            if (clazz.isArray() && !clazz.equals(byte[].class)) {
                element2.setAttribute("maxOccurs", "unbounded");
            }
        }
        element.appendChild(element2);
    }

    private boolean isAnonymousType(QName qName) {
        return qName.getLocalPart().indexOf(">") != -1;
    }

    private QName writeTypeAsElement(Class clazz, QName qName) throws AxisFault {
        if (qName == null || Constants.equals(Constants.SOAP_ARRAY, qName)) {
            qName = this.getTypeQName(clazz);
        }
        this.writeTypeNamespace(clazz, qName);
        String string = this.writeType(clazz, qName);
        if (string != null) {
            return qName;
        }
        return null;
    }

    private QName writeTypeNamespace(Class clazz, QName qName) {
        if (qName == null) {
            qName = this.getTypeQName(clazz);
        }
        this.writeTypeNamespace(qName.getNamespaceURI());
        return qName;
    }

    private void writeTypeNamespace(String string) {
        String string2;
        if (string != null && !string.equals("") && (string2 = this.def.getPrefix(string)) == null) {
            this.def.addNamespace(this.namespaces.getCreatePrefix(string), string);
        }
    }

    public QName getTypeQName(Class clazz) {
        QName qName = null;
        qName = this.tm.getTypeQName(clazz);
        if (Types.isArray(clazz) && Constants.equals(Constants.SOAP_ARRAY, qName)) {
            QName qName2;
            Class clazz2 = Types.getComponentType(clazz);
            String string = "ArrayOf";
            boolean bl = JavaUtils.isTrue(AxisProperties.getProperty("axis.ws-i.bp11.compatibility"));
            if (bl) {
                string = "MyArrayOf";
            }
            if (this.targetNamespace.equals((qName2 = this.getTypeQName(clazz2)).getNamespaceURI())) {
                qName = new QName(this.targetNamespace, string + qName2.getLocalPart());
            } else {
                String string2 = this.namespaces.getCreatePrefix(qName2.getNamespaceURI());
                qName = new QName(this.targetNamespace, string + "_" + string2 + "_" + qName2.getLocalPart());
            }
            return qName;
        }
        if (qName == null) {
            String string = Types.getPackageNameFromFullName(clazz.getName());
            String string3 = Types.getLocalNameFromFullName(clazz.getName());
            String string4 = this.namespaces.getCreate(string);
            this.namespaces.getCreatePrefix(string4);
            String string5 = string3.replace('$', '_');
            qName = new QName(string4, string5);
        }
        return qName;
    }

    public String getQNameString(QName qName) {
        String string = this.namespaces.getCreatePrefix(qName.getNamespaceURI());
        return string + ":" + qName.getLocalPart();
    }

    public static String getPackageNameFromFullName(String string) {
        if (string.lastIndexOf(46) < 0) {
            return "";
        }
        return string.substring(0, string.lastIndexOf(46));
    }

    public static String getLocalNameFromFullName(String string) {
        String string2 = "";
        if (string.startsWith("[L")) {
            string2 = "[]";
            string = string.substring(3, string.length() - 1);
        }
        if (string.lastIndexOf(46) < 0) {
            return string + string2;
        }
        return string.substring(string.lastIndexOf(46) + 1) + string2;
    }

    public void writeSchemaTypeDecl(QName qName, Element element) throws AxisFault {
        this.writeSchemaElement(qName.getNamespaceURI(), element);
    }

    public void writeSchemaElementDecl(QName qName, Element element) throws AxisFault {
        if (this.writtenElementQNames.contains(qName)) {
            throw new AxisFault("Server.generalException", Messages.getMessage("duplicateSchemaElement", qName.toString()), null, null);
        }
        this.writeSchemaElement(qName.getNamespaceURI(), element);
        this.writtenElementQNames.add(qName);
    }

    public void writeSchemaElement(QName qName, Element element) throws AxisFault {
        this.writeSchemaElement(qName.getNamespaceURI(), element);
    }

    public void writeSchemaElement(String string, Element element) throws AxisFault {
        if (this.wsdlTypesElem == null) {
            try {
                this.writeWsdlTypesElement();
            }
            catch (Exception exception) {
                log.error(exception);
                return;
            }
        }
        if (string == null || string.equals("")) {
            throw new AxisFault("Server.generalException", Messages.getMessage("noNamespace00", string), null, null);
        }
        Node node = null;
        NodeList nodeList = this.wsdlTypesElem.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            if (namedNodeMap == null) continue;
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Attr attr = (Attr)namedNodeMap.item(j);
                if (!attr.getName().equals("targetNamespace") || !attr.getValue().equals(string)) continue;
                node = (Element)nodeList.item(i);
            }
        }
        if (node == null) {
            node = this.docHolder.createElement("schema");
            this.wsdlTypesElem.appendChild(node);
            node.setAttribute("xmlns", "http://www.w3.org/2001/XMLSchema");
            node.setAttribute("targetNamespace", string);
            if (this.serviceDesc.getStyle() == Style.RPC) {
                Element element2 = this.docHolder.createElement("import");
                node.appendChild(element2);
                element2.setAttribute("namespace", Constants.URI_DEFAULT_SOAP_ENC);
            }
            SOAPService sOAPService = null;
            if (MessageContext.getCurrentContext() != null) {
                sOAPService = MessageContext.getCurrentContext().getService();
            }
            if (sOAPService != null && this.isPresent((String)sOAPService.getOption("schemaQualified"), string)) {
                node.setAttribute("elementFormDefault", "qualified");
            } else if (!(sOAPService != null && this.isPresent((String)sOAPService.getOption("schemaUnqualified"), string) || this.serviceDesc.getStyle() != Style.DOCUMENT && this.serviceDesc.getStyle() != Style.WRAPPED)) {
                node.setAttribute("elementFormDefault", "qualified");
            }
            this.writeTypeNamespace(string);
        }
        node.appendChild(element);
    }

    private boolean isPresent(String string, String string2) {
        if (string == null || string.length() == 0) {
            return false;
        }
        String[] stringArray = StringUtils.split(string, ',');
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return true;
        }
        return false;
    }

    private void writeWsdlTypesElement() {
        if (this.wsdlTypesElem == null) {
            this.wsdlTypesElem = this.docHolder.createElementNS("http://schemas.xmlsoap.org/wsdl/", "types");
            this.wsdlTypesElem.setPrefix("wsdl");
        }
    }

    public String writeType(Class clazz) throws AxisFault {
        return this.writeType(clazz, null);
    }

    public String writeType(Class clazz, QName qName) throws AxisFault {
        if (qName == null || Constants.equals(Constants.SOAP_ARRAY, qName)) {
            qName = this.getTypeQName(clazz);
        }
        if (!this.makeTypeElement(clazz, qName, null)) {
            return null;
        }
        return this.getQNameString(qName);
    }

    public Element createArrayElement(String string) {
        MessageContext messageContext = MessageContext.getCurrentContext();
        SOAPConstants sOAPConstants = messageContext == null || messageContext.getSOAPConstants() == null ? SOAPConstants.SOAP11_CONSTANTS : messageContext.getSOAPConstants();
        String string2 = this.namespaces.getCreatePrefix(sOAPConstants.getEncodingURI());
        Element element = this.docHolder.createElement("complexType");
        Element element2 = this.docHolder.createElement("complexContent");
        element.appendChild(element2);
        Element element3 = this.docHolder.createElement("restriction");
        element2.appendChild(element3);
        element3.setAttribute("base", string2 + ":Array");
        Element element4 = this.docHolder.createElement("attribute");
        element3.appendChild(element4);
        element4.setAttribute("ref", string2 + ":arrayType");
        string2 = this.namespaces.getCreatePrefix("http://schemas.xmlsoap.org/wsdl/");
        element4.setAttribute(string2 + ":arrayType", string);
        return element;
    }

    public Element createLiteralArrayElement(String string, QName qName) {
        String string2 = "item";
        if (qName != null) {
            string2 = qName.getLocalPart();
        }
        Element element = this.docHolder.createElement("complexType");
        Element element2 = this.docHolder.createElement("sequence");
        element.appendChild(element2);
        Element element3 = this.docHolder.createElement("element");
        element3.setAttribute("name", string2);
        element3.setAttribute("type", string);
        element3.setAttribute("minOccurs", "0");
        element3.setAttribute("maxOccurs", "unbounded");
        element2.appendChild(element3);
        return element;
    }

    public static boolean isEnumClass(Class clazz) {
        block5: {
            Method method = clazz.getMethod("getValue", null);
            Method method2 = clazz.getMethod("toString", null);
            if (method == null || method2 == null) break block5;
            Method method3 = clazz.getDeclaredMethod("fromString", String.class);
            Method method4 = clazz.getDeclaredMethod("fromValue", method.getReturnType());
            if (method3 == null || !Modifier.isStatic(method3.getModifiers()) || !Modifier.isPublic(method3.getModifiers()) || method4 == null || !Modifier.isStatic(method4.getModifiers()) || !Modifier.isPublic(method4.getModifiers())) break block5;
            try {
                return clazz.getMethod("setValue", method.getReturnType()) == null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return true;
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public Element writeEnumType(QName qName, Class clazz) throws NoSuchMethodException, IllegalAccessException, AxisFault {
        if (!Types.isEnumClass(clazz)) {
            return null;
        }
        Method method = clazz.getMethod("getValue", null);
        Class<?> clazz2 = method.getReturnType();
        Element element = this.docHolder.createElement("simpleType");
        element.setAttribute("name", qName.getLocalPart());
        Element element2 = this.docHolder.createElement("restriction");
        element.appendChild(element2);
        String string = this.writeType(clazz2, null);
        element2.setAttribute("base", string);
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n = field.getModifiers();
            if (!Modifier.isPublic(n) || !Modifier.isStatic(n) || !Modifier.isFinal(n) || field.getType() != clazz2) continue;
            Element element3 = this.docHolder.createElement("enumeration");
            element3.setAttribute("value", field.get(null).toString());
            element2.appendChild(element3);
        }
        return element;
    }

    public void writeElementDecl(QName qName, Class clazz, QName qName2, boolean bl, QName qName3) throws AxisFault {
        if (this.writtenElementQNames.contains(qName)) {
            return;
        }
        String string = qName.getLocalPart();
        Element element = this.docHolder.createElement("element");
        element.setAttribute("name", string);
        if (bl) {
            element.setAttribute("nillable", "true");
        }
        if (clazz.isArray()) {
            String string2 = this.writeType(clazz.getComponentType());
            Element element2 = this.createLiteralArrayElement(string2, qName3);
            element.appendChild(element2);
        } else {
            this.makeTypeElement(clazz, qName2, element);
        }
        this.writeSchemaElementDecl(qName, element);
    }

    public Element createElement(String string, String string2, boolean bl, boolean bl2, Document document) {
        Element element = document.createElement("element");
        element.setAttribute("name", string);
        if (bl) {
            element.setAttribute("nillable", "true");
        }
        if (bl2) {
            element.setAttribute("minOccurs", "0");
            element.setAttribute("maxOccurs", "1");
        }
        if (string2 != null) {
            element.setAttribute("type", string2);
        }
        return element;
    }

    public Element createAttributeElement(String string, Class clazz, QName qName, boolean bl, Document document) throws AxisFault {
        Element element = document.createElement("attribute");
        element.setAttribute("name", string);
        if (bl) {
            element.setAttribute("nillable", "true");
        }
        this.makeTypeElement(clazz, qName, element);
        return element;
    }

    boolean isSimpleType(Class clazz) {
        QName qName = this.tm.getTypeQName(clazz);
        if (qName == null) {
            return false;
        }
        String string = qName.getNamespaceURI();
        return Constants.isSchemaXSD(string) || Constants.isSOAP_ENC(string);
    }

    public boolean isAcceptableAsAttribute(Class clazz) {
        return this.isSimpleType(clazz) || Types.isEnumClass(clazz) || this.implementsSimpleType(clazz);
    }

    boolean implementsSimpleType(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != SimpleType.class) continue;
            return true;
        }
        return false;
    }

    private boolean addToTypesList(QName qName) {
        boolean bl = false;
        String string = qName.getNamespaceURI();
        ArrayList<String> arrayList = (ArrayList<String>)this.schemaTypes.get(string);
        if (Constants.isSchemaXSD(string) || Constants.isSOAP_ENC(string) && !"Array".equals(qName.getLocalPart())) {
            this.writeTypeNamespace(string);
            return false;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            arrayList.add(qName.getLocalPart());
            this.writeTypeNamespace(string);
            this.schemaTypes.put(string, arrayList);
            bl = true;
        } else if (!arrayList.contains(qName.getLocalPart())) {
            arrayList.add(qName.getLocalPart());
            bl = true;
        }
        if (bl) {
            String string2 = this.namespaces.getCreatePrefix(string);
            return !string2.equals("soapenv") && !string2.equals("soapenc") && !string2.equals("xsd") && !string2.equals("wsdl") && !string2.equals("wsdlsoap");
        }
        return false;
    }

    private boolean addToElementsList(QName qName) {
        if (qName == null) {
            return false;
        }
        boolean bl = false;
        ArrayList<String> arrayList = (ArrayList<String>)this.schemaElementNames.get(qName.getNamespaceURI());
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            arrayList.add(qName.getLocalPart());
            this.schemaElementNames.put(qName.getNamespaceURI(), arrayList);
            bl = true;
        } else if (!arrayList.contains(qName.getLocalPart())) {
            arrayList.add(qName.getLocalPart());
            bl = true;
        }
        return bl;
    }

    public static boolean isNullable(Class clazz) {
        return !clazz.isPrimitive();
    }

    private void createDocumentFragment() {
        try {
            this.docHolder = XMLUtils.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InternalException(parserConfigurationException);
        }
    }

    public void updateNamespaces() {
        Namespaces namespaces = this.getNamespaces();
        Iterator iterator = namespaces.getNamespaces();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.def.getPrefix(string);
            if (string2 != null) continue;
            this.def.addNamespace(namespaces.getCreatePrefix(string), string);
        }
    }

    public void insertTypesFragment(Document document) {
        this.updateNamespaces();
        if (this.wsdlTypesElem == null) {
            return;
        }
        Element element = null;
        String string = null;
        NodeList nodeList = this.wsdlTypesElem.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            if (namedNodeMap == null) continue;
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Object object = (Attr)namedNodeMap.item(j);
                if (!object.getName().equals("targetNamespace")) continue;
                string = object.getValue();
                element = (Element)nodeList.item(i);
                break;
            }
            if (string != null && !"".equals(string.trim())) {
                for (Object object : this.schemaTypes.keySet()) {
                    if (string.equals(object)) continue;
                    Element element2 = this.docHolder.createElement("import");
                    element2.setAttribute("namespace", (String)object);
                    element.insertBefore(element2, element.getFirstChild());
                }
            }
            element = null;
            string = null;
        }
        Node node = document.importNode(this.wsdlTypesElem, true);
        document.getDocumentElement().insertBefore(node, document.getDocumentElement().getFirstChild());
    }

    public List getStopClasses() {
        return this.stopClasses;
    }

    public Element createElement(String string) {
        return this.docHolder.createElement(string);
    }

    protected boolean isBeanCompatible(Class clazz, boolean bl) {
        Class clazz2;
        if (clazz.isArray() || clazz.isPrimitive()) {
            if (bl && !this.beanCompatErrs.contains(clazz)) {
                log.warn(Messages.getMessage("beanCompatType00", clazz.getName()));
                this.beanCompatErrs.add(clazz);
            }
            return false;
        }
        if (clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.")) {
            if (bl && !this.beanCompatErrs.contains(clazz)) {
                log.warn(Messages.getMessage("beanCompatPkg00", clazz.getName()));
                this.beanCompatErrs.add(clazz);
            }
            return false;
        }
        if (JavaUtils.isEnumClass(clazz)) {
            return true;
        }
        if (!Throwable.class.isAssignableFrom(clazz)) {
            try {
                clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (bl && !this.beanCompatErrs.contains(clazz)) {
                    log.warn(Messages.getMessage("beanCompatConstructor00", clazz.getName()));
                    this.beanCompatErrs.add(clazz);
                }
                return false;
            }
        }
        if (!((clazz2 = clazz.getSuperclass()) == null || clazz2 == Object.class || clazz2 == Exception.class || clazz2 == Throwable.class || clazz2 == RemoteException.class || clazz2 == AxisFault.class || this.stopClasses != null && this.stopClasses.contains(clazz2.getName()) || this.isBeanCompatible(clazz2, false))) {
            if (bl && !this.beanCompatErrs.contains(clazz)) {
                log.warn(Messages.getMessage("beanCompatExtends00", clazz.getName(), clazz2.getName(), clazz.getName()));
                this.beanCompatErrs.add(clazz);
            }
            return false;
        }
        return true;
    }

    public Element createElementWithAnonymousType(String string, Class clazz, boolean bl, Document document) throws AxisFault {
        Element element = this.docHolder.createElement("element");
        element.setAttribute("name", string);
        if (Types.isNullable(clazz)) {
            element.setAttribute("nillable", "true");
        }
        if (bl) {
            element.setAttribute("minOccurs", "0");
            element.setAttribute("maxOccurs", "1");
        }
        this.makeTypeElement(clazz, null, element);
        return element;
    }

    private boolean makeTypeElement(Class clazz, QName qName, Element element) throws AxisFault {
        Element element2;
        Serializer serializer;
        boolean bl;
        if (qName == null || Constants.equals(Constants.SOAP_ARRAY, qName)) {
            qName = this.getTypeQName(clazz);
        }
        if ((bl = this.isAnonymousType(qName)) && element == null) {
            throw new AxisFault(Messages.getMessage("noContainerForAnonymousType", qName.toString()));
        }
        if (!this.addToTypesList(qName) && !bl) {
            if (element != null) {
                element.setAttribute("type", this.getQNameString(qName));
            }
            return true;
        }
        SerializerFactory serializerFactory = (SerializerFactory)this.tm.getSerializer(clazz, qName);
        if (serializerFactory == null) {
            if (Types.isEnumClass(clazz)) {
                serializerFactory = new EnumSerializerFactory(clazz, qName);
            } else if (this.isBeanCompatible(clazz, true)) {
                serializerFactory = new BeanSerializerFactory(clazz, qName);
            } else {
                return false;
            }
        }
        if ((serializer = (Serializer)serializerFactory.getSerializerAs("Axis SAX Mechanism")) == null) {
            throw new AxisFault(Messages.getMessage("NoSerializer00", clazz.getName()));
        }
        try {
            element2 = serializer.writeSchema(clazz, this);
        }
        catch (Exception exception) {
            throw AxisFault.makeFault(exception);
        }
        if (bl) {
            if (element2 == null) {
                element.setAttribute("type", this.getQNameString(this.getTypeQName(clazz)));
            } else {
                element.appendChild(element2);
            }
        } else {
            if (element2 != null) {
                element2.setAttribute("name", qName.getLocalPart());
                this.writeSchemaTypeDecl(qName, element2);
            }
            if (element != null) {
                element.setAttribute("type", this.getQNameString(qName));
            }
        }
        if (this.emitter != null) {
            this.emitter.getQName2ClassMap().put(qName, clazz);
        }
        return true;
    }

    public ServiceDesc getServiceDesc() {
        return this.serviceDesc;
    }
}

