/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.gen;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.gen.Generator;
import org.apache.axis.wsdl.gen.GeneratorFactory;
import org.apache.axis.wsdl.gen.NoopFactory;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionElement;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Parser {
    protected boolean debug = false;
    protected boolean quiet = false;
    protected boolean imports = true;
    protected boolean verbose = false;
    protected boolean nowrap = false;
    protected String username = null;
    protected String password = null;
    protected boolean wrapArrays = false;
    private long timeoutms = 45000L;
    private GeneratorFactory genFactory = null;
    private SymbolTable symbolTable = null;

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
    }

    public boolean isImports() {
        return this.imports;
    }

    public void setImports(boolean bl) {
        this.imports = bl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isNowrap() {
        return this.nowrap;
    }

    public void setNowrap(boolean bl) {
        this.nowrap = bl;
    }

    public long getTimeout() {
        return this.timeoutms;
    }

    public void setTimeout(long l) {
        this.timeoutms = l;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public GeneratorFactory getFactory() {
        return this.genFactory;
    }

    public void setFactory(GeneratorFactory generatorFactory) {
        this.genFactory = generatorFactory;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public Definition getCurrentDefinition() {
        return this.symbolTable == null ? null : this.symbolTable.getDefinition();
    }

    public String getWSDLURI() {
        return this.symbolTable == null ? null : this.symbolTable.getWSDLURI();
    }

    public void run(String string) throws Exception {
        if (this.getFactory() == null) {
            this.setFactory(new NoopFactory());
        }
        this.symbolTable = new SymbolTable(this.genFactory.getBaseTypeMapping(), this.imports, this.verbose, this.nowrap);
        this.symbolTable.setQuiet(this.quiet);
        this.symbolTable.setWrapArrays(this.wrapArrays);
        WSDLRunnable wSDLRunnable = new WSDLRunnable(this.symbolTable, string);
        Thread thread = new Thread(wSDLRunnable);
        thread.start();
        try {
            if (this.timeoutms > 0L) {
                thread.join(this.timeoutms);
            } else {
                thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (thread.isAlive()) {
            thread.interrupt();
            throw new IOException(Messages.getMessage("timedOut"));
        }
        if (wSDLRunnable.getFailure() != null) {
            throw wSDLRunnable.getFailure();
        }
    }

    public void run(String string, Document document) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        if (this.getFactory() == null) {
            this.setFactory(new NoopFactory());
        }
        this.symbolTable = new SymbolTable(this.genFactory.getBaseTypeMapping(), this.imports, this.verbose, this.nowrap);
        this.symbolTable.populate(string, document);
        this.generate(this.symbolTable);
    }

    protected void sanityCheck(SymbolTable symbolTable) {
    }

    private void generate(SymbolTable symbolTable) throws IOException {
        Object object2;
        this.sanityCheck(symbolTable);
        Definition definition = symbolTable.getDefinition();
        this.genFactory.generatorPass(definition, symbolTable);
        if (this.isDebug()) {
            symbolTable.dump(System.out);
        }
        this.generateTypes(symbolTable);
        for (Object object2 : symbolTable.getHashMap().values()) {
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                SymTabEntry symTabEntry;
                SymTabEntry symTabEntry2 = (SymTabEntry)((Vector)object2).elementAt(i);
                Generator generator = null;
                if (symTabEntry2 instanceof MessageEntry) {
                    generator = this.genFactory.getGenerator(((MessageEntry)symTabEntry2).getMessage(), symbolTable);
                } else if (symTabEntry2 instanceof PortTypeEntry) {
                    symTabEntry = (PortTypeEntry)symTabEntry2;
                    if (((PortTypeEntry)symTabEntry).getPortType().isUndefined()) continue;
                    generator = this.genFactory.getGenerator(((PortTypeEntry)symTabEntry).getPortType(), symbolTable);
                } else if (symTabEntry2 instanceof BindingEntry) {
                    symTabEntry = (BindingEntry)symTabEntry2;
                    Binding binding = ((BindingEntry)symTabEntry).getBinding();
                    if (binding.isUndefined() || !symTabEntry.isReferenced()) continue;
                    generator = this.genFactory.getGenerator(binding, symbolTable);
                } else if (symTabEntry2 instanceof ServiceEntry) {
                    generator = this.genFactory.getGenerator(((ServiceEntry)symTabEntry2).getService(), symbolTable);
                }
                if (generator == null) continue;
                generator.generate();
            }
        }
        object2 = this.genFactory.getGenerator(definition, symbolTable);
        object2.generate();
    }

    private void generateTypes(SymbolTable symbolTable) throws IOException {
        Object object;
        Object object22;
        Map map = symbolTable.getElementIndex();
        Collection collection = map.values();
        for (Object object22 : collection) {
            boolean bl;
            boolean bl2 = bl = object22 instanceof Type || object22 instanceof CollectionElement;
            if (((TypeEntry)object22).getNode() == null || Utils.isXsNode(((TypeEntry)object22).getNode(), "attributeGroup") || Utils.isXsNode(((TypeEntry)object22).getNode(), "group") || !((SymTabEntry)object22).isReferenced() || !bl || ((TypeEntry)object22).getBaseType() != null) continue;
            object = this.genFactory.getGenerator((TypeEntry)object22, symbolTable);
            object.generate();
        }
        Map map2 = symbolTable.getTypeIndex();
        object22 = map2.values();
        Iterator iterator = object22.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            object = (TypeEntry)iterator.next();
            boolean bl3 = bl = object instanceof Type || object instanceof CollectionElement;
            if (((TypeEntry)object).getNode() == null || Utils.isXsNode(((TypeEntry)object).getNode(), "attributeGroup") || Utils.isXsNode(((TypeEntry)object).getNode(), "group") || !((SymTabEntry)object).isReferenced() || !bl || ((TypeEntry)object).getBaseType() != null) continue;
            Generator generator = this.genFactory.getGenerator((TypeEntry)object, symbolTable);
            generator.generate();
        }
    }

    private class WSDLRunnable
    implements Runnable {
        private SymbolTable symbolTable;
        private String wsdlURI;
        private Exception failure = null;

        public WSDLRunnable(SymbolTable symbolTable, String string) {
            this.symbolTable = symbolTable;
            this.wsdlURI = string;
        }

        public void run() {
            try {
                this.symbolTable.populate(this.wsdlURI, Parser.this.username, Parser.this.password);
                Parser.this.generate(this.symbolTable);
            }
            catch (Exception exception) {
                this.failure = exception;
            }
        }

        public Exception getFailure() {
            return this.failure;
        }
    }
}

