/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.QNameHolder;
import org.apache.axis.Constants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.symbolTable.ContainedAttribute;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaUtils {
    static final QName VALUE_QNAME = Utils.findQName("", "_value");
    private static String[] schemaTypes = new String[]{"string", "normalizedString", "token", "byte", "unsignedByte", "base64Binary", "hexBinary", "integer", "positiveInteger", "negativeInteger", "nonNegativeInteger", "nonPositiveInteger", "int", "unsignedInt", "long", "unsignedLong", "short", "unsignedShort", "decimal", "float", "double", "boolean", "time", "dateTime", "duration", "date", "gMonth", "gYear", "gYearMonth", "gDay", "gMonthDay", "Name", "QName", "NCName", "anyURI", "language", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NOTATION", "NMTOKEN", "NMTOKENS", "anySimpleType"};
    private static final Set schemaTypeSet = new HashSet<String>(Arrays.asList(schemaTypes));

    public static boolean isMixed(Node node) {
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            String string = ((org.w3c.dom.Element)node).getAttribute("mixed");
            if (string != null && string.length() > 0) {
                return "true".equalsIgnoreCase(string) || "1".equals(string);
            }
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!SchemaUtils.isXSDNode(node2, "complexContent")) continue;
                string = ((org.w3c.dom.Element)node2).getAttribute("mixed");
                return "true".equalsIgnoreCase(string) || "1".equals(string);
            }
        }
        return false;
    }

    public static Node getUnionNode(Node node) {
        if (SchemaUtils.isXSDNode(node, "simpleType")) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!SchemaUtils.isXSDNode(node2, "union")) continue;
                return node2;
            }
        }
        return null;
    }

    public static Node getListNode(Node node) {
        if (SchemaUtils.isXSDNode(node, "simpleType")) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!SchemaUtils.isXSDNode(node2, "list")) continue;
                return node2;
            }
        }
        return null;
    }

    public static boolean isSimpleTypeWithUnion(Node node) {
        return SchemaUtils.getUnionNode(node) != null;
    }

    public static boolean isWrappedType(Node node) {
        Node node2;
        int n;
        int n2;
        NodeList nodeList;
        if (node == null) {
            return false;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            nodeList = node.getChildNodes();
            n2 = 0;
            for (n = 0; n < nodeList.getLength(); ++n) {
                node2 = nodeList.item(n);
                if (!SchemaUtils.isXSDNode(node2, "complexType")) continue;
                node = node2;
                n2 = 1;
                break;
            }
            if (n2 == 0) {
                return false;
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            nodeList = node.getChildNodes();
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                Node node3 = nodeList.item(n2);
                if (SchemaUtils.isXSDNode(node3, "complexContent")) {
                    return false;
                }
                if (!SchemaUtils.isXSDNode(node3, "simpleContent")) continue;
                return false;
            }
            nodeList = node.getChildNodes();
            n2 = nodeList.getLength();
            for (n = 0; n < n2; ++n) {
                node2 = nodeList.item(n);
                String string = node2.getLocalName();
                if (string == null || !Constants.isSchemaXSD(node2.getNamespaceURI())) continue;
                if (string.equals("sequence")) {
                    Node node4 = node2;
                    NodeList nodeList2 = node4.getChildNodes();
                    int n3 = nodeList2.getLength();
                    for (int i = 0; i < n3; ++i) {
                        Node node5 = nodeList2.item(i);
                        String string2 = node5.getLocalName();
                        if (string2 == null || !Constants.isSchemaXSD(node5.getNamespaceURI())) continue;
                        if (string2.equals("choice")) {
                            Node node6 = node5;
                            NodeList nodeList3 = node6.getChildNodes();
                            int n4 = nodeList3.getLength();
                            for (int j = 0; j < n4; ++j) {
                                Node node7 = nodeList3.item(j);
                                String string3 = node7.getLocalName();
                                if (string3 == null || !Constants.isSchemaXSD(node7.getNamespaceURI()) || string3.equals("element")) continue;
                                return false;
                            }
                            continue;
                        }
                        if (string2.equals("element")) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public static Vector getContainedElementDeclarations(Node node, SymbolTable symbolTable) {
        Node node2;
        Object object;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            object = node.getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                node2 = object.item(i);
                if (!SchemaUtils.isXSDNode(node2, "complexType")) continue;
                node = node2;
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            Object object2;
            Node node3;
            int n;
            object = node.getChildNodes();
            Node node4 = null;
            node2 = null;
            Node node5 = null;
            for (n = 0; n < object.getLength(); ++n) {
                node3 = object.item(n);
                if (SchemaUtils.isXSDNode(node3, "complexContent")) {
                    node4 = node3;
                    break;
                }
                if (!SchemaUtils.isXSDNode(node3, "simpleContent")) continue;
                node2 = node3;
            }
            if (node4 != null) {
                object = node4.getChildNodes();
                for (n = 0; n < object.getLength() && node5 == null; ++n) {
                    node3 = object.item(n);
                    if (!SchemaUtils.isXSDNode(node3, "extension") && !SchemaUtils.isXSDNode(node3, "restriction")) continue;
                    node5 = node3;
                }
            }
            if (node2 != null) {
                object = node2.getChildNodes();
                n = object.getLength();
                for (int i = 0; i < n && node5 == null; ++i) {
                    Node node6 = object.item(i);
                    object2 = node6.getLocalName();
                    if (object2 == null || !((String)object2).equals("extension") && !((String)object2).equals("restriction") || !Constants.isSchemaXSD(node6.getNamespaceURI())) continue;
                    QName qName = Utils.getTypeQName(object.item(i), new BooleanHolder(), false);
                    Vector<ElementDecl> vector = new Vector<ElementDecl>();
                    ElementDecl elementDecl = new ElementDecl(symbolTable.getTypeEntry(qName, false), VALUE_QNAME);
                    vector.add(elementDecl);
                    return vector;
                }
            }
            if (node5 != null) {
                node = node5;
            }
            object = node.getChildNodes();
            Vector vector = new Vector();
            int n2 = object.getLength();
            for (int i = 0; i < n2; ++i) {
                object2 = object.item(i);
                String string = object2.getLocalName();
                if (string == null || !Constants.isSchemaXSD(object2.getNamespaceURI())) continue;
                if (string.equals("sequence")) {
                    vector.addAll(SchemaUtils.processSequenceNode((Node)object2, symbolTable));
                    continue;
                }
                if (string.equals("all")) {
                    vector.addAll(SchemaUtils.processAllNode((Node)object2, symbolTable));
                    continue;
                }
                if (string.equals("choice")) {
                    vector.addAll(SchemaUtils.processChoiceNode((Node)object2, symbolTable));
                    continue;
                }
                if (!string.equals("group")) continue;
                vector.addAll(SchemaUtils.processGroupNode((Node)object2, symbolTable));
            }
            return vector;
        }
        if (SchemaUtils.isXSDNode(node, "group")) {
            return null;
        }
        object = SchemaUtils.getContainedSimpleTypes(node);
        if (object != null) {
            Vector<ElementDecl> vector = null;
            for (int i = 0; i < ((QName[])object).length; ++i) {
                Type type = symbolTable.getType(object[i]);
                if (type == null) continue;
                if (vector == null) {
                    vector = new Vector<ElementDecl>();
                }
                QName qName = null;
                qName = ((Object)object).length > 1 ? new QName("", ((QName)object[i]).getLocalPart() + "Value") : new QName("", "value");
                vector.add(new ElementDecl(type, qName));
            }
            return vector;
        }
        return null;
    }

    private static Vector processChoiceNode(Node node, SymbolTable symbolTable) {
        Vector<ElementDecl> vector = new Vector<ElementDecl>();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            SymTabEntry symTabEntry;
            Node node2 = nodeList.item(i);
            String string = node2.getLocalName();
            if (string == null || !Constants.isSchemaXSD(node2.getNamespaceURI())) continue;
            if (string.equals("choice")) {
                vector.addAll(SchemaUtils.processChoiceNode(node2, symbolTable));
                continue;
            }
            if (string.equals("sequence")) {
                vector.addAll(SchemaUtils.processSequenceNode(node2, symbolTable));
                continue;
            }
            if (string.equals("group")) {
                vector.addAll(SchemaUtils.processGroupNode(node2, symbolTable));
                continue;
            }
            if (string.equals("element")) {
                symTabEntry = SchemaUtils.processChildElementNode(node2, symbolTable);
                if (symTabEntry == null) continue;
                symTabEntry.setMinOccursIs0(true);
                vector.add((ElementDecl)symTabEntry);
                continue;
            }
            if (!string.equals("any")) continue;
            symTabEntry = symbolTable.getType(Constants.XSD_ANY);
            ElementDecl elementDecl = new ElementDecl((TypeEntry)symTabEntry, Utils.findQName("", "any"));
            elementDecl.setAnyElement(true);
            vector.add(elementDecl);
        }
        return vector;
    }

    private static Node getChildByName(Node node, String string) throws DOMException {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2 == null || node2.getNodeName() == null || !string.equals(node2.getNodeName())) continue;
                return node2;
            }
        }
        return null;
    }

    public static String getTextByPath(Node node, String string) throws DOMException {
        Object object;
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        Object object2 = node;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            object = SchemaUtils.getChildByName((Node)object2, string2);
            if (object == null) {
                throw new DOMException(8, "could not find " + string2);
            }
            object2 = object;
        }
        string2 = "";
        object = object2.getChildNodes();
        if (object != null) {
            for (int i = 0; i < object.getLength(); ++i) {
                Node node2 = object.item(i);
                if (node2 == null || node2.getNodeName() == null || !node2.getNodeName().equals("#text") && !node2.getNodeName().equals("#cdata-section")) continue;
                string2 = string2 + node2.getNodeValue();
            }
        }
        return string2;
    }

    public static String getAnnotationDocumentation(Node node) {
        NodeList nodeList;
        Node node2;
        Node node3;
        for (node3 = node.getFirstChild(); node3 != null && !SchemaUtils.isXSDNode(node3, "annotation"); node3 = node3.getNextSibling()) {
        }
        if (node3 != null) {
            for (node2 = node3.getFirstChild(); node2 != null && !SchemaUtils.isXSDNode(node2, "documentation"); node2 = node2.getNextSibling()) {
            }
        } else {
            node2 = null;
        }
        String string = "";
        if (node2 != null && (nodeList = node2.getChildNodes()) != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node4 = nodeList.item(i);
                if (node4 == null || node4.getNodeName() == null || !node4.getNodeName().equals("#text") && !node4.getNodeName().equals("#cdata-section")) continue;
                string = string + node4.getNodeValue();
            }
        }
        return string;
    }

    private static Vector processSequenceNode(Node node, SymbolTable symbolTable) {
        Vector<SymTabEntry> vector = new Vector<SymTabEntry>();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            SymTabEntry symTabEntry;
            Node node2 = nodeList.item(i);
            String string = node2.getLocalName();
            if (string == null || !Constants.isSchemaXSD(node2.getNamespaceURI())) continue;
            if (string.equals("choice")) {
                vector.addAll(SchemaUtils.processChoiceNode(node2, symbolTable));
                continue;
            }
            if (string.equals("sequence")) {
                vector.addAll(SchemaUtils.processSequenceNode(node2, symbolTable));
                continue;
            }
            if (string.equals("group")) {
                vector.addAll(SchemaUtils.processGroupNode(node2, symbolTable));
                continue;
            }
            if (string.equals("any")) {
                symTabEntry = symbolTable.getType(Constants.XSD_ANY);
                ElementDecl elementDecl = new ElementDecl((TypeEntry)symTabEntry, Utils.findQName("", "any"));
                elementDecl.setAnyElement(true);
                vector.add(elementDecl);
                continue;
            }
            if (!string.equals("element") || (symTabEntry = SchemaUtils.processChildElementNode(node2, symbolTable)) == null) continue;
            vector.add(symTabEntry);
        }
        return vector;
    }

    private static Vector processGroupNode(Node node, SymbolTable symbolTable) {
        Vector vector;
        block7: {
            block6: {
                vector = new Vector();
                if (node.getAttributes().getNamedItem("ref") != null) break block6;
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node2 = nodeList.item(i);
                    String string = node2.getLocalName();
                    if (string == null || !Constants.isSchemaXSD(node2.getNamespaceURI())) continue;
                    if (string.equals("choice")) {
                        vector.addAll(SchemaUtils.processChoiceNode(node2, symbolTable));
                        continue;
                    }
                    if (string.equals("sequence")) {
                        vector.addAll(SchemaUtils.processSequenceNode(node2, symbolTable));
                        continue;
                    }
                    if (!string.equals("all")) continue;
                    vector.addAll(SchemaUtils.processAllNode(node2, symbolTable));
                }
                break block7;
            }
            QName qName = Utils.getNodeNameQName(node);
            QName qName2 = Utils.getTypeQName(node, new BooleanHolder(), false);
            Type type = (Type)symbolTable.getTypeEntry(qName2, false);
            if (type == null || type.getNode() == null) break block7;
            Node node3 = type.getNode();
            NodeList nodeList = node3.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                QName qName3 = Utils.getNodeQName(nodeList.item(i));
                if (qName3 == null || !Constants.isSchemaXSD(qName3.getNamespaceURI())) continue;
                if (qName3.getLocalPart().equals("sequence")) {
                    vector.addAll(SchemaUtils.processSequenceNode(nodeList.item(i), symbolTable));
                    continue;
                }
                if (qName3.getLocalPart().equals("all")) {
                    vector.addAll(SchemaUtils.processAllNode(nodeList.item(i), symbolTable));
                    continue;
                }
                if (!qName3.getLocalPart().equals("choice")) continue;
                vector.addAll(SchemaUtils.processChoiceNode(nodeList.item(i), symbolTable));
            }
        }
        return vector;
    }

    private static Vector processAllNode(Node node, SymbolTable symbolTable) {
        Vector<ElementDecl> vector = new Vector<ElementDecl>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ElementDecl elementDecl;
            Node node2 = nodeList.item(i);
            if (!SchemaUtils.isXSDNode(node2, "element") || (elementDecl = SchemaUtils.processChildElementNode(node2, symbolTable)) == null) continue;
            vector.add(elementDecl);
        }
        return vector;
    }

    private static ElementDecl processChildElementNode(Node node, SymbolTable symbolTable) {
        String string;
        Object object;
        QName qName = Utils.getNodeNameQName(node);
        BooleanHolder booleanHolder = new BooleanHolder();
        String string2 = null;
        string2 = SchemaUtils.getAnnotationDocumentation(node);
        QName qName2 = Utils.getTypeQName(node, booleanHolder, false);
        TypeEntry typeEntry = symbolTable.getTypeEntry(qName2, booleanHolder.value);
        if (!booleanHolder.value) {
            object = Utils.getAttribute(node, "form");
            if (object != null && ((String)object).equals("unqualified")) {
                qName = Utils.findQName("", qName.getLocalPart());
            } else if (object == null && ((string = Utils.getScopedAttribute(node, "elementFormDefault")) == null || string.equals("unqualified"))) {
                qName = Utils.findQName("", qName.getLocalPart());
            }
        }
        if (typeEntry != null) {
            String string3;
            object = new ElementDecl(typeEntry, qName);
            ((ElementDecl)object).setDocumentation(string2);
            string = Utils.getAttribute(node, "minOccurs");
            if (string != null && string.equals("0")) {
                ((ElementDecl)object).setMinOccursIs0(true);
            }
            if ((string3 = Utils.getAttribute(node, "maxOccurs")) != null) {
                if (string3.equals("unbounded")) {
                    ((ElementDecl)object).setMaxOccursIsUnbounded(true);
                } else if (string3.equals("1")) {
                    ((ElementDecl)object).setMaxOccursIsExactlyOne(true);
                }
            } else {
                ((ElementDecl)object).setMaxOccursIsExactlyOne(true);
            }
            ((ElementDecl)object).setNillable(JavaUtils.isTrueExplicitly(Utils.getAttribute(node, "nillable")));
            String string4 = Utils.getAttribute(node, "use");
            if (string4 != null) {
                ((ElementDecl)object).setOptional(string4.equalsIgnoreCase("optional"));
            }
            return object;
        }
        return null;
    }

    public static QName getElementAnonQName(Node node) {
        if (SchemaUtils.isXSDNode(node, "element")) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!SchemaUtils.isXSDNode(node2, "complexType") && !SchemaUtils.isXSDNode(node2, "simpleType")) continue;
                return Utils.getNodeNameQName(node2);
            }
        }
        return null;
    }

    public static QName getAttributeAnonQName(Node node) {
        if (SchemaUtils.isXSDNode(node, "attribute")) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!SchemaUtils.isXSDNode(node2, "complexType") && !SchemaUtils.isXSDNode(node2, "simpleType")) continue;
                return Utils.getNodeNameQName(node2);
            }
        }
        return null;
    }

    public static boolean isSimpleTypeOrSimpleContent(Node node) {
        Node node2;
        NodeList nodeList;
        if (node == null) {
            return false;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node2 = nodeList.item(i);
                if (SchemaUtils.isXSDNode(node2, "complexType")) {
                    node = node2;
                    break;
                }
                if (!SchemaUtils.isXSDNode(node2, "simpleType")) continue;
                return true;
            }
        }
        if (SchemaUtils.isXSDNode(node, "simpleType")) {
            return true;
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            nodeList = node.getChildNodes();
            Node node3 = null;
            node2 = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node4 = nodeList.item(i);
                if (SchemaUtils.isXSDNode(node4, "complexContent")) {
                    node3 = node4;
                    break;
                }
                if (!SchemaUtils.isXSDNode(node4, "simpleContent")) continue;
                node2 = node4;
            }
            if (node3 != null) {
                return false;
            }
            if (node2 != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean isXSDNode(Node node, String string) {
        if (node == null) {
            return false;
        }
        String string2 = node.getLocalName();
        if (string2 == null) {
            return false;
        }
        return string2.equals(string) && Constants.isSchemaXSD(node.getNamespaceURI());
    }

    public static TypeEntry getComplexElementRestrictionBase(Node node, SymbolTable symbolTable) {
        Node node2;
        NodeList nodeList;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (int i = 0; i < nodeList.getLength() && node2 == null; ++i) {
                if (!SchemaUtils.isXSDNode(nodeList.item(i), "complexType")) continue;
                node = node2 = nodeList.item(i);
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            Node node3;
            int n;
            nodeList = node.getChildNodes();
            node2 = null;
            Node node4 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                node3 = nodeList.item(n);
                if (!SchemaUtils.isXSDNode(node3, "complexContent")) continue;
                node2 = node3;
            }
            if (node2 != null) {
                nodeList = node2.getChildNodes();
                for (n = 0; n < nodeList.getLength() && node4 == null; ++n) {
                    node3 = nodeList.item(n);
                    if (!SchemaUtils.isXSDNode(node3, "restriction")) continue;
                    node4 = node3;
                }
            }
            if (node4 == null) {
                return null;
            }
            QName qName = Utils.getTypeQName(node4, new BooleanHolder(), false);
            if (qName == null) {
                return null;
            }
            return symbolTable.getType(qName);
        }
        return null;
    }

    public static TypeEntry getComplexElementExtensionBase(Node node, SymbolTable symbolTable) {
        Node node2;
        NodeList nodeList;
        if (node == null) {
            return null;
        }
        Object object = (TypeEntry)symbolTable.node2ExtensionBase.get(node);
        if (object != null) {
            return object;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (int i = 0; i < nodeList.getLength() && node2 == null; ++i) {
                if (!SchemaUtils.isXSDNode(nodeList.item(i), "complexType")) continue;
                node = node2 = nodeList.item(i);
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            QName qName;
            Node node3;
            int n;
            nodeList = node.getChildNodes();
            node2 = null;
            Node node4 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                node3 = nodeList.item(n);
                if (!SchemaUtils.isXSDNode(node3, "complexContent") && !SchemaUtils.isXSDNode(node3, "simpleContent")) continue;
                node2 = node3;
            }
            if (node2 != null) {
                nodeList = node2.getChildNodes();
                for (n = 0; n < nodeList.getLength() && node4 == null; ++n) {
                    node3 = nodeList.item(n);
                    if (!SchemaUtils.isXSDNode(node3, "extension")) continue;
                    node4 = node3;
                }
            }
            object = node4 == null ? null : ((qName = Utils.getTypeQName(node4, new BooleanHolder(), false)) == null ? null : symbolTable.getType(qName));
        }
        symbolTable.node2ExtensionBase.put(node, object);
        return object;
    }

    public static QName getSimpleTypeBase(Node node) {
        QName[] qNameArray = SchemaUtils.getContainedSimpleTypes(node);
        if (qNameArray != null && qNameArray.length > 0) {
            return qNameArray[0];
        }
        return null;
    }

    public static QName[] getContainedSimpleTypes(Node node) {
        NodeList nodeList;
        QName[] qNameArray = null;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!SchemaUtils.isXSDNode(nodeList.item(i), "simpleType")) continue;
                node = nodeList.item(i);
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "simpleType")) {
            nodeList = node.getChildNodes();
            Node node2 = null;
            Node node3 = null;
            for (int i = 0; i < nodeList.getLength() && node2 == null; ++i) {
                if (SchemaUtils.isXSDNode(nodeList.item(i), "restriction")) {
                    node2 = nodeList.item(i);
                    continue;
                }
                if (!SchemaUtils.isXSDNode(nodeList.item(i), "union")) continue;
                node3 = nodeList.item(i);
            }
            if (node2 != null) {
                qNameArray = new QName[]{Utils.getTypeQName(node2, new BooleanHolder(), false)};
            }
            if (node3 != null) {
                qNameArray = Utils.getMemberTypeQNames(node3);
            }
            if (qNameArray != null && node2 != null && node3 != null) {
                NodeList nodeList2 = node2.getChildNodes();
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    if (!SchemaUtils.isXSDNode(nodeList2.item(i), "enumeration")) continue;
                    return null;
                }
            }
        }
        return qNameArray;
    }

    public static Node getRestrictionOrExtensionNode(Node node) {
        NodeList nodeList;
        Node node2 = null;
        if (node == null) {
            return node2;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node3 = nodeList.item(i);
                if (!SchemaUtils.isXSDNode(node3, "simpleType") && !SchemaUtils.isXSDNode(node3, "complexType") && !SchemaUtils.isXSDNode(node3, "simpleContent")) continue;
                node = node3;
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "simpleType") || SchemaUtils.isXSDNode(node, "complexType")) {
            Node node4;
            nodeList = node.getChildNodes();
            Node node5 = null;
            if (node.getLocalName().equals("complexType")) {
                for (int i = 0; i < nodeList.getLength() && node5 == null; ++i) {
                    node4 = nodeList.item(i);
                    if (!SchemaUtils.isXSDNode(node4, "complexContent") && !SchemaUtils.isXSDNode(node4, "simpleContent")) continue;
                    node5 = node4;
                }
                node = node5;
            }
            if (node != null) {
                nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength() && node2 == null; ++i) {
                    node4 = nodeList.item(i);
                    if (!SchemaUtils.isXSDNode(node4, "extension") && !SchemaUtils.isXSDNode(node4, "restriction")) continue;
                    node2 = node4;
                }
            }
        }
        return node2;
    }

    public static QName getArrayComponentQName(Node node, IntHolder intHolder, BooleanHolder booleanHolder, QNameHolder qNameHolder, SymbolTable symbolTable) {
        intHolder.value = 1;
        booleanHolder.value = false;
        QName qName = SchemaUtils.getCollectionComponentQName(node, qNameHolder);
        if (qName == null) {
            qName = SchemaUtils.getArrayComponentQName_JAXRPC(node, intHolder, booleanHolder, symbolTable);
        }
        return qName;
    }

    public static QName getCollectionComponentQName(Node object, QNameHolder qNameHolder) {
        Object object2;
        Object object3;
        Object object4;
        boolean bl = false;
        if (object == null) {
            return null;
        }
        if (qNameHolder != null && SchemaUtils.isXSDNode((Node)object, "complexType")) {
            object4 = SchemaUtils.getChildByName((Node)object, "sequence");
            if (object4 == null) {
                return null;
            }
            object3 = object4.getChildNodes();
            object2 = null;
            for (int i = 0; i < object3.getLength(); ++i) {
                if (object3.item(i).getNodeType() != 1) continue;
                if (object2 == null) {
                    object2 = object3.item(i);
                    continue;
                }
                return null;
            }
            if (object2 == null) {
                return null;
            }
            object = object2;
            bl = true;
        }
        if (SchemaUtils.isXSDNode((Node)object, "element") && (object3 = Utils.getTypeQName((Node)object, (BooleanHolder)(object4 = new BooleanHolder()), true)) != null && !((QName)object3).equals(object2 = Utils.getTypeQName((Node)object, (BooleanHolder)object4, false))) {
            String string;
            if (bl && (string = Utils.getAttribute((Node)object, "name")) != null) {
                String string2 = Utils.getScopedAttribute((Node)object, "elementFormDefault");
                String string3 = "";
                if (string2 != null && string2.equals("qualified")) {
                    string3 = Utils.getScopedAttribute((Node)object, "targetNamespace");
                }
                qNameHolder.value = new QName(string3, string);
            }
            return object3;
        }
        return null;
    }

    private static QName getArrayComponentQName_JAXRPC(Node node, IntHolder intHolder, BooleanHolder booleanHolder, SymbolTable symbolTable) {
        NodeList nodeList;
        intHolder.value = 0;
        booleanHolder.value = false;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (!SchemaUtils.isXSDNode(node2, "complexType")) continue;
                node = node2;
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            nodeList = node.getChildNodes();
            Node node3 = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object4 = nodeList.item(i);
                if (!SchemaUtils.isXSDNode((Node)object4, "complexContent") && !SchemaUtils.isXSDNode((Node)object4, "simpleContent")) continue;
                node3 = object4;
                break;
            }
            Node node4 = null;
            if (node3 != null) {
                nodeList = node3.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    object3 = nodeList.item(i);
                    if (!SchemaUtils.isXSDNode((Node)object3, "restriction")) continue;
                    node4 = object3;
                    break;
                }
            }
            object4 = null;
            if (!(node4 == null || (object4 = Utils.getTypeQName(node4, new BooleanHolder(), false)) == null || ((QName)object4).getLocalPart().equals("Array") && Constants.isSOAP_ENC(((QName)object4).getNamespaceURI()) || symbolTable.arrayTypeQNames.contains(object4))) {
                object4 = null;
            }
            object3 = null;
            Object object5 = null;
            if (object4 != null) {
                nodeList = node4.getChildNodes();
                for (int i = 0; i < nodeList.getLength() && object3 == null && object5 == null; ++i) {
                    BooleanHolder booleanHolder2;
                    object2 = nodeList.item(i);
                    if ((SchemaUtils.isXSDNode((Node)object2, "sequence") || SchemaUtils.isXSDNode((Node)object2, "all")) && (object3 = object2).getChildNodes().getLength() == 0) {
                        object3 = null;
                    }
                    if (!SchemaUtils.isXSDNode((Node)object2, "attribute") || (object = Utils.getTypeQName((Node)object2, booleanHolder2 = new BooleanHolder(), false)) == null || !booleanHolder2.value || !((QName)object).getLocalPart().equals("arrayType") || !Constants.isSOAP_ENC(((QName)object).getNamespaceURI())) continue;
                    object5 = object2;
                }
            }
            if (object5 != null) {
                String string;
                int n;
                String string2 = null;
                object2 = Utils.getAttributesWithLocalName(object5, "arrayType");
                for (n = 0; n < ((Vector)object2).size() && string2 == null; ++n) {
                    object = (Node)((Vector)object2).elementAt(n);
                    string = object.getNodeName();
                    QName qName = Utils.getQNameFromPrefixedName(object5, string);
                    if (!Constants.isWSDL(qName.getNamespaceURI())) continue;
                    string2 = object.getNodeValue();
                }
                if (string2 != null && (n = string2.indexOf(91)) > 0) {
                    object = string2.substring(0, n);
                    string = string2.replace(',', '[');
                    intHolder.value = 0;
                    int n2 = string.indexOf(91);
                    while (n2 > 0) {
                        ++intHolder.value;
                        n2 = string.indexOf(91, n2 + 1);
                    }
                    return Utils.getQNameFromPrefixedName(node4, (String)object);
                }
            } else if (object3 != null) {
                NodeList nodeList2 = object3.getChildNodes();
                object2 = null;
                for (int i = 0; i < nodeList2.getLength() && object2 == null; ++i) {
                    object = nodeList2.item(i);
                    if (!SchemaUtils.isXSDNode((Node)object, "element")) continue;
                    object2 = nodeList2.item(i);
                    break;
                }
                if (object2 != null) {
                    String string = Utils.getAttribute((Node)object2, "nillable");
                    if (string != null && string.equals("true")) {
                        booleanHolder.value = true;
                    }
                    if ((object = Utils.getAttribute((Node)object2, "maxOccurs")) != null && ((String)object).equalsIgnoreCase("unbounded")) {
                        intHolder.value = 1;
                        return Utils.getTypeQName((Node)object2, new BooleanHolder(), true);
                    }
                }
            }
        }
        return null;
    }

    private static void addAttributeToVector(Vector vector, Node node, SymbolTable symbolTable) {
        Object object;
        Object object2;
        QName qName = Utils.getNodeNameQName(node);
        BooleanHolder booleanHolder = new BooleanHolder();
        QName qName2 = Utils.getTypeQName(node, booleanHolder, false);
        if (!booleanHolder.value) {
            object2 = Utils.getAttribute(node, "form");
            if (object2 != null && ((String)object2).equals("unqualified")) {
                qName = Utils.findQName("", qName.getLocalPart());
            } else if (object2 == null && ((object = Utils.getScopedAttribute(node, "attributeFormDefault")) == null || ((String)object).equals("unqualified"))) {
                qName = Utils.findQName("", qName.getLocalPart());
            }
        } else {
            qName = qName2;
        }
        object2 = symbolTable.getTypeEntry(qName2, booleanHolder.value);
        if (object2 instanceof Element) {
            object2 = ((Element)object2).getRefType();
        }
        if (object2 != null && qName != null) {
            object = new ContainedAttribute((TypeEntry)object2, qName);
            String string = Utils.getAttribute(node, "use");
            if (string != null) {
                ((ContainedAttribute)object).setOptional(string.equalsIgnoreCase("optional"));
            }
            vector.add(object);
        }
    }

    private static void addAttributeToVector(Vector vector, SymbolTable symbolTable, QName qName, QName qName2) {
        TypeEntry typeEntry = symbolTable.getTypeEntry(qName, false);
        if (typeEntry != null) {
            vector.add(new ContainedAttribute(typeEntry, qName2));
        }
    }

    private static void addAttributeGroupToVector(Vector vector, Node node, SymbolTable symbolTable) {
        QName qName = Utils.getTypeQName(node, new BooleanHolder(), false);
        TypeEntry typeEntry = symbolTable.getTypeEntry(qName, false);
        if (typeEntry != null) {
            if (typeEntry.getNode() != null) {
                NodeList nodeList = typeEntry.getNode().getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node2 = nodeList.item(i);
                    if (SchemaUtils.isXSDNode(node2, "attribute")) {
                        SchemaUtils.addAttributeToVector(vector, node2, symbolTable);
                        continue;
                    }
                    if (!SchemaUtils.isXSDNode(node2, "attributeGroup")) continue;
                    SchemaUtils.addAttributeGroupToVector(vector, node2, symbolTable);
                }
            } else if (typeEntry.isBaseType()) {
                if (typeEntry.getQName().equals(Constants.SOAP_COMMON_ATTRS11)) {
                    SchemaUtils.addAttributeToVector(vector, symbolTable, Constants.XSD_ID, new QName("http://schemas.xmlsoap.org/soap/encoding/", "id"));
                    SchemaUtils.addAttributeToVector(vector, symbolTable, Constants.XSD_ANYURI, new QName("http://schemas.xmlsoap.org/soap/encoding/", "href"));
                } else if (typeEntry.getQName().equals(Constants.SOAP_COMMON_ATTRS12)) {
                    SchemaUtils.addAttributeToVector(vector, symbolTable, Constants.XSD_ID, new QName("http://www.w3.org/2003/05/soap-encoding", "id"));
                } else if (typeEntry.getQName().equals(Constants.SOAP_ARRAY_ATTRS11)) {
                    SchemaUtils.addAttributeToVector(vector, symbolTable, Constants.XSD_STRING, new QName("http://www.w3.org/2003/05/soap-encoding", "arrayType"));
                    SchemaUtils.addAttributeToVector(vector, symbolTable, Constants.XSD_STRING, new QName("http://www.w3.org/2003/05/soap-encoding", "offset"));
                } else if (typeEntry.getQName().equals(Constants.SOAP_ARRAY_ATTRS12)) {
                    SchemaUtils.addAttributeToVector(vector, symbolTable, Constants.XSD_STRING, new QName("http://www.w3.org/2003/05/soap-encoding", "arraySize"));
                    SchemaUtils.addAttributeToVector(vector, symbolTable, Constants.XSD_QNAME, new QName("http://www.w3.org/2003/05/soap-encoding", "itemType"));
                }
            }
        }
    }

    public static Vector getContainedAttributeTypes(Node node, SymbolTable symbolTable) {
        int n;
        NodeList nodeList;
        Vector vector = null;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            nodeList = node.getChildNodes();
            int n2 = nodeList.getLength();
            for (n = 0; n < n2; ++n) {
                Node node2 = nodeList.item(n);
                if (!SchemaUtils.isXSDNode(node2, "complexType")) continue;
                node = node2;
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "complexType")) {
            Node node3;
            int n3;
            nodeList = node.getChildNodes();
            Node node4 = null;
            n = nodeList.getLength();
            for (n3 = 0; n3 < n; ++n3) {
                node3 = nodeList.item(n3);
                if (!SchemaUtils.isXSDNode(node3, "complexContent") && !SchemaUtils.isXSDNode(node3, "simpleContent")) continue;
                node4 = node3;
                break;
            }
            if (node4 != null) {
                nodeList = node4.getChildNodes();
                n = nodeList.getLength();
                for (n3 = 0; n3 < n; ++n3) {
                    node3 = nodeList.item(n3);
                    if (!SchemaUtils.isXSDNode(node3, "extension") && !SchemaUtils.isXSDNode(node3, "restriction")) continue;
                    node = node3;
                    break;
                }
            }
            nodeList = node.getChildNodes();
            n = nodeList.getLength();
            for (n3 = 0; n3 < n; ++n3) {
                node3 = nodeList.item(n3);
                if (SchemaUtils.isXSDNode(node3, "attributeGroup")) {
                    if (vector == null) {
                        vector = new Vector();
                    }
                    SchemaUtils.addAttributeGroupToVector(vector, node3, symbolTable);
                    continue;
                }
                if (SchemaUtils.isXSDNode(node3, "anyAttribute")) {
                    if (vector != null) continue;
                    vector = new Vector();
                    continue;
                }
                if (!SchemaUtils.isXSDNode(node3, "attribute")) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                SchemaUtils.addAttributeToVector(vector, node3, symbolTable);
            }
        }
        return vector;
    }

    private static boolean isSimpleSchemaType(String string) {
        if (string == null) {
            return false;
        }
        return schemaTypeSet.contains(string);
    }

    public static boolean isSimpleSchemaType(QName qName) {
        if (qName == null || !Constants.isSchemaXSD(qName.getNamespaceURI())) {
            return false;
        }
        return SchemaUtils.isSimpleSchemaType(qName.getLocalPart());
    }

    public static TypeEntry getBaseType(TypeEntry typeEntry, SymbolTable symbolTable) {
        QName qName;
        Node node = typeEntry.getNode();
        TypeEntry typeEntry2 = SchemaUtils.getComplexElementExtensionBase(node, symbolTable);
        if (typeEntry2 == null) {
            typeEntry2 = SchemaUtils.getComplexElementRestrictionBase(node, symbolTable);
        }
        if (typeEntry2 == null && (qName = SchemaUtils.getSimpleTypeBase(node)) != null) {
            typeEntry2 = symbolTable.getType(qName);
        }
        return typeEntry2;
    }

    public static boolean isListWithItemType(Node node) {
        return SchemaUtils.getListItemType(node) != null;
    }

    public static QName getListItemType(Node node) {
        int n;
        NodeList nodeList;
        if (node == null) {
            return null;
        }
        if (SchemaUtils.isXSDNode(node, "element")) {
            nodeList = node.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                if (!SchemaUtils.isXSDNode(nodeList.item(n), "simpleType")) continue;
                node = nodeList.item(n);
                break;
            }
        }
        if (SchemaUtils.isXSDNode(node, "simpleType")) {
            nodeList = node.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                if (!SchemaUtils.isXSDNode(nodeList.item(n), "list")) continue;
                Node node2 = nodeList.item(n);
                org.w3c.dom.Element element = (org.w3c.dom.Element)node2;
                String string = element.getAttribute("itemType");
                if (string.equals("")) {
                    Node node3 = null;
                    nodeList = node2.getChildNodes();
                    for (n = 0; n < nodeList.getLength() && node3 == null; ++n) {
                        if (!SchemaUtils.isXSDNode(nodeList.item(n), "simpleType")) continue;
                        node3 = nodeList.item(n);
                    }
                    if (node3 != null) {
                        return SchemaUtils.getSimpleTypeBase(node3);
                    }
                    return null;
                }
                return Utils.getQNameFromPrefixedName(node, string);
            }
        }
        return null;
    }
}

