/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.symbolTable;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Undefined;
import org.apache.axis.wsdl.symbolTable.Utils;
import org.w3c.dom.Node;

public abstract class TypeEntry
extends SymTabEntry
implements Serializable {
    protected Node node;
    protected TypeEntry refType;
    protected String dims = "";
    protected boolean underlTypeNillable = false;
    protected QName componentType = null;
    protected QName itemQName = null;
    protected boolean undefined;
    protected boolean isBaseType;
    protected boolean isSimpleType = false;
    protected boolean onlyLiteralReference = false;
    protected HashSet types = null;
    protected Vector containedElements;
    protected Vector containedAttributes;

    protected TypeEntry(QName qName, TypeEntry typeEntry, Node node, String string) {
        super(qName);
        this.node = node;
        this.undefined = typeEntry.undefined;
        this.refType = typeEntry;
        if (string == null) {
            string = "";
        }
        this.dims = string;
        if (typeEntry.undefined) {
            TypeEntry typeEntry2 = typeEntry;
            while (!(typeEntry2 instanceof Undefined)) {
                typeEntry2 = typeEntry2.refType;
            }
            ((Undefined)((Object)typeEntry2)).register(this);
        } else {
            this.isBaseType = typeEntry.isBaseType && typeEntry.dims.equals("") && string.equals("");
        }
    }

    protected TypeEntry(QName qName, Node node) {
        super(qName);
        this.node = node;
        this.refType = null;
        this.undefined = false;
        this.dims = "";
        this.isBaseType = false;
    }

    protected TypeEntry(QName qName) {
        super(qName);
        this.node = null;
        this.undefined = false;
        this.dims = "";
        this.isBaseType = true;
    }

    public Node getNode() {
        return this.node;
    }

    public String getBaseType() {
        if (this.isBaseType) {
            return this.name;
        }
        return null;
    }

    public boolean isBaseType() {
        return this.isBaseType;
    }

    public void setBaseType(boolean bl) {
        this.isBaseType = bl;
    }

    public boolean isSimpleType() {
        return this.isSimpleType;
    }

    public void setSimpleType(boolean bl) {
        this.isSimpleType = bl;
    }

    public boolean isOnlyLiteralReferenced() {
        return this.onlyLiteralReference;
    }

    public void setOnlyLiteralReference(boolean bl) {
        this.onlyLiteralReference = bl;
    }

    protected TypeEntry getUndefinedTypeRef() {
        if (this instanceof Undefined) {
            return this;
        }
        if (this.undefined && this.refType != null && this.refType.undefined) {
            TypeEntry typeEntry = this.refType;
            while (!(typeEntry instanceof Undefined)) {
                typeEntry = typeEntry.refType;
            }
            return typeEntry;
        }
        return null;
    }

    protected boolean updateUndefined(TypeEntry typeEntry, TypeEntry typeEntry2) throws IOException {
        boolean bl = false;
        if (this.refType == typeEntry) {
            this.refType = typeEntry2;
            bl = true;
            TypeEntry typeEntry3 = this.refType;
            while (typeEntry3 != null && typeEntry3 != this) {
                typeEntry3 = typeEntry3.refType;
            }
            if (typeEntry3 == this) {
                this.undefined = false;
                this.isBaseType = false;
                this.node = null;
                throw new IOException(Messages.getMessage("undefinedloop00", this.getQName().toString()));
            }
        }
        if (this.refType != null && this.undefined && !this.refType.undefined) {
            this.undefined = false;
            bl = true;
            this.isBaseType = this.refType.isBaseType && this.refType.dims.equals("") && this.dims.equals("");
        }
        return bl;
    }

    public TypeEntry getRefType() {
        return this.refType;
    }

    public void setRefType(TypeEntry typeEntry) {
        this.refType = typeEntry;
    }

    public String getDimensions() {
        return this.dims;
    }

    public boolean getUnderlTypeNillable() {
        if (!this.underlTypeNillable && !this.getDimensions().equals("") && this.refType != null) {
            this.underlTypeNillable = this.refType.getUnderlTypeNillable();
        }
        return this.underlTypeNillable;
    }

    public void setUnderlTypeNillable(boolean bl) {
        this.underlTypeNillable = bl;
    }

    public QName getComponentType() {
        return this.componentType;
    }

    public void setComponentType(QName qName) {
        this.componentType = qName;
    }

    public QName getItemQName() {
        return this.itemQName;
    }

    public void setItemQName(QName qName) {
        this.itemQName = qName;
    }

    public String toString() {
        return this.toString("");
    }

    protected String toString(String string) {
        String string2 = string + "RefType:       null \n";
        if (this.refType != null) {
            string2 = string + "RefType:\n" + this.refType.toString(string + "  ") + "\n";
        }
        return super.toString(string) + string + "Class:         " + this.getClass().getName() + "\n" + string + "Base?:         " + this.isBaseType + "\n" + string + "Undefined?:    " + this.undefined + "\n" + string + "isSimpleType?  " + this.isSimpleType + "\n" + string + "Node:          " + this.getNode() + "\n" + string + "Dims:          " + this.dims + "\n" + string + "isOnlyLiteralReferenced: " + this.onlyLiteralReference + "\n" + string2;
    }

    public HashSet getNestedTypes(SymbolTable symbolTable, boolean bl) {
        if (this.types == null) {
            this.types = Utils.getNestedTypes(this, symbolTable, bl);
        }
        return this.types;
    }

    public Vector getContainedAttributes() {
        return this.containedAttributes;
    }

    public void setContainedAttributes(Vector vector) {
        this.containedAttributes = vector;
    }

    public Vector getContainedElements() {
        return this.containedElements;
    }

    public void setContainedElements(Vector vector) {
        this.containedElements = vector;
    }
}

