/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.CollectionTE;
import org.apache.axis.wsdl.symbolTable.ContainedAttribute;
import org.apache.axis.wsdl.symbolTable.ContainedEntry;
import org.apache.axis.wsdl.symbolTable.DefinedType;
import org.apache.axis.wsdl.symbolTable.ElementDecl;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaBeanHelperWriter
extends JavaClassWriter {
    protected TypeEntry type;
    protected Vector elements;
    protected Vector attributes;
    protected TypeEntry extendType;
    protected PrintWriter wrapperPW = null;
    protected Vector elementMetaData = null;
    protected boolean canSearchParents;
    protected Set reservedPropNames;

    protected JavaBeanHelperWriter(Emitter emitter, TypeEntry typeEntry, Vector vector, TypeEntry typeEntry2, Vector vector2, Set set) {
        super(emitter, typeEntry.getName() + "_Helper", "helper");
        this.type = typeEntry;
        this.elements = vector;
        this.attributes = vector2;
        this.extendType = typeEntry2;
        this.reservedPropNames = set;
        this.canSearchParents = null == typeEntry2 || null == SchemaUtils.getComplexElementRestrictionBase(typeEntry.getNode(), emitter.getSymbolTable());
    }

    protected void setPrintWriter(PrintWriter printWriter) {
        this.wrapperPW = printWriter;
    }

    protected PrintWriter getPrintWriter(String string) throws IOException {
        return this.wrapperPW == null ? super.getPrintWriter(string) : this.wrapperPW;
    }

    protected void registerFile(String string) {
        if (this.wrapperPW == null) {
            super.registerFile(string);
        }
    }

    protected String verboseMessage(String string) {
        if (this.wrapperPW == null) {
            return super.verboseMessage(string);
        }
        return null;
    }

    protected void writeFileHeader(PrintWriter printWriter) throws IOException {
        if (this.wrapperPW == null) {
            super.writeFileHeader(printWriter);
        }
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        this.writeMetaData(printWriter);
        this.writeSerializer(printWriter);
        this.writeDeserializer(printWriter);
    }

    protected void writeFileFooter(PrintWriter printWriter) throws IOException {
        if (this.wrapperPW == null) {
            super.writeFileFooter(printWriter);
        }
    }

    protected void closePrintWriter(PrintWriter printWriter) {
        if (this.wrapperPW == null) {
            printWriter.close();
        }
    }

    protected void writeMetaData(PrintWriter printWriter) throws IOException {
        int n;
        if (this.elements != null) {
            for (n = 0; n < this.elements.size(); ++n) {
                ElementDecl elementDecl = (ElementDecl)this.elements.get(n);
                if (this.elementMetaData == null) {
                    this.elementMetaData = new Vector();
                }
                this.elementMetaData.add(elementDecl);
            }
        }
        printWriter.println("    // " + Messages.getMessage("typeMeta"));
        printWriter.println("    private static org.apache.axis.description.TypeDesc typeDesc =");
        printWriter.println("        new org.apache.axis.description.TypeDesc(" + Utils.getJavaLocalName(this.type.getName()) + ".class, " + (this.canSearchParents ? "true" : "false") + ");");
        printWriter.println();
        printWriter.println("    static {");
        printWriter.println("        typeDesc.setXmlType(" + Utils.getNewQName(this.type.getQName()) + ");");
        if (this.attributes != null || this.elementMetaData != null) {
            QName qName;
            Object object;
            QName qName2;
            Object object2;
            ContainedEntry containedEntry;
            if (this.attributes != null) {
                n = 0;
                for (int i = 0; i < this.attributes.size(); ++i) {
                    containedEntry = (ContainedAttribute)this.attributes.get(i);
                    object2 = containedEntry.getType();
                    qName2 = containedEntry.getQName();
                    object = this.getAsFieldName(containedEntry.getName());
                    qName = ((SymTabEntry)object2).getQName();
                    printWriter.print("        ");
                    if (n == 0) {
                        printWriter.print("org.apache.axis.description.AttributeDesc ");
                        n = 1;
                    }
                    printWriter.println("attrField = new org.apache.axis.description.AttributeDesc();");
                    printWriter.println("        attrField.setFieldName(\"" + (String)object + "\");");
                    printWriter.println("        attrField.setXmlName(" + Utils.getNewQNameWithLastLocalPart(qName2) + ");");
                    if (qName != null) {
                        printWriter.println("        attrField.setXmlType(" + Utils.getNewQName(qName) + ");");
                    }
                    printWriter.println("        typeDesc.addFieldDesc(attrField);");
                }
            }
            if (this.elementMetaData != null) {
                n = 0;
                for (int i = 0; i < this.elementMetaData.size(); ++i) {
                    QName qName3;
                    containedEntry = (ElementDecl)this.elementMetaData.elementAt(i);
                    if (((ElementDecl)containedEntry).getAnyElement()) continue;
                    object2 = this.getAsFieldName(containedEntry.getName());
                    qName2 = containedEntry.getQName();
                    object = containedEntry.getType();
                    qName = null;
                    if (((TypeEntry)object).getDimensions().length() > 1 && object.getClass() == DefinedType.class) {
                        object = ((TypeEntry)object).getRefType();
                    } else {
                        while (object instanceof CollectionTE) {
                            object = ((TypeEntry)object).getRefType();
                        }
                    }
                    qName = ((SymTabEntry)object).getQName();
                    printWriter.print("        ");
                    if (n == 0) {
                        printWriter.print("org.apache.axis.description.ElementDesc ");
                        n = 1;
                    }
                    printWriter.println("elemField = new org.apache.axis.description.ElementDesc();");
                    printWriter.println("        elemField.setFieldName(\"" + (String)object2 + "\");");
                    printWriter.println("        elemField.setXmlName(" + Utils.getNewQNameWithLastLocalPart(qName2) + ");");
                    if (qName != null) {
                        printWriter.println("        elemField.setXmlType(" + Utils.getNewQName(qName) + ");");
                    }
                    if (((ElementDecl)containedEntry).getMinOccursIs0()) {
                        printWriter.println("        elemField.setMinOccurs(0);");
                    }
                    if (((ElementDecl)containedEntry).getNillable()) {
                        printWriter.println("        elemField.setNillable(true);");
                    } else {
                        printWriter.println("        elemField.setNillable(false);");
                    }
                    if (((ElementDecl)containedEntry).getMaxOccursIsUnbounded()) {
                        printWriter.println("        elemField.setMaxOccursUnbounded(true);");
                    }
                    if ((qName3 = containedEntry.getType().getItemQName()) != null) {
                        printWriter.println("        elemField.setItemQName(" + Utils.getNewQName(qName3) + ");");
                    }
                    printWriter.println("        typeDesc.addFieldDesc(elemField);");
                }
            }
        }
        printWriter.println("    }");
        printWriter.println();
        printWriter.println("    /**");
        printWriter.println("     * " + Messages.getMessage("returnTypeMeta"));
        printWriter.println("     */");
        printWriter.println("    public static org.apache.axis.description.TypeDesc getTypeDesc() {");
        printWriter.println("        return typeDesc;");
        printWriter.println("    }");
        printWriter.println();
    }

    private String getAsFieldName(String string) {
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1))) {
            string = Utils.capitalizeFirstChar(string);
        }
        return JavaUtils.getUniqueValue(this.reservedPropNames, string);
    }

    protected void writeSerializer(PrintWriter printWriter) throws IOException {
        String string = "typeDesc";
        String string2 = " org.apache.axis.encoding.ser.BeanSerializer";
        if (this.type.isSimpleType()) {
            string2 = " org.apache.axis.encoding.ser.SimpleSerializer";
        }
        printWriter.println("    /**");
        printWriter.println("     * Get Custom Serializer");
        printWriter.println("     */");
        printWriter.println("    public static org.apache.axis.encoding.Serializer getSerializer(");
        printWriter.println("           java.lang.String mechType, ");
        printWriter.println("           java.lang.Class _javaType,  ");
        printWriter.println("           javax.xml.namespace.QName _xmlType) {");
        printWriter.println("        return ");
        printWriter.println("          new " + string2 + "(");
        printWriter.println("            _javaType, _xmlType, " + string + ");");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeDeserializer(PrintWriter printWriter) throws IOException {
        String string = "typeDesc";
        String string2 = " org.apache.axis.encoding.ser.BeanDeserializer";
        if (this.type.isSimpleType()) {
            string2 = " org.apache.axis.encoding.ser.SimpleDeserializer";
        }
        printWriter.println("    /**");
        printWriter.println("     * Get Custom Deserializer");
        printWriter.println("     */");
        printWriter.println("    public static org.apache.axis.encoding.Deserializer getDeserializer(");
        printWriter.println("           java.lang.String mechType, ");
        printWriter.println("           java.lang.Class _javaType,  ");
        printWriter.println("           javax.xml.namespace.QName _xmlType) {");
        printWriter.println("        return ");
        printWriter.println("          new " + string2 + "(");
        printWriter.println("            _javaType, _xmlType, " + string + ");");
        printWriter.println("    }");
        printWriter.println();
    }
}

