/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.axis.Version;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Namespaces;
import org.apache.axis.wsdl.toJava.Utils;

public abstract class JavaClassWriter
extends JavaWriter {
    protected Namespaces namespaces;
    protected String className;
    protected String packageName;

    protected JavaClassWriter(Emitter emitter, String string, String string2) {
        super(emitter, string2);
        this.namespaces = emitter.getNamespaces();
        this.packageName = Utils.getJavaPackageName(string);
        this.className = Utils.getJavaLocalName(string);
    }

    protected String getFileName() {
        return this.namespaces.toDir(this.packageName) + this.className + ".java";
    }

    protected void registerFile(String string) {
        String string2 = this.getPackage();
        String string3 = string2 != null && string2.length() > 0 ? string2 + '.' + this.getClassName() : this.getClassName();
        this.emitter.getGeneratedFileInfo().add(string, string3, this.type);
    }

    protected void writeFileHeader(PrintWriter printWriter) throws IOException {
        this.writeHeaderComments(printWriter);
        this.writePackage(printWriter);
        printWriter.println(this.getClassModifiers() + this.getClassText() + this.getClassName() + ' ' + this.getExtendsText() + this.getImplementsText() + "{");
    }

    protected void writeHeaderComments(PrintWriter printWriter) throws IOException {
        String string = this.getFileName();
        int n = string.lastIndexOf(File.separatorChar);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        printWriter.println("/**");
        printWriter.println(" * " + string);
        printWriter.println(" *");
        printWriter.println(" * " + Messages.getMessage("wsdlGenLine00"));
        printWriter.println(" * " + Messages.getMessage("wsdlGenLine01", Version.getVersionText()));
        printWriter.println(" */");
        printWriter.println();
    }

    protected void writePackage(PrintWriter printWriter) throws IOException {
        String string = this.getPackage();
        if (string != null && string.length() > 0) {
            printWriter.println("package " + string + ";");
            printWriter.println();
        }
    }

    protected String getClassModifiers() {
        return "public ";
    }

    protected String getClassText() {
        return "class ";
    }

    protected String getExtendsText() {
        return "";
    }

    protected String getImplementsText() {
        return "";
    }

    protected String getPackage() {
        return this.packageName;
    }

    protected String getClassName() {
        return this.className;
    }

    protected void writeFileFooter(PrintWriter printWriter) throws IOException {
        super.writeFileFooter(printWriter);
        printWriter.println('}');
    }
}

