/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.io.PrintWriter;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;

public class JavaInterfaceWriter
extends JavaClassWriter {
    protected PortType portType;
    protected BindingEntry bEntry;

    protected JavaInterfaceWriter(Emitter emitter, PortTypeEntry portTypeEntry, BindingEntry bindingEntry, SymbolTable symbolTable) {
        super(emitter, (String)bindingEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME), "interface");
        this.portType = portTypeEntry.getPortType();
        this.bEntry = bindingEntry;
    }

    public void generate() throws IOException {
        String string = this.getPackage() + "." + this.getClassName();
        if (!this.emitter.getGeneratedFileInfo().getClassNames().contains(string)) {
            super.generate();
        }
    }

    protected String getClassText() {
        return "interface ";
    }

    protected String getExtendsText() {
        return "extends java.rmi.Remote ";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        for (Operation operation : this.portType.getOperations()) {
            this.writeOperation(printWriter, operation);
        }
    }

    protected void writeOperation(PrintWriter printWriter, Operation operation) throws IOException {
        this.writeComment(printWriter, operation.getDocumentationElement(), true);
        Parameters parameters = this.bEntry.getParameters(operation);
        printWriter.println(parameters.signature + ";");
    }
}

