/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.IOException;
import java.util.Collections;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.wsdl.gen.Generator;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBeanFaultWriter;
import org.apache.axis.wsdl.toJava.JavaBeanHelperWriter;
import org.apache.axis.wsdl.toJava.JavaBeanWriter;
import org.apache.axis.wsdl.toJava.JavaEnumTypeWriter;
import org.apache.axis.wsdl.toJava.JavaGeneratorFactory;
import org.apache.axis.wsdl.toJava.JavaHolderWriter;
import org.apache.axis.wsdl.toJava.JavaWriter;
import org.apache.axis.wsdl.toJava.Utils;
import org.w3c.dom.Node;

public class JavaTypeWriter
implements Generator {
    public static final String HOLDER_IS_NEEDED = "Holder is needed";
    private Generator typeWriter = null;
    private Generator holderWriter = null;

    public JavaTypeWriter(Emitter emitter, TypeEntry typeEntry, SymbolTable symbolTable) {
        if (typeEntry.isReferenced() && !typeEntry.isOnlyLiteralReferenced()) {
            Node node = typeEntry.getNode();
            boolean bl = SchemaUtils.isListWithItemType(node);
            if (!typeEntry.getName().endsWith("[]") && !bl) {
                Vector vector = Utils.getEnumerationBaseAndValues(node, symbolTable);
                if (vector != null) {
                    this.typeWriter = this.getEnumTypeWriter(emitter, typeEntry, vector);
                } else {
                    QName qName;
                    TypeEntry typeEntry2 = SchemaUtils.getComplexElementExtensionBase(node, symbolTable);
                    if (typeEntry2 == null) {
                        typeEntry2 = SchemaUtils.getComplexElementRestrictionBase(node, symbolTable);
                    }
                    if (typeEntry2 == null && (qName = SchemaUtils.getSimpleTypeBase(node)) != null) {
                        typeEntry2 = symbolTable.getType(qName);
                    }
                    this.typeWriter = this.getBeanWriter(emitter, typeEntry, typeEntry2);
                }
            }
            if (this.holderIsNeeded(typeEntry)) {
                this.holderWriter = this.getHolderWriter(emitter, typeEntry);
            }
            if (this.typeWriter != null && typeEntry instanceof Type) {
                ((Type)typeEntry).setGenerated(true);
            }
        }
    }

    public void generate() throws IOException {
        if (this.typeWriter != null) {
            this.typeWriter.generate();
        }
        if (this.holderWriter != null) {
            this.holderWriter.generate();
        }
    }

    private boolean holderIsNeeded(SymTabEntry symTabEntry) {
        Boolean bl = (Boolean)symTabEntry.getDynamicVar(HOLDER_IS_NEEDED);
        return bl != null && bl != false;
    }

    protected JavaWriter getEnumTypeWriter(Emitter emitter, TypeEntry typeEntry, Vector vector) {
        return new JavaEnumTypeWriter(emitter, typeEntry, vector);
    }

    protected JavaWriter getBeanWriter(Emitter emitter, TypeEntry typeEntry, TypeEntry typeEntry2) {
        Vector vector = typeEntry.getContainedElements();
        Vector vector2 = typeEntry.getContainedAttributes();
        Boolean bl = (Boolean)typeEntry.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
        if (bl != null && bl.booleanValue()) {
            return new JavaBeanFaultWriter(emitter, typeEntry, vector, typeEntry2, vector2, this.getBeanHelperWriter(emitter, typeEntry, vector, typeEntry2, vector2, true));
        }
        return new JavaBeanWriter(emitter, typeEntry, vector, typeEntry2, vector2, this.getBeanHelperWriter(emitter, typeEntry, vector, typeEntry2, vector2, false));
    }

    protected JavaWriter getBeanHelperWriter(Emitter emitter, TypeEntry typeEntry, Vector vector, TypeEntry typeEntry2, Vector vector2, boolean bl) {
        return new JavaBeanHelperWriter(emitter, typeEntry, vector, typeEntry2, vector2, bl ? JavaBeanFaultWriter.RESERVED_PROPERTY_NAMES : Collections.EMPTY_SET);
    }

    protected Generator getHolderWriter(Emitter emitter, TypeEntry typeEntry) {
        return new JavaHolderWriter(emitter, typeEntry);
    }
}

