/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.gen.Generator;
import org.apache.axis.wsdl.toJava.DuplicateFileException;
import org.apache.axis.wsdl.toJava.Emitter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class JavaWriter
implements Generator {
    protected static final int LINE_LENGTH = 65;
    protected Emitter emitter;
    protected String type;

    protected JavaWriter(Emitter emitter, String string) {
        this.emitter = emitter;
        this.type = string;
    }

    public void generate() throws IOException {
        Object object;
        String string = this.getFileName();
        if (this.isFileGenerated(string)) {
            throw new DuplicateFileException(Messages.getMessage("duplicateFile00", string), string);
        }
        this.registerFile(string);
        if (this.emitter.isVerbose() && (object = this.verboseMessage(string)) != null) {
            System.out.println((String)object);
        }
        object = this.getPrintWriter(string);
        this.writeFileHeader((PrintWriter)object);
        this.writeFileBody((PrintWriter)object);
        this.writeFileFooter((PrintWriter)object);
        this.closePrintWriter((PrintWriter)object);
    }

    protected abstract String getFileName();

    protected boolean isFileGenerated(String string) {
        return this.emitter.getGeneratedFileNames().contains(string);
    }

    protected void registerFile(String string) {
        this.emitter.getGeneratedFileInfo().add(string, null, this.type);
    }

    protected String verboseMessage(String string) {
        return Messages.getMessage("generating", string);
    }

    protected PrintWriter getPrintWriter(String string) throws IOException {
        File file = new File(string);
        File file2 = new File(file.getParent());
        file2.mkdirs();
        return new PrintWriter(new FileWriter(file));
    }

    protected void writeFileHeader(PrintWriter printWriter) throws IOException {
    }

    protected abstract void writeFileBody(PrintWriter var1) throws IOException;

    protected void writeFileFooter(PrintWriter printWriter) throws IOException {
    }

    protected void closePrintWriter(PrintWriter printWriter) {
        printWriter.close();
    }

    protected String getJavadocDescriptionPart(String string, boolean bl) {
        StringBuffer stringBuffer;
        int n;
        if (string == null) {
            return "";
        }
        String string2 = string.trim();
        if (string.trim().length() == 0) {
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "@");
        if (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            n = Character.isWhitespace(string3.charAt(string3.length() - 1)) && string3.charAt(string3.length() - 1) != '\n' ? 1 : 0;
            stringBuffer = new StringBuffer(string3);
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (n != 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append('@');
                n = Character.isWhitespace(string3.charAt(string3.length() - 1)) & (string3.charAt(string3.length() - 1) != '\n' ? 1 : 0);
                stringBuffer.append(string3);
            }
        } else {
            stringBuffer = new StringBuffer(string2);
        }
        stringBuffer.insert(0, bl ? "     * " : " * ");
        int n2 = stringBuffer.toString().indexOf("*/");
        while (n2 >= 0) {
            stringBuffer.insert(n2 + 1, ' ');
            n2 = stringBuffer.toString().indexOf("*/");
        }
        n = 0;
        int n3 = 0;
        while (n < stringBuffer.length()) {
            n3 = stringBuffer.toString().indexOf("\n", n);
            if (n3 == -1) {
                n3 = stringBuffer.length();
            }
            if (n3 - n > 65) {
                n += 65;
                while (n < stringBuffer.length() && !Character.isWhitespace(stringBuffer.charAt(n))) {
                    ++n;
                }
                if (n < stringBuffer.length()) {
                    char c = stringBuffer.charAt(n);
                    if (c == '\r' || c == '\n') {
                        stringBuffer.insert(n + 1, bl ? "     * " : " * ");
                        n += bl ? 8 : 4;
                    } else {
                        stringBuffer.insert(n, bl ? "\n     * " : "\n * ");
                        n += bl ? 8 : 4;
                    }
                }
                while (n < stringBuffer.length() && stringBuffer.charAt(n) == ' ') {
                    stringBuffer.delete(n, n + 1);
                }
                continue;
            }
            if (++n3 < stringBuffer.length()) {
                stringBuffer.insert(n3, bl ? "     * " : " * ");
            }
            n = n3;
            n += bl ? 7 : 3;
        }
        return stringBuffer.toString();
    }

    protected void writeComment(PrintWriter printWriter, Element element) {
        this.writeComment(printWriter, element, true);
    }

    protected void writeComment(PrintWriter printWriter, Element element, boolean bl) {
        if (element == null) {
            return;
        }
        Node node = element.getFirstChild();
        if (node == null) {
            return;
        }
        String string = node.getNodeValue();
        if (string != null) {
            boolean bl2 = false;
            printWriter.println();
            printWriter.println(bl ? "    /**" : "/**");
            printWriter.println(this.getJavadocDescriptionPart(string, bl));
            printWriter.println(bl ? "     */" : " */");
        }
    }
}

