/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.axis.Constants;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BaseType;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.CollectionTE;
import org.apache.axis.wsdl.symbolTable.CollectionType;
import org.apache.axis.wsdl.symbolTable.DefinedElement;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.MessageEntry;
import org.apache.axis.wsdl.symbolTable.MimeInfo;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SchemaUtils;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.Type;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaEnumTypeWriter;
import org.apache.axis.wsdl.toJava.JavaGeneratorFactory;
import org.apache.axis.wsdl.toJava.Namespaces;
import org.apache.commons.logging.Log;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Utils
extends org.apache.axis.wsdl.symbolTable.Utils {
    protected static Log log = LogFactory.getLog(Utils.class.getName());
    private static HashMap TYPES = new HashMap(7);
    private static HashMap constructorMap;
    private static HashMap constructorThrowMap;

    public static String holder(TypeEntry typeEntry, Emitter emitter) {
        Parameter parameter = new Parameter();
        parameter.setType(typeEntry);
        return Utils.holder(parameter, emitter);
    }

    public static String holder(Parameter parameter, Emitter emitter) {
        String string;
        String string2;
        String string3 = parameter.getMIMEInfo() == null ? null : parameter.getMIMEInfo().getType();
        String string4 = string2 = string3 == null ? "" : parameter.getMIMEInfo().getDimensions();
        if (string3 != null) {
            if (string3.equals("image/gif") || string3.equals("image/jpeg")) {
                return "org.apache.axis.holders.ImageHolder" + string2;
            }
            if (string3.equals("text/plain")) {
                return "javax.xml.rpc.holders.StringHolder" + string2;
            }
            if (string3.startsWith("multipart/")) {
                return "org.apache.axis.holders.MimeMultipartHolder" + string2;
            }
            if (string3.startsWith("application/octetstream") || string3.startsWith("application/octet-stream")) {
                return "org.apache.axis.holders.OctetStreamHolder" + string2;
            }
            if (string3.equals("text/xml") || string3.equals("application/xml")) {
                return "org.apache.axis.holders.SourceHolder" + string2;
            }
            return "org.apache.axis.holders.DataHandlerHolder" + string2;
        }
        TypeEntry typeEntry = parameter.getType();
        String string5 = typeEntry.getName();
        if (parameter.isOmittable() && (typeEntry instanceof BaseType || typeEntry instanceof DefinedElement && typeEntry.getRefType() instanceof BaseType)) {
            string = (String)TYPES.get(string5);
            String string6 = string5 = string == null ? string5 : string;
        }
        if (string5.equals("byte[]") && typeEntry.isBaseType()) {
            return "javax.xml.rpc.holders.ByteArrayHolder";
        }
        if (string5.endsWith("[]")) {
            string = emitter.getJavaName(typeEntry.getQName());
            String string7 = "";
            if (typeEntry instanceof CollectionType && typeEntry.getRefType() instanceof BaseType) {
                String string8 = typeEntry.getRefType().getQName().getNamespaceURI();
                string7 = emitter.getNamespaces().getCreate(string8, false);
                string7 = string7 == null ? "" : string7 + '.';
            }
            string = JavaUtils.replace(string, "java.lang.", "");
            string = JavaUtils.replace(string, "[]", "Array");
            string = Utils.addPackageName(string, "holders");
            return string7 + string + "Holder";
        }
        if (string5.equals("String")) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if (string5.equals("java.lang.String")) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if (string5.equals("Object")) {
            return "javax.xml.rpc.holders.ObjectHolder";
        }
        if (string5.equals("java.lang.Object")) {
            return "javax.xml.rpc.holders.ObjectHolder";
        }
        if (string5.equals("int") || string5.equals("long") || string5.equals("short") || string5.equals("float") || string5.equals("double") || string5.equals("boolean") || string5.equals("byte")) {
            return "javax.xml.rpc.holders." + Utils.capitalizeFirstChar(string5) + "Holder";
        }
        if (string5.startsWith("java.lang.")) {
            return "javax.xml.rpc.holders" + string5.substring(string5.lastIndexOf(".")) + "WrapperHolder";
        }
        if (string5.indexOf(".") < 0) {
            return "javax.xml.rpc.holders" + string5 + "WrapperHolder";
        }
        if (string5.equals("java.math.BigDecimal")) {
            return "javax.xml.rpc.holders.BigDecimalHolder";
        }
        if (string5.equals("java.math.BigInteger")) {
            return "javax.xml.rpc.holders.BigIntegerHolder";
        }
        if (string5.equals("java.util.Date")) {
            return "org.apache.axis.holders.DateHolder";
        }
        if (string5.equals("java.util.Calendar")) {
            return "javax.xml.rpc.holders.CalendarHolder";
        }
        if (string5.equals("javax.xml.namespace.QName")) {
            return "javax.xml.rpc.holders.QNameHolder";
        }
        if (string5.equals("javax.activation.DataHandler")) {
            return "org.apache.axis.holders.DataHandlerHolder";
        }
        if (string5.startsWith("org.apache.axis.types.")) {
            int n = string5.lastIndexOf(46);
            String string9 = string5.substring(n + 1);
            return "org.apache.axis.holders." + string9 + "Holder";
        }
        return Utils.addPackageName(string5, "holders") + "Holder";
    }

    public static String addPackageName(String string, String string2) {
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return string.substring(0, n) + "." + string2 + string.substring(n);
        }
        return string2 + "." + string;
    }

    public static String getFullExceptionName(Message message, SymbolTable symbolTable) {
        MessageEntry messageEntry = symbolTable.getMessageEntry(message.getQName());
        return (String)messageEntry.getDynamicVar(JavaGeneratorFactory.EXCEPTION_CLASS_NAME);
    }

    public static QName getFaultDataType(Message message, SymbolTable symbolTable) {
        MessageEntry messageEntry = symbolTable.getMessageEntry(message.getQName());
        return (QName)messageEntry.getDynamicVar(JavaGeneratorFactory.EXCEPTION_DATA_TYPE);
    }

    public static boolean isFaultComplex(Message message, SymbolTable symbolTable) {
        MessageEntry messageEntry = symbolTable.getMessageEntry(message.getQName());
        Boolean bl = (Boolean)messageEntry.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static Vector getEnumerationBaseAndValues(Node node, SymbolTable symbolTable) {
        Serializable serializable;
        int n;
        Node node2;
        NodeList nodeList;
        if (node == null) {
            return null;
        }
        QName qName = Utils.getNodeQName(node);
        if (qName != null && qName.getLocalPart().equals("element") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                serializable = Utils.getNodeQName(nodeList.item(n));
                if (serializable == null || !((QName)serializable).getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(((QName)serializable).getNamespaceURI())) continue;
                node = node2 = nodeList.item(n);
            }
        }
        if ((qName = Utils.getNodeQName(node)) != null && qName.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            Object object;
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                serializable = Utils.getNodeQName(nodeList.item(n));
                if (serializable == null || !((QName)serializable).getLocalPart().equals("restriction") || !Constants.isSchemaXSD(((QName)serializable).getNamespaceURI())) continue;
                node2 = nodeList.item(n);
            }
            Type type = null;
            if (node2 != null && (type = symbolTable.getType((QName)(serializable = Utils.getTypeQName(node2, new BooleanHolder(), false)))) != null && (((String)(object = type.getName())).equals("boolean") || !SchemaUtils.isSimpleSchemaType(type.getQName()))) {
                type = null;
            }
            if (type != null && node2 != null) {
                serializable = new Vector();
                object = node2.getChildNodes();
                for (int i = 0; i < object.getLength(); ++i) {
                    Node node3;
                    String string;
                    QName qName2 = Utils.getNodeQName(object.item(i));
                    if (qName2 == null || !qName2.getLocalPart().equals("enumeration") || !Constants.isSchemaXSD(qName2.getNamespaceURI()) || (string = Utils.getAttribute(node3 = object.item(i), "value")) == null) continue;
                    ((Vector)serializable).add(string);
                }
                if (((Vector)serializable).isEmpty()) {
                    return null;
                }
                ((Vector)serializable).add(0, type);
                return serializable;
            }
        }
        return null;
    }

    public static String capitalizeFirstChar(String string) {
        if (string == null || string.equals("")) {
            return string;
        }
        char c = string.charAt(0);
        if (Character.isLowerCase(c)) {
            c = Character.toUpperCase(c);
            return c + string.substring(1);
        }
        return string;
    }

    public static String addUnderscore(String string) {
        if (string == null || string.equals("")) {
            return string;
        }
        return "_" + string;
    }

    public static String xmlNameToJava(String string) {
        return JavaUtils.xmlNameToJava(string);
    }

    public static String xmlNameToJavaClass(String string) {
        return Utils.capitalizeFirstChar(Utils.xmlNameToJava(string));
    }

    public static String makePackageName(String string) {
        Object object;
        String string2 = null;
        String string3 = "";
        try {
            object = new URL(string);
            string2 = ((URL)object).getHost();
            string3 = ((URL)object).getPath();
        }
        catch (MalformedURLException malformedURLException) {
            if (string.indexOf(":") > -1) {
                string2 = string.substring(string.indexOf(":") + 1);
                if (string2.indexOf("/") > -1) {
                    string2 = string2.substring(0, string2.indexOf("/"));
                }
            }
            string2 = string;
        }
        if (string2 == null) {
            return null;
        }
        string2 = string2.replace('-', '_');
        if ((string3 = string3.replace('-', '_')).length() > 0 && string3.charAt(string3.length() - 1) == '/') {
            string3 = string3.substring(0, string3.length() - 1);
        }
        object = new StringTokenizer(string2, ".:");
        String[] stringArray = new String[((StringTokenizer)object).countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((StringTokenizer)object).nextToken();
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = stringArray.length - 1; i >= 0; --i) {
            Utils.addWordToPackageBuffer(stringBuffer, stringArray[i], i == stringArray.length - 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
        while (stringTokenizer.hasMoreTokens()) {
            Utils.addWordToPackageBuffer(stringBuffer, stringTokenizer.nextToken(), false);
        }
        return stringBuffer.toString();
    }

    private static void addWordToPackageBuffer(StringBuffer stringBuffer, String string, boolean bl) {
        if (JavaUtils.isJavaKeyword(string)) {
            string = JavaUtils.makeNonJavaKeyword(string);
        }
        if (!bl) {
            stringBuffer.append('.');
        }
        if (Character.isDigit(string.charAt(0))) {
            stringBuffer.append('_');
        }
        if (string.indexOf(46) != -1) {
            char[] cArray = string.toCharArray();
            for (int i = 0; i < string.length(); ++i) {
                if (cArray[i] != '.') continue;
                cArray[i] = 95;
            }
            string = new String(cArray);
        }
        stringBuffer.append(string);
    }

    public static String getJavaLocalName(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static String getJavaPackageName(String string) {
        if (string.lastIndexOf(46) > 0) {
            return string.substring(0, string.lastIndexOf(46));
        }
        return "";
    }

    public static boolean fileExists(String string, String string2, Namespaces namespaces) throws IOException {
        String string3 = namespaces.getAsDir(string2);
        String string4 = string3 + string;
        return new File(string4).exists();
    }

    public static String wrapPrimitiveType(TypeEntry typeEntry, String string) {
        String string2;
        String string3 = string2 = typeEntry == null ? null : (String)TYPES.get(typeEntry.getName());
        if (string2 != null) {
            return "new " + string2 + "(" + string + ")";
        }
        if (typeEntry != null && typeEntry.getName().equals("byte[]") && typeEntry.getQName().getLocalPart().equals("hexBinary")) {
            return "new org.apache.axis.types.HexBinary(" + string + ")";
        }
        return string;
    }

    public static String getResponseString(Parameter parameter, String string) {
        String string2;
        if (parameter.getType() == null) {
            return ";";
        }
        String string3 = parameter.getType().getName();
        MimeInfo mimeInfo = parameter.getMIMEInfo();
        String string4 = mimeInfo == null ? null : mimeInfo.getType();
        String string5 = string2 = mimeInfo == null ? "" : mimeInfo.getDimensions();
        if (string4 != null) {
            if (string4.equals("image/gif") || string4.equals("image/jpeg")) {
                return "(java.awt.Image" + string2 + ") " + string + ";";
            }
            if (string4.equals("text/plain")) {
                return "(java.lang.String" + string2 + ") " + string + ";";
            }
            if (string4.equals("text/xml") || string4.equals("application/xml")) {
                return "(javax.xml.transform.Source" + string2 + ") " + string + ";";
            }
            if (string4.startsWith("multipart/")) {
                return "(javax.mail.internet.MimeMultipart" + string2 + ") " + string + ";";
            }
            if (string4.startsWith("application/octetstream") || string4.startsWith("application/octet-stream")) {
                return "(org.apache.axis.attachments.OctetStream" + string2 + ") " + string + ";";
            }
            return "(javax.activation.DataHandler" + string2 + ") " + string + ";";
        }
        String string6 = (String)TYPES.get(string3);
        if (string6 != null) {
            if (parameter.isOmittable() && parameter.getType().getDimensions().equals("") || parameter.getType().getUnderlTypeNillable()) {
                string3 = Utils.getWrapperType(parameter.getType());
            } else {
                return "((" + string6 + ") " + string + ")." + string3 + "Value();";
            }
        }
        return "(" + string3 + ") " + string + ";";
    }

    public static boolean isPrimitiveType(TypeEntry typeEntry) {
        return TYPES.get(typeEntry.getName()) != null;
    }

    public static String getWrapperType(String string) {
        String string2 = (String)TYPES.get(string);
        return string2 == null ? string : string2;
    }

    public static String getWrapperType(TypeEntry typeEntry) {
        String string = typeEntry.getDimensions();
        if (!string.equals("")) {
            TypeEntry typeEntry2 = typeEntry.getRefType();
            if (typeEntry2 != null && !typeEntry2.getDimensions().equals("")) {
                return Utils.getWrapperType(typeEntry2) + string;
            }
            if (typeEntry2 instanceof BaseType || typeEntry2 instanceof DefinedElement && typeEntry2.getRefType() instanceof BaseType) {
                return Utils.getWrapperType(typeEntry2) + string;
            }
        }
        return Utils.getWrapperType(typeEntry.getName());
    }

    public static QName getOperationQName(BindingOperation bindingOperation, BindingEntry bindingEntry, SymbolTable symbolTable) {
        Object object;
        Object object2;
        Operation operation = bindingOperation.getOperation();
        String string = operation.getName();
        if (bindingEntry.getBindingStyle() == Style.DOCUMENT && symbolTable.isWrapped() && (object2 = operation.getInput()) != null && (object = object2.getMessage().getParts()) != null && !object.isEmpty()) {
            Iterator iterator = object.values().iterator();
            Part part = (Part)iterator.next();
            return part.getElementName();
        }
        object2 = null;
        object = bindingOperation.getBindingInput();
        if (object != null) {
            for (ExtensibilityElement extensibilityElement : object.getExtensibilityElements()) {
                Serializable serializable;
                ExtensibilityElement extensibilityElement2;
                if (extensibilityElement instanceof SOAPBody) {
                    extensibilityElement2 = (SOAPBody)extensibilityElement;
                    object2 = extensibilityElement2.getNamespaceURI();
                    if (bindingEntry.getInputBodyType(operation) != Use.ENCODED || object2 != null && ((String)object2).length() != 0) break;
                    log.warn(Messages.getMessage("badNamespaceForOperation00", bindingEntry.getName(), operation.getName()));
                    break;
                }
                if (extensibilityElement instanceof MIMEMultipartRelated) {
                    extensibilityElement2 = null;
                    serializable = (MIMEMultipartRelated)extensibilityElement;
                    List list = serializable.getMIMEParts();
                    block1: for (int i = 0; list != null && i < list.size() && extensibilityElement2 == null; ++i) {
                        MIMEPart mIMEPart = (MIMEPart)list.get(i);
                        List list2 = mIMEPart.getExtensibilityElements();
                        for (int j = 0; list2 != null && j < list2.size() && extensibilityElement2 == null; ++j) {
                            extensibilityElement2 = list2.get(j);
                            if (extensibilityElement2 instanceof SOAPBody) {
                                ExtensibilityElement extensibilityElement3 = extensibilityElement2;
                                object2 = extensibilityElement3.getNamespaceURI();
                                if (bindingEntry.getInputBodyType(operation) != Use.ENCODED || object2 != null && ((String)object2).length() != 0) continue block1;
                                log.warn(Messages.getMessage("badNamespaceForOperation00", bindingEntry.getName(), operation.getName()));
                                continue block1;
                            }
                            extensibilityElement2 = null;
                        }
                    }
                    continue;
                }
                if (!(extensibilityElement instanceof UnknownExtensibilityElement) || !((QName)(serializable = ((UnknownExtensibilityElement)(extensibilityElement2 = (UnknownExtensibilityElement)extensibilityElement)).getElementType())).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !((QName)serializable).getLocalPart().equals("body")) continue;
                object2 = ((UnknownExtensibilityElement)extensibilityElement2).getElement().getAttribute("namespace");
            }
        }
        if (object2 == null) {
            object2 = "";
        }
        return new QName((String)object2, string);
    }

    public static String getOperationSOAPAction(BindingOperation bindingOperation) {
        List list = bindingOperation.getExtensibilityElements();
        Iterator iterator = list.iterator();
        boolean bl = false;
        String string = null;
        while (!bl && iterator.hasNext()) {
            QName qName;
            ExtensibilityElement extensibilityElement;
            ExtensibilityElement extensibilityElement2 = (ExtensibilityElement)iterator.next();
            if (extensibilityElement2 instanceof SOAPOperation) {
                extensibilityElement = (SOAPOperation)extensibilityElement2;
                string = extensibilityElement.getSoapActionURI();
                bl = true;
                continue;
            }
            if (!(extensibilityElement2 instanceof UnknownExtensibilityElement) || !(qName = ((UnknownExtensibilityElement)(extensibilityElement = (UnknownExtensibilityElement)extensibilityElement2)).getElementType()).getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/soap12/") || !qName.getLocalPart().equals("operation")) continue;
            string = ((UnknownExtensibilityElement)extensibilityElement).getElement().getAttribute("soapAction");
            bl = true;
        }
        return string;
    }

    public static String getNewQName(QName qName) {
        return "new javax.xml.namespace.QName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\")";
    }

    public static String getNewQNameWithLastLocalPart(QName qName) {
        return "new javax.xml.namespace.QName(\"" + qName.getNamespaceURI() + "\", \"" + Utils.getLastLocalPart(qName.getLocalPart()) + "\")";
    }

    public static String getParameterTypeName(Parameter parameter) {
        String string;
        if (parameter.getMIMEInfo() == null) {
            string = parameter.getType().getName();
            if (parameter.isOmittable() && parameter.getType().getDimensions().equals("") || parameter.getType().getUnderlTypeNillable()) {
                string = Utils.getWrapperType(parameter.getType());
            }
        } else {
            String string2 = parameter.getMIMEInfo().getType();
            string = JavaUtils.mimeToJava(string2);
            string = string == null ? parameter.getType().getName() : string + parameter.getMIMEInfo().getDimensions();
        }
        return string;
    }

    public static QName getXSIType(Parameter parameter) {
        if (parameter.getMIMEInfo() != null) {
            return Utils.getMIMETypeQName(parameter.getMIMEInfo().getType());
        }
        return Utils.getXSIType(parameter.getType());
    }

    public static QName getXSIType(TypeEntry typeEntry) {
        QName qName = null;
        if (typeEntry != null && typeEntry instanceof Element && typeEntry.getRefType() != null) {
            typeEntry = typeEntry.getRefType();
        }
        if (typeEntry != null && typeEntry instanceof CollectionTE && typeEntry.getRefType() != null) {
            typeEntry = typeEntry.getRefType();
        }
        if (typeEntry != null) {
            qName = typeEntry.getQName();
        }
        return qName;
    }

    public static QName getMIMETypeQName(String string) {
        if ("text/plain".equals(string)) {
            return Constants.MIME_PLAINTEXT;
        }
        if ("image/gif".equals(string) || "image/jpeg".equals(string)) {
            return Constants.MIME_IMAGE;
        }
        if ("text/xml".equals(string) || "applications/xml".equals(string)) {
            return Constants.MIME_SOURCE;
        }
        if ("application/octet-stream".equals(string) || "application/octetstream".equals(string)) {
            return Constants.MIME_OCTETSTREAM;
        }
        if (string != null && string.startsWith("multipart/")) {
            return Constants.MIME_MULTIPART;
        }
        return Constants.MIME_DATA_HANDLER;
    }

    public static boolean hasMIME(BindingEntry bindingEntry) {
        List list = bindingEntry.getBinding().getBindingOperations();
        for (int i = 0; i < list.size(); ++i) {
            BindingOperation bindingOperation = (BindingOperation)list.get(i);
            if (!Utils.hasMIME(bindingEntry, bindingOperation)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMIME(BindingEntry bindingEntry, BindingOperation bindingOperation) {
        Parameters parameters = bindingEntry.getParameters(bindingOperation.getOperation());
        if (parameters != null) {
            for (int i = 0; i < parameters.list.size(); ++i) {
                Parameter parameter = (Parameter)parameters.list.get(i);
                if (parameter.getMIMEInfo() == null) continue;
                return true;
            }
        }
        return false;
    }

    public static String getConstructorForParam(Parameter parameter, SymbolTable symbolTable, BooleanHolder booleanHolder) {
        Vector vector;
        String string = parameter.getType().getName();
        if (parameter.isOmittable()) {
            string = Utils.getWrapperType(string);
        }
        String string2 = parameter.getMIMEInfo() == null ? null : parameter.getMIMEInfo().getType();
        String string3 = parameter.getMIMEInfo() == null ? "" : parameter.getMIMEInfo().getDimensions();
        String string4 = null;
        if (string2 != null) {
            if (string2.equals("image/gif") || string2.equals("image/jpeg")) {
                return "null";
            }
            if (string2.equals("text/xml") || string2.equals("application/xml")) {
                if (string3.length() <= 0) {
                    return "new javax.xml.transform.stream.StreamSource()";
                }
                return "new javax.xml.transform.stream.StreamSource[0]";
            }
            if (string2.equals("application/octet-stream") || string2.equals("application/octetstream")) {
                if (string3.length() <= 0) {
                    return "new org.apache.axis.attachments.OctetStream()";
                }
                return "new org.apache.axis.attachments.OctetStream[0]";
            }
            return "new " + Utils.getParameterTypeName(parameter) + "()";
        }
        string4 = (String)constructorMap.get(string);
        if (string4 != null) {
            return string4;
        }
        string4 = (String)constructorThrowMap.get(string);
        if (string4 != null) {
            booleanHolder.value = true;
            return string4;
        }
        if (string.endsWith("[]")) {
            return "new " + JavaUtils.replace(string, "[]", "[0]");
        }
        Vector vector2 = Utils.getEnumerationBaseAndValues(parameter.getType().getNode(), symbolTable);
        if (vector2 != null) {
            String string5 = (String)JavaEnumTypeWriter.getEnumValueIds(vector2).get(0);
            return string + "." + string5;
        }
        if (parameter.getType().getRefType() != null && (vector = Utils.getEnumerationBaseAndValues(parameter.getType().getRefType().getNode(), symbolTable)) != null) {
            String string6 = (String)JavaEnumTypeWriter.getEnumValueIds(vector).get(0);
            return string + "." + string6;
        }
        return "new " + string + "()";
    }

    public static boolean shouldEmit(TypeEntry typeEntry) {
        return (typeEntry.getBaseType() == null || typeEntry.getRefType() != null) && !(typeEntry instanceof CollectionTE) && !(typeEntry instanceof Element) && typeEntry.isReferenced() && !typeEntry.isOnlyLiteralReferenced() && (typeEntry.getNode() == null || !Utils.isXsNode(typeEntry.getNode(), "group") && !Utils.isXsNode(typeEntry.getNode(), "attributeGroup"));
    }

    public static boolean isXsNode(Node node, String string) {
        return node.getLocalName().equals(string) && Constants.isSchemaXSD(node.getNamespaceURI());
    }

    public static QName getItemQName(TypeEntry typeEntry) {
        if (typeEntry instanceof DefinedElement) {
            typeEntry = typeEntry.getRefType();
        }
        return typeEntry.getItemQName();
    }

    public static QName getItemType(TypeEntry typeEntry) {
        if (typeEntry instanceof DefinedElement) {
            typeEntry = typeEntry.getRefType();
        }
        return typeEntry.getComponentType();
    }

    static {
        TYPES.put("int", "java.lang.Integer");
        TYPES.put("float", "java.lang.Float");
        TYPES.put("boolean", "java.lang.Boolean");
        TYPES.put("double", "java.lang.Double");
        TYPES.put("byte", "java.lang.Byte");
        TYPES.put("short", "java.lang.Short");
        TYPES.put("long", "java.lang.Long");
        constructorMap = new HashMap(50);
        constructorThrowMap = new HashMap(50);
        constructorMap.put("int", "0");
        constructorMap.put("float", "0");
        constructorMap.put("boolean", "true");
        constructorMap.put("double", "0");
        constructorMap.put("byte", "(byte)0");
        constructorMap.put("short", "(short)0");
        constructorMap.put("long", "0");
        constructorMap.put("java.lang.Boolean", "new java.lang.Boolean(false)");
        constructorMap.put("java.lang.Byte", "new java.lang.Byte((byte)0)");
        constructorMap.put("java.lang.Double", "new java.lang.Double(0)");
        constructorMap.put("java.lang.Float", "new java.lang.Float(0)");
        constructorMap.put("java.lang.Integer", "new java.lang.Integer(0)");
        constructorMap.put("java.lang.Long", "new java.lang.Long(0)");
        constructorMap.put("java.lang.Short", "new java.lang.Short((short)0)");
        constructorMap.put("java.math.BigDecimal", "new java.math.BigDecimal(0)");
        constructorMap.put("java.math.BigInteger", "new java.math.BigInteger(\"0\")");
        constructorMap.put("java.lang.Object", "new java.lang.String()");
        constructorMap.put("byte[]", "new byte[0]");
        constructorMap.put("java.util.Calendar", "java.util.Calendar.getInstance()");
        constructorMap.put("javax.xml.namespace.QName", "new javax.xml.namespace.QName(\"http://double-double\", \"toil-and-trouble\")");
        constructorMap.put("org.apache.axis.types.NonNegativeInteger", "new org.apache.axis.types.NonNegativeInteger(\"0\")");
        constructorMap.put("org.apache.axis.types.PositiveInteger", "new org.apache.axis.types.PositiveInteger(\"1\")");
        constructorMap.put("org.apache.axis.types.NonPositiveInteger", "new org.apache.axis.types.NonPositiveInteger(\"0\")");
        constructorMap.put("org.apache.axis.types.NegativeInteger", "new org.apache.axis.types.NegativeInteger(\"-1\")");
        constructorThrowMap.put("org.apache.axis.types.Time", "new org.apache.axis.types.Time(\"15:45:45.275Z\")");
        constructorThrowMap.put("org.apache.axis.types.UnsignedLong", "new org.apache.axis.types.UnsignedLong(0)");
        constructorThrowMap.put("org.apache.axis.types.UnsignedInt", "new org.apache.axis.types.UnsignedInt(0)");
        constructorThrowMap.put("org.apache.axis.types.UnsignedShort", "new org.apache.axis.types.UnsignedShort(0)");
        constructorThrowMap.put("org.apache.axis.types.UnsignedByte", "new org.apache.axis.types.UnsignedByte(0)");
        constructorThrowMap.put("org.apache.axis.types.URI", "new org.apache.axis.types.URI(\"urn:testing\")");
        constructorThrowMap.put("org.apache.axis.types.Year", "new org.apache.axis.types.Year(2000)");
        constructorThrowMap.put("org.apache.axis.types.Month", "new org.apache.axis.types.Month(1)");
        constructorThrowMap.put("org.apache.axis.types.Day", "new org.apache.axis.types.Day(1)");
        constructorThrowMap.put("org.apache.axis.types.YearMonth", "new org.apache.axis.types.YearMonth(2000,1)");
        constructorThrowMap.put("org.apache.axis.types.MonthDay", "new org.apache.axis.types.MonthDay(1, 1)");
    }
}

