/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.apps.svgbrowser;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.gvt.CanvasGraphicsNode;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.swing.gvt.GVTTreeRendererAdapter;
import org.apache.batik.swing.gvt.GVTTreeRendererEvent;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.gvt.Overlay;
import org.apache.batik.swing.svg.GVTTreeBuilderAdapter;
import org.apache.batik.swing.svg.GVTTreeBuilderEvent;
import org.apache.batik.swing.svg.SVGDocumentLoaderAdapter;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.util.gui.resource.ResourceManager;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class ThumbnailPanel
extends JPanel {
    protected static final String RESOURCES = "org.apache.batik.apps.svgbrowser.resources.ThumbnailDialog";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.apps.svgbrowser.resources.ThumbnailDialog", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected JSVGCanvas svgCanvas;
    protected JGVTComponent svgThumbnailCanvas;
    protected boolean documentChanged;
    protected AreaOfInterestOverlay overlay;
    protected double scale;

    public ThumbnailPanel(JSVGCanvas jSVGCanvas) {
        this.svgCanvas = jSVGCanvas;
        jSVGCanvas.addGVTTreeRendererListener(new ThumbnailGVTListener());
        jSVGCanvas.addGVTTreeBuilderListener(new ThumbnailDocumentChangeListener());
        jSVGCanvas.addComponentListener(new ThumbnailCanvasComponentListener());
        this.svgThumbnailCanvas = new JGVTComponent();
        this.overlay = new AreaOfInterestOverlay();
        this.svgThumbnailCanvas.getOverlays().add(this.overlay);
        this.svgThumbnailCanvas.setPreferredSize(new Dimension(200, 200));
        this.svgThumbnailCanvas.addComponentListener(new ThumbnailComponentListener());
        AreaOfInterestListener areaOfInterestListener = new AreaOfInterestListener();
        this.svgThumbnailCanvas.addMouseListener(areaOfInterestListener);
        this.svgThumbnailCanvas.addMouseMotionListener(areaOfInterestListener);
        this.svgThumbnailCanvas.setDoubleBufferedRendering(false);
        this.add((Component)this.svgThumbnailCanvas, "Center");
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ThumbnailPanel.this.svgThumbnailCanvas.setPreferredSize(ThumbnailPanel.this.getSize());
                ThumbnailPanel.this.svgThumbnailCanvas.setMinimumSize(ThumbnailPanel.this.getSize());
                ThumbnailPanel.this.svgThumbnailCanvas.setMaximumSize(ThumbnailPanel.this.getSize());
            }
        });
        this.svgThumbnailCanvas.addGVTTreeRendererListener(new GVTTreeRendererAdapter(){

            public void gvtRenderingPrepare(GVTTreeRendererEvent gVTTreeRendererEvent) {
            }

            public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
            }
        });
    }

    public void releaseThumbnailRenderingReferences() {
        if (this.svgThumbnailCanvas != null) {
            this.svgThumbnailCanvas.releaseRenderingReferences();
        }
    }

    protected void updateThumbnailGraphicsNode() {
        this.svgThumbnailCanvas.setGraphicsNode(this.svgCanvas.getGraphicsNode());
        this.updateThumbnailRenderingTransform();
    }

    protected CanvasGraphicsNode getCanvasGraphicsNode(GraphicsNode graphicsNode) {
        if (!(graphicsNode instanceof CompositeGraphicsNode)) {
            return null;
        }
        CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)graphicsNode;
        if (!((graphicsNode = (GraphicsNode)compositeGraphicsNode.getChildren().get(0)) instanceof CanvasGraphicsNode)) {
            return null;
        }
        return (CanvasGraphicsNode)graphicsNode;
    }

    protected void updateThumbnailRenderingTransform() {
        SVGDocument sVGDocument = this.svgCanvas.getSVGDocument();
        if (sVGDocument != null) {
            CanvasGraphicsNode canvasGraphicsNode;
            Object object;
            SVGSVGElement sVGSVGElement = sVGDocument.getRootElement();
            Dimension dimension = this.svgThumbnailCanvas.getSize();
            AffineTransform affineTransform = ViewBox.getViewTransform(null, sVGSVGElement, dimension.width, dimension.height);
            if (affineTransform.isIdentity()) {
                object = this.svgCanvas.getSVGDocumentSize();
                if (object == null) {
                    return;
                }
                double d = (double)dimension.width / ((Dimension2D)object).getWidth();
                double d2 = (double)dimension.height / ((Dimension2D)object).getHeight();
                double d3 = Math.min(d, d2);
                affineTransform = AffineTransform.getScaleInstance(d3, d3);
                this.scale = d3;
            }
            if ((canvasGraphicsNode = this.getCanvasGraphicsNode((GraphicsNode)(object = this.svgCanvas.getGraphicsNode()))) == null) {
                return;
            }
            AffineTransform affineTransform2 = canvasGraphicsNode.getViewingTransform();
            if (affineTransform2 != null && !affineTransform2.isIdentity()) {
                try {
                    AffineTransform affineTransform3 = affineTransform2.createInverse();
                    affineTransform.concatenate(affineTransform3);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            this.svgThumbnailCanvas.setRenderingTransform(affineTransform);
            this.overlay.synchronizeAreaOfInterest();
        }
    }

    protected class AreaOfInterestOverlay
    implements Overlay {
        protected Shape s;
        protected AffineTransform at;
        protected AffineTransform paintingTransform = new AffineTransform();

        protected AreaOfInterestOverlay() {
        }

        public boolean contains(int n, int n2) {
            return this.s != null ? this.s.contains(n, n2) : false;
        }

        public AffineTransform getOverlayTransform() {
            return this.at;
        }

        public void setPaintingTransform(AffineTransform affineTransform) {
            this.paintingTransform = affineTransform;
        }

        public AffineTransform getPaintingTransform() {
            return this.paintingTransform;
        }

        public void synchronizeAreaOfInterest() {
            this.paintingTransform = new AffineTransform();
            Dimension dimension = ThumbnailPanel.this.svgCanvas.getSize();
            this.s = new Rectangle2D.Float(0.0f, 0.0f, dimension.width, dimension.height);
            try {
                this.at = ThumbnailPanel.this.svgCanvas.getRenderingTransform().createInverse();
                this.at.preConcatenate(ThumbnailPanel.this.svgThumbnailCanvas.getRenderingTransform());
                this.s = this.at.createTransformedShape(this.s);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                dimension = ThumbnailPanel.this.svgThumbnailCanvas.getSize();
                this.s = new Rectangle2D.Float(0.0f, 0.0f, dimension.width, dimension.height);
            }
        }

        public void paint(Graphics graphics) {
            if (this.s != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.transform(this.paintingTransform);
                graphics2D.setColor(new Color(255, 255, 255, 128));
                graphics2D.fill(this.s);
                graphics2D.setColor(Color.black);
                graphics2D.setStroke(new BasicStroke());
                graphics2D.draw(this.s);
            }
        }
    }

    protected class ThumbnailCanvasComponentListener
    extends ComponentAdapter {
        protected ThumbnailCanvasComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            ThumbnailPanel.this.updateThumbnailRenderingTransform();
        }
    }

    protected class ThumbnailComponentListener
    extends ComponentAdapter {
        protected ThumbnailComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            ThumbnailPanel.this.updateThumbnailRenderingTransform();
        }
    }

    protected class ThumbnailGVTListener
    extends GVTTreeRendererAdapter {
        protected ThumbnailGVTListener() {
        }

        public void gvtRenderingCompleted(GVTTreeRendererEvent gVTTreeRendererEvent) {
            if (ThumbnailPanel.this.documentChanged) {
                ThumbnailPanel.this.updateThumbnailGraphicsNode();
                ThumbnailPanel.this.documentChanged = false;
            } else {
                ThumbnailPanel.this.overlay.synchronizeAreaOfInterest();
                ThumbnailPanel.this.svgThumbnailCanvas.repaint();
            }
        }

        public void gvtRenderingCancelled(GVTTreeRendererEvent gVTTreeRendererEvent) {
            if (ThumbnailPanel.this.documentChanged) {
                ThumbnailPanel.this.svgThumbnailCanvas.setGraphicsNode(null);
                ThumbnailPanel.this.svgThumbnailCanvas.setRenderingTransform(new AffineTransform());
            }
        }

        public void gvtRenderingFailed(GVTTreeRendererEvent gVTTreeRendererEvent) {
            if (ThumbnailPanel.this.documentChanged) {
                ThumbnailPanel.this.svgThumbnailCanvas.setGraphicsNode(null);
                ThumbnailPanel.this.svgThumbnailCanvas.setRenderingTransform(new AffineTransform());
            }
        }
    }

    protected class AreaOfInterestListener
    extends MouseInputAdapter {
        protected int sx;
        protected int sy;
        protected boolean in;

        protected AreaOfInterestListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.sx = mouseEvent.getX();
            this.sy = mouseEvent.getY();
            this.in = ThumbnailPanel.this.overlay.contains(this.sx, this.sy);
            ThumbnailPanel.this.overlay.setPaintingTransform(new AffineTransform());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.in) {
                int n = mouseEvent.getX() - this.sx;
                int n2 = mouseEvent.getY() - this.sy;
                ThumbnailPanel.this.overlay.setPaintingTransform(AffineTransform.getTranslateInstance(n, n2));
                ThumbnailPanel.this.svgCanvas.setPaintingTransform(AffineTransform.getTranslateInstance(0.0 - (double)n / ThumbnailPanel.this.scale, 0.0 - (double)n2 / ThumbnailPanel.this.scale));
                ThumbnailPanel.this.svgThumbnailCanvas.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.in) {
                this.in = false;
                int n = mouseEvent.getX() - this.sx;
                int n2 = mouseEvent.getY() - this.sy;
                AffineTransform affineTransform = ThumbnailPanel.this.overlay.getOverlayTransform();
                Point2D.Float float_ = new Point2D.Float(0.0f, 0.0f);
                Point2D.Float float_2 = new Point2D.Float(n, n2);
                try {
                    affineTransform.inverseTransform(float_, float_);
                    affineTransform.inverseTransform(float_2, float_2);
                    double d = ((Point2D)float_).getX() - ((Point2D)float_2).getX();
                    double d2 = ((Point2D)float_).getY() - ((Point2D)float_2).getY();
                    affineTransform = ThumbnailPanel.this.svgCanvas.getRenderingTransform();
                    affineTransform.preConcatenate(AffineTransform.getTranslateInstance(d, d2));
                    ThumbnailPanel.this.svgCanvas.setRenderingTransform(affineTransform);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
        }
    }

    protected class ThumbnailDocumentChangeListener
    extends GVTTreeBuilderAdapter {
        protected ThumbnailDocumentChangeListener() {
        }

        public void gvtBuildStarted(GVTTreeBuilderEvent gVTTreeBuilderEvent) {
            ThumbnailPanel.this.documentChanged = true;
        }
    }

    protected class ThumbnailDocumentListener
    extends SVGDocumentLoaderAdapter {
        protected ThumbnailDocumentListener() {
        }

        public void documentLoadingStarted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            ThumbnailPanel.this.documentChanged = true;
        }
    }
}

