/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.batik.css.dom.CSSOMSVGColor;
import org.apache.batik.css.dom.CSSOMSVGPaint;
import org.apache.batik.css.dom.CSSOMSVGStyleDeclaration;
import org.apache.batik.css.dom.CSSOMStyleDeclaration;
import org.apache.batik.css.dom.CSSOMValue;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.svg.SVGColorManager;
import org.apache.batik.css.engine.value.svg.SVGPaintManager;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.svg.LiveAttributeValue;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.dom.svg.XMLBaseSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.svg.SVGAnimatedString;

public abstract class SVGStylableElement
extends SVGOMElement
implements CSSStylableElement {
    protected StyleMap computedStyleMap;

    protected SVGStylableElement() {
    }

    protected SVGStylableElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
    }

    public StyleMap getComputedStyleMap(String string) {
        return this.computedStyleMap;
    }

    public void setComputedStyleMap(String string, StyleMap styleMap) {
        this.computedStyleMap = styleMap;
    }

    public String getXMLId() {
        return this.getAttributeNS(null, "id");
    }

    public String getCSSClass() {
        return this.getAttributeNS(null, "class");
    }

    public URL getCSSBase() {
        try {
            String string = XMLBaseSupport.getCascadedXMLBase(this);
            if (string == null) {
                return null;
            }
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            throw new InternalError();
        }
    }

    public boolean isPseudoInstanceOf(String string) {
        if (string.equals("first-child")) {
            Node node;
            for (node = this.getPreviousSibling(); node != null && node.getNodeType() != 1; node = node.getPreviousSibling()) {
            }
            return node == null;
        }
        return false;
    }

    public CSSStyleDeclaration getStyle() {
        CSSStyleDeclaration cSSStyleDeclaration = (CSSStyleDeclaration)((Object)this.getLiveAttributeValue(null, "style"));
        if (cSSStyleDeclaration == null) {
            CSSEngine cSSEngine = ((SVGOMDocument)this.getOwnerDocument()).getCSSEngine();
            cSSStyleDeclaration = new StyleDeclaration(cSSEngine);
        }
        return cSSStyleDeclaration;
    }

    public CSSValue getPresentationAttribute(String string) {
        CSSValue cSSValue = (CSSValue)((Object)this.getLiveAttributeValue(null, string));
        if (cSSValue != null) {
            return cSSValue;
        }
        CSSEngine cSSEngine = ((SVGOMDocument)this.getOwnerDocument()).getCSSEngine();
        int n = cSSEngine.getPropertyIndex(string);
        if (n == -1) {
            return null;
        }
        if (n > 59) {
            if (cSSEngine.getValueManagers()[n] instanceof SVGPaintManager) {
                cSSValue = new PresentationAttributePaintValue(cSSEngine, string);
            }
            if (cSSEngine.getValueManagers()[n] instanceof SVGColorManager) {
                cSSValue = new PresentationAttributeColorValue(cSSEngine, string);
            }
        } else {
            switch (n) {
                case 15: 
                case 45: {
                    cSSValue = new PresentationAttributePaintValue(cSSEngine, string);
                    break;
                }
                case 19: 
                case 33: 
                case 43: {
                    cSSValue = new PresentationAttributeColorValue(cSSEngine, string);
                    break;
                }
                default: {
                    cSSValue = new PresentationAttributeValue(cSSEngine, string);
                }
            }
        }
        this.putLiveAttributeValue(null, string, (LiveAttributeValue)((Object)cSSValue));
        return cSSValue;
    }

    public SVGAnimatedString getClassName() {
        return this.getAnimatedStringAttribute(null, "class");
    }

    public class StyleDeclaration
    extends CSSOMSVGStyleDeclaration
    implements LiveAttributeValue,
    CSSOMStyleDeclaration.ValueProvider,
    CSSOMStyleDeclaration.ModificationHandler,
    CSSEngine.MainPropertyReceiver {
        protected org.apache.batik.css.engine.StyleDeclaration declaration;
        protected boolean mutate;

        public StyleDeclaration(CSSEngine cSSEngine) {
            super(null, null, cSSEngine);
            this.valueProvider = this;
            this.setModificationHandler(this);
            this.declaration = this.cssEngine.parseStyleDeclaration(SVGStylableElement.this, SVGStylableElement.this.getAttributeNS(null, "style"));
        }

        public Value getValue(String string) {
            int n = this.cssEngine.getPropertyIndex(string);
            for (int i = 0; i < this.declaration.size(); ++i) {
                if (n != this.declaration.getIndex(i)) continue;
                return this.declaration.getValue(i);
            }
            return null;
        }

        public boolean isImportant(String string) {
            int n = this.cssEngine.getPropertyIndex(string);
            for (int i = 0; i < this.declaration.size(); ++i) {
                if (n != this.declaration.getIndex(i)) continue;
                return this.declaration.getPriority(i);
            }
            return false;
        }

        public String getText() {
            return this.declaration.toString(this.cssEngine);
        }

        public int getLength() {
            return this.declaration.size();
        }

        public String item(int n) {
            return this.cssEngine.getPropertyName(this.declaration.getIndex(n));
        }

        public void attrAdded(Attr attr, String string) {
            if (!this.mutate) {
                this.declaration = this.cssEngine.parseStyleDeclaration(SVGStylableElement.this, string);
            }
        }

        public void attrModified(Attr attr, String string, String string2) {
            if (!this.mutate) {
                this.declaration = this.cssEngine.parseStyleDeclaration(SVGStylableElement.this, string2);
            }
        }

        public void attrRemoved(Attr attr, String string) {
            if (!this.mutate) {
                this.declaration = new org.apache.batik.css.engine.StyleDeclaration();
            }
        }

        public void textChanged(String string) throws DOMException {
            this.declaration = this.cssEngine.parseStyleDeclaration(SVGStylableElement.this, string);
            this.mutate = true;
            SVGStylableElement.this.setAttributeNS(null, "style", string);
            this.mutate = false;
        }

        public void propertyRemoved(String string) throws DOMException {
            int n = this.cssEngine.getPropertyIndex(string);
            for (int i = 0; i < this.declaration.size(); ++i) {
                if (n != this.declaration.getIndex(i)) continue;
                this.declaration.remove(i);
                this.mutate = true;
                SVGStylableElement.this.setAttributeNS(null, "style", this.declaration.toString(this.cssEngine));
                this.mutate = false;
                return;
            }
        }

        public void setMainProperty(String string, Value value, boolean bl) {
            int n;
            int n2 = this.cssEngine.getPropertyIndex(string);
            if (n2 == -1) {
                return;
            }
            for (n = 0; n < this.declaration.size() && n2 != this.declaration.getIndex(n); ++n) {
            }
            if (n < this.declaration.size()) {
                this.declaration.put(n, value, n2, bl);
            } else {
                this.declaration.append(value, n2, bl);
            }
        }

        public void propertyChanged(String string, String string2, String string3) throws DOMException {
            boolean bl = string3 != null && string3.length() > 0;
            this.cssEngine.setMainProperties(SVGStylableElement.this, this, string, string2, bl);
            this.mutate = true;
            SVGStylableElement.this.setAttributeNS(null, "style", this.declaration.toString(this.cssEngine));
            this.mutate = false;
        }
    }

    public class PresentationAttributePaintValue
    extends CSSOMSVGPaint
    implements LiveAttributeValue,
    CSSOMSVGColor.ValueProvider {
        protected CSSEngine cssEngine;
        protected String property;
        protected Value value;
        protected boolean mutate;

        public PresentationAttributePaintValue(CSSEngine cSSEngine, String string) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler(new CSSOMSVGPaint.AbstractModificationHandler(){

                protected Value getValue() {
                    return PresentationAttributePaintValue.this.getValue();
                }

                public void textChanged(String string) throws DOMException {
                    PresentationAttributePaintValue.this.value = PresentationAttributePaintValue.this.cssEngine.parsePropertyValue(SVGStylableElement.this, PresentationAttributePaintValue.this.property, string);
                    PresentationAttributePaintValue.this.mutate = true;
                    SVGStylableElement.this.setAttributeNS(null, PresentationAttributePaintValue.this.property, string);
                    PresentationAttributePaintValue.this.mutate = false;
                }
            });
            this.cssEngine = cSSEngine;
            this.property = string;
            Attr attr = SVGStylableElement.this.getAttributeNodeNS(null, string);
            if (attr != null) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, string, attr.getValue());
            }
        }

        public Value getValue() {
            if (this.value == null) {
                throw new DOMException(11, "");
            }
            return this.value;
        }

        public void attrAdded(Attr attr, String string) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, this.property, string);
            }
        }

        public void attrModified(Attr attr, String string, String string2) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, this.property, string2);
            }
        }

        public void attrRemoved(Attr attr, String string) {
            if (!this.mutate) {
                this.value = null;
            }
        }
    }

    public class PresentationAttributeColorValue
    extends CSSOMSVGColor
    implements LiveAttributeValue,
    CSSOMSVGColor.ValueProvider {
        protected CSSEngine cssEngine;
        protected String property;
        protected Value value;
        protected boolean mutate;

        public PresentationAttributeColorValue(CSSEngine cSSEngine, String string) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler(new CSSOMSVGColor.AbstractModificationHandler(){

                protected Value getValue() {
                    return PresentationAttributeColorValue.this.getValue();
                }

                public void textChanged(String string) throws DOMException {
                    PresentationAttributeColorValue.this.value = PresentationAttributeColorValue.this.cssEngine.parsePropertyValue(SVGStylableElement.this, PresentationAttributeColorValue.this.property, string);
                    PresentationAttributeColorValue.this.mutate = true;
                    SVGStylableElement.this.setAttributeNS(null, PresentationAttributeColorValue.this.property, string);
                    PresentationAttributeColorValue.this.mutate = false;
                }
            });
            this.cssEngine = cSSEngine;
            this.property = string;
            Attr attr = SVGStylableElement.this.getAttributeNodeNS(null, string);
            if (attr != null) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, string, attr.getValue());
            }
        }

        public Value getValue() {
            if (this.value == null) {
                throw new DOMException(11, "");
            }
            return this.value;
        }

        public void attrAdded(Attr attr, String string) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, this.property, string);
            }
        }

        public void attrModified(Attr attr, String string, String string2) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, this.property, string2);
            }
        }

        public void attrRemoved(Attr attr, String string) {
            if (!this.mutate) {
                this.value = null;
            }
        }
    }

    public class PresentationAttributeValue
    extends CSSOMValue
    implements LiveAttributeValue,
    CSSOMValue.ValueProvider {
        protected CSSEngine cssEngine;
        protected String property;
        protected Value value;
        protected boolean mutate;

        public PresentationAttributeValue(CSSEngine cSSEngine, String string) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler(new CSSOMValue.AbstractModificationHandler(){

                protected Value getValue() {
                    return PresentationAttributeValue.this.getValue();
                }

                public void textChanged(String string) throws DOMException {
                    PresentationAttributeValue.this.value = PresentationAttributeValue.this.cssEngine.parsePropertyValue(SVGStylableElement.this, PresentationAttributeValue.this.property, string);
                    PresentationAttributeValue.this.mutate = true;
                    SVGStylableElement.this.setAttributeNS(null, PresentationAttributeValue.this.property, string);
                    PresentationAttributeValue.this.mutate = false;
                }
            });
            this.cssEngine = cSSEngine;
            this.property = string;
            Attr attr = SVGStylableElement.this.getAttributeNodeNS(null, string);
            if (attr != null) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, string, attr.getValue());
            }
        }

        public Value getValue() {
            if (this.value == null) {
                throw new DOMException(11, "");
            }
            return this.value;
        }

        public void attrAdded(Attr attr, String string) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, this.property, string);
            }
        }

        public void attrModified(Attr attr, String string, String string2) {
            if (!this.mutate) {
                this.value = this.cssEngine.parsePropertyValue(SVGStylableElement.this, this.property, string2);
            }
        }

        public void attrRemoved(Attr attr, String string) {
            if (!this.mutate) {
                this.value = null;
            }
        }
    }
}

