/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public class ConstantPool
implements Cloneable,
Node,
Serializable {
    private int constant_pool_count;
    private Constant[] constant_pool;

    public ConstantPool(Constant[] constantArray) {
        this.setConstantPool(constantArray);
    }

    ConstantPool(DataInputStream dataInputStream) throws IOException, ClassFormatException {
        this.constant_pool_count = dataInputStream.readUnsignedShort();
        this.constant_pool = new Constant[this.constant_pool_count];
        for (int i = 1; i < this.constant_pool_count; ++i) {
            this.constant_pool[i] = Constant.readConstant(dataInputStream);
            byte by = this.constant_pool[i].getTag();
            if (by != 6 && by != 5) continue;
            ++i;
        }
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantPool(this);
    }

    public String constantToString(Constant constant) throws ClassFormatException {
        String string;
        byte by = constant.getTag();
        switch (by) {
            case 7: {
                int n = ((ConstantClass)constant).getNameIndex();
                constant = this.getConstant(n, (byte)1);
                string = Utility.compactClassName(((ConstantUtf8)constant).getBytes(), false);
                break;
            }
            case 8: {
                int n = ((ConstantString)constant).getStringIndex();
                constant = this.getConstant(n, (byte)1);
                string = "\"" + ConstantPool.escape(((ConstantUtf8)constant).getBytes()) + "\"";
                break;
            }
            case 1: {
                string = ((ConstantUtf8)constant).getBytes();
                break;
            }
            case 6: {
                string = "" + ((ConstantDouble)constant).getBytes();
                break;
            }
            case 4: {
                string = "" + ((ConstantFloat)constant).getBytes();
                break;
            }
            case 5: {
                string = "" + ((ConstantLong)constant).getBytes();
                break;
            }
            case 3: {
                string = "" + ((ConstantInteger)constant).getBytes();
                break;
            }
            case 12: {
                string = this.constantToString(((ConstantNameAndType)constant).getNameIndex(), (byte)1) + " " + this.constantToString(((ConstantNameAndType)constant).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = this.constantToString(((ConstantCP)constant).getClassIndex(), (byte)7) + "." + this.constantToString(((ConstantCP)constant).getNameAndTypeIndex(), (byte)12);
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + by);
            }
        }
        return string;
    }

    private static final String escape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 5);
        char[] cArray = string.toCharArray();
        block7: for (int i = 0; i < n; ++i) {
            switch (cArray[i]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block7;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block7;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String constantToString(int n, byte by) throws ClassFormatException {
        Constant constant = this.getConstant(n, by);
        return this.constantToString(constant);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.constant_pool_count);
        for (int i = 1; i < this.constant_pool_count; ++i) {
            if (this.constant_pool[i] == null) continue;
            this.constant_pool[i].dump(dataOutputStream);
        }
    }

    public Constant getConstant(int n) {
        if (n >= this.constant_pool.length || n < 0) {
            throw new ClassFormatException("Invalid constant pool reference: " + n + ". Constant pool size is: " + this.constant_pool.length);
        }
        return this.constant_pool[n];
    }

    public Constant getConstant(int n, byte by) throws ClassFormatException {
        Constant constant = this.getConstant(n);
        if (constant == null) {
            throw new ClassFormatException("Constant pool at index " + n + " is null.");
        }
        if (constant.getTag() == by) {
            return constant;
        }
        throw new ClassFormatException("Expected class `" + Constants.CONSTANT_NAMES[by] + "' at index " + n + " and got " + constant);
    }

    public Constant[] getConstantPool() {
        return this.constant_pool;
    }

    public String getConstantString(int n, byte by) throws ClassFormatException {
        int n2;
        Constant constant = this.getConstant(n, by);
        switch (by) {
            case 7: {
                n2 = ((ConstantClass)constant).getNameIndex();
                break;
            }
            case 8: {
                n2 = ((ConstantString)constant).getStringIndex();
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + by);
            }
        }
        constant = this.getConstant(n2, (byte)1);
        return ((ConstantUtf8)constant).getBytes();
    }

    public int getLength() {
        return this.constant_pool_count;
    }

    public void setConstant(int n, Constant constant) {
        this.constant_pool[n] = constant;
    }

    public void setConstantPool(Constant[] constantArray) {
        this.constant_pool = constantArray;
        this.constant_pool_count = constantArray == null ? 0 : constantArray.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < this.constant_pool_count; ++i) {
            stringBuffer.append(i + ")" + this.constant_pool[i] + "\n");
        }
        return stringBuffer.toString();
    }

    public ConstantPool copy() {
        ConstantPool constantPool = null;
        try {
            constantPool = (ConstantPool)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        constantPool.constant_pool = new Constant[this.constant_pool_count];
        for (int i = 1; i < this.constant_pool_count; ++i) {
            if (this.constant_pool[i] == null) continue;
            constantPool.constant_pool[i] = this.constant_pool[i].copy();
        }
        return constantPool;
    }
}

