/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.verifier.structurals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.GotoInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.JsrInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.RET;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Select;
import org.apache.bcel.verifier.exc.AssertionViolatedException;
import org.apache.bcel.verifier.exc.StructuralCodeConstraintException;
import org.apache.bcel.verifier.structurals.ExceptionHandler;
import org.apache.bcel.verifier.structurals.ExceptionHandlers;
import org.apache.bcel.verifier.structurals.ExecutionVisitor;
import org.apache.bcel.verifier.structurals.Frame;
import org.apache.bcel.verifier.structurals.InstConstraintVisitor;
import org.apache.bcel.verifier.structurals.InstructionContext;
import org.apache.bcel.verifier.structurals.LocalVariables;
import org.apache.bcel.verifier.structurals.OperandStack;
import org.apache.bcel.verifier.structurals.Subroutine;
import org.apache.bcel.verifier.structurals.Subroutines;

public class ControlFlowGraph {
    private final MethodGen method_gen;
    private final Subroutines subroutines;
    private final ExceptionHandlers exceptionhandlers;
    private Hashtable instructionContexts = new Hashtable();

    public ControlFlowGraph(MethodGen methodGen) {
        this.subroutines = new Subroutines(methodGen);
        this.exceptionhandlers = new ExceptionHandlers(methodGen);
        InstructionHandle[] instructionHandleArray = methodGen.getInstructionList().getInstructionHandles();
        for (int i = 0; i < instructionHandleArray.length; ++i) {
            this.instructionContexts.put(instructionHandleArray[i], new InstructionContextImpl(instructionHandleArray[i]));
        }
        this.method_gen = methodGen;
    }

    public InstructionContext contextOf(InstructionHandle instructionHandle) {
        InstructionContext instructionContext = (InstructionContext)this.instructionContexts.get(instructionHandle);
        if (instructionContext == null) {
            throw new AssertionViolatedException("InstructionContext requested for an InstructionHandle that's not known!");
        }
        return instructionContext;
    }

    public InstructionContext[] contextsOf(InstructionHandle[] instructionHandleArray) {
        InstructionContext[] instructionContextArray = new InstructionContext[instructionHandleArray.length];
        for (int i = 0; i < instructionHandleArray.length; ++i) {
            instructionContextArray[i] = this.contextOf(instructionHandleArray[i]);
        }
        return instructionContextArray;
    }

    public InstructionContext[] getInstructionContexts() {
        InstructionContext[] instructionContextArray = new InstructionContext[this.instructionContexts.values().size()];
        return this.instructionContexts.values().toArray(instructionContextArray);
    }

    public boolean isDead(InstructionHandle instructionHandle) {
        return this.instructionContexts.containsKey(instructionHandle);
    }

    private class InstructionContextImpl
    implements InstructionContext {
        private int TAG;
        private InstructionHandle instruction;
        private HashMap inFrames;
        private HashMap outFrames;
        private ArrayList executionPredecessors = null;

        public InstructionContextImpl(InstructionHandle instructionHandle) {
            if (instructionHandle == null) {
                throw new AssertionViolatedException("Cannot instantiate InstructionContextImpl from NULL.");
            }
            this.instruction = instructionHandle;
            this.inFrames = new HashMap();
            this.outFrames = new HashMap();
        }

        public int getTag() {
            return this.TAG;
        }

        public void setTag(int n) {
            this.TAG = n;
        }

        public ExceptionHandler[] getExceptionHandlers() {
            return ControlFlowGraph.this.exceptionhandlers.getExceptionHandlers(this.getInstruction());
        }

        public Frame getOutFrame(ArrayList arrayList) {
            this.executionPredecessors = arrayList;
            InstructionContextImpl instructionContextImpl = this.lastExecutionJSR();
            Frame frame = (Frame)this.outFrames.get(instructionContextImpl);
            if (frame == null) {
                throw new AssertionViolatedException("outFrame not set! This:\n" + this + "\nExecutionChain: " + this.getExecutionChain() + "\nOutFrames: '" + this.outFrames + "'.");
            }
            return frame.getClone();
        }

        public boolean execute(Frame frame, ArrayList arrayList, InstConstraintVisitor instConstraintVisitor, ExecutionVisitor executionVisitor) {
            this.executionPredecessors = (ArrayList)arrayList.clone();
            if (this.lastExecutionJSR() == null && ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction()) != ControlFlowGraph.this.subroutines.getTopLevel()) {
                throw new AssertionViolatedException("Huh?! Am I '" + this + "' part of a subroutine or not?");
            }
            if (this.lastExecutionJSR() != null && ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction()) == ControlFlowGraph.this.subroutines.getTopLevel()) {
                throw new AssertionViolatedException("Huh?! Am I '" + this + "' part of a subroutine or not?");
            }
            Frame frame2 = (Frame)this.inFrames.get(this.lastExecutionJSR());
            if (frame2 == null) {
                this.inFrames.put(this.lastExecutionJSR(), frame);
                frame2 = frame;
            } else {
                if (frame2.equals(frame)) {
                    return false;
                }
                if (!this.mergeInFrames(frame)) {
                    return false;
                }
            }
            Frame frame3 = frame2.getClone();
            try {
                instConstraintVisitor.setFrame(frame3);
                this.getInstruction().accept(instConstraintVisitor);
            }
            catch (StructuralCodeConstraintException structuralCodeConstraintException) {
                structuralCodeConstraintException.extendMessage("", "\nInstructionHandle: " + this.getInstruction() + "\n");
                structuralCodeConstraintException.extendMessage("", "\nExecution Frame:\n" + frame3);
                this.extendMessageWithFlow(structuralCodeConstraintException);
                throw structuralCodeConstraintException;
            }
            executionVisitor.setFrame(frame3);
            this.getInstruction().accept(executionVisitor);
            this.outFrames.put(this.lastExecutionJSR(), frame3);
            return true;
        }

        public String toString() {
            String string = this.getInstruction().toString(false) + "\t[InstructionContext]";
            return string;
        }

        private boolean mergeInFrames(Frame frame) {
            Frame frame2 = (Frame)this.inFrames.get(this.lastExecutionJSR());
            OperandStack operandStack = frame2.getStack().getClone();
            LocalVariables localVariables = frame2.getLocals().getClone();
            try {
                frame2.getStack().merge(frame.getStack());
                frame2.getLocals().merge(frame.getLocals());
            }
            catch (StructuralCodeConstraintException structuralCodeConstraintException) {
                this.extendMessageWithFlow(structuralCodeConstraintException);
                throw structuralCodeConstraintException;
            }
            return !operandStack.equals(frame2.getStack()) || !localVariables.equals(frame2.getLocals());
        }

        private String getExecutionChain() {
            String string = this.toString();
            for (int i = this.executionPredecessors.size() - 1; i >= 0; --i) {
                string = this.executionPredecessors.get(i) + "\n" + string;
            }
            return string;
        }

        private void extendMessageWithFlow(StructuralCodeConstraintException structuralCodeConstraintException) {
            String string = "Execution flow:\n";
            structuralCodeConstraintException.extendMessage("", string + this.getExecutionChain());
        }

        public InstructionHandle getInstruction() {
            return this.instruction;
        }

        private InstructionContextImpl lastExecutionJSR() {
            int n = this.executionPredecessors.size();
            int n2 = 0;
            for (int i = n - 1; i >= 0; --i) {
                InstructionContextImpl instructionContextImpl = (InstructionContextImpl)this.executionPredecessors.get(i);
                Instruction instruction = instructionContextImpl.getInstruction().getInstruction();
                if (instruction instanceof RET) {
                    ++n2;
                }
                if (!(instruction instanceof JsrInstruction) || --n2 != -1) continue;
                return instructionContextImpl;
            }
            return null;
        }

        public InstructionContext[] getSuccessors() {
            return ControlFlowGraph.this.contextsOf(this._getSuccessors());
        }

        private InstructionHandle[] _getSuccessors() {
            InstructionHandle[] instructionHandleArray = new InstructionHandle[]{};
            InstructionHandle[] instructionHandleArray2 = new InstructionHandle[1];
            InstructionHandle[] instructionHandleArray3 = new InstructionHandle[2];
            Instruction instruction = this.getInstruction().getInstruction();
            if (instruction instanceof RET) {
                Subroutine subroutine = ControlFlowGraph.this.subroutines.subroutineOf(this.getInstruction());
                if (subroutine == null) {
                    throw new AssertionViolatedException("Asking for successors of a RET in dead code?!");
                }
                throw new AssertionViolatedException("DID YOU REALLY WANT TO ASK FOR RET'S SUCCS?");
            }
            if (instruction instanceof ReturnInstruction) {
                return instructionHandleArray;
            }
            if (instruction instanceof ATHROW) {
                return instructionHandleArray;
            }
            if (instruction instanceof JsrInstruction) {
                instructionHandleArray2[0] = ((JsrInstruction)instruction).getTarget();
                return instructionHandleArray2;
            }
            if (instruction instanceof GotoInstruction) {
                instructionHandleArray2[0] = ((GotoInstruction)instruction).getTarget();
                return instructionHandleArray2;
            }
            if (instruction instanceof BranchInstruction) {
                if (instruction instanceof Select) {
                    InstructionHandle[] instructionHandleArray4 = ((Select)instruction).getTargets();
                    InstructionHandle[] instructionHandleArray5 = new InstructionHandle[instructionHandleArray4.length + 1];
                    instructionHandleArray5[0] = ((Select)instruction).getTarget();
                    System.arraycopy(instructionHandleArray4, 0, instructionHandleArray5, 1, instructionHandleArray4.length);
                    return instructionHandleArray5;
                }
                instructionHandleArray3[0] = this.getInstruction().getNext();
                instructionHandleArray3[1] = ((BranchInstruction)instruction).getTarget();
                return instructionHandleArray3;
            }
            instructionHandleArray2[0] = this.getInstruction().getNext();
            return instructionHandleArray2;
        }
    }
}

