/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;

public class Base64
implements BinaryEncoder,
BinaryDecoder {
    static final int CHUNK_SIZE = 76;
    static final byte[] CHUNK_SEPARATOR;
    static final int BASELENGTH = 255;
    static final int LOOKUPLENGTH = 64;
    static final int EIGHTBIT = 8;
    static final int SIXTEENBIT = 16;
    static final int TWENTYFOURBITGROUP = 24;
    static final int FOURBYTE = 4;
    static final int SIGN = -128;
    static final byte PAD = 61;
    private static byte[] base64Alphabet;
    private static byte[] lookUpBase64Alphabet;

    private static boolean isBase64(byte by) {
        if (by == 61) {
            return true;
        }
        return base64Alphabet[by] != -1;
    }

    public static boolean isArrayByteBase64(byte[] byArray) {
        int n = (byArray = Base64.discardWhitespace(byArray)).length;
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (Base64.isBase64(byArray[i])) continue;
            return false;
        }
        return true;
    }

    public static byte[] encodeBase64(byte[] byArray) {
        return Base64.encodeBase64(byArray, false);
    }

    public static byte[] encodeBase64Chunked(byte[] byArray) {
        return Base64.encodeBase64(byArray, true);
    }

    public Object decode(Object object) throws DecoderException {
        if (!(object instanceof byte[])) {
            throw new DecoderException("Parameter supplied to Base64 decode is not a byte[]");
        }
        return this.decode((byte[])object);
    }

    public byte[] decode(byte[] byArray) {
        return Base64.decodeBase64(byArray);
    }

    public static byte[] encodeBase64(byte[] byArray, boolean bl) {
        byte by;
        byte by2;
        int n = byArray.length * 8;
        int n2 = n % 24;
        int n3 = n / 24;
        byte[] byArray2 = null;
        int n4 = 0;
        int n5 = 0;
        n4 = n2 != 0 ? (n3 + 1) * 4 : n3 * 4;
        if (bl) {
            n5 = CHUNK_SEPARATOR.length == 0 ? 0 : (int)Math.ceil((float)n4 / 76.0f);
            n4 += n5 * CHUNK_SEPARATOR.length;
        }
        byArray2 = new byte[n4];
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 76;
        int n10 = 0;
        for (n8 = 0; n8 < n3; ++n8) {
            n7 = n8 * 3;
            by5 = byArray[n7];
            by6 = byArray[n7 + 1];
            by7 = byArray[n7 + 2];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            by = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            byte by8 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
            byArray2[n6] = lookUpBase64Alphabet[by2];
            byArray2[n6 + 1] = lookUpBase64Alphabet[by | by3 << 4];
            byArray2[n6 + 2] = lookUpBase64Alphabet[by4 << 2 | by8];
            byArray2[n6 + 3] = lookUpBase64Alphabet[by7 & 0x3F];
            if (!bl || (n6 += 4) != n9) continue;
            System.arraycopy(CHUNK_SEPARATOR, 0, byArray2, n6, CHUNK_SEPARATOR.length);
            n9 = 76 * (++n10 + 1) + n10 * CHUNK_SEPARATOR.length;
            n6 += CHUNK_SEPARATOR.length;
        }
        n7 = n8 * 3;
        if (n2 == 8) {
            by5 = byArray[n7];
            by3 = (byte)(by5 & 3);
            by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            byArray2[n6] = lookUpBase64Alphabet[by2];
            byArray2[n6 + 1] = lookUpBase64Alphabet[by3 << 4];
            byArray2[n6 + 2] = 61;
            byArray2[n6 + 3] = 61;
        } else if (n2 == 16) {
            by5 = byArray[n7];
            by6 = byArray[n7 + 1];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            by = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            byArray2[n6] = lookUpBase64Alphabet[by2];
            byArray2[n6 + 1] = lookUpBase64Alphabet[by | by3 << 4];
            byArray2[n6 + 2] = lookUpBase64Alphabet[by4 << 2];
            byArray2[n6 + 3] = 61;
        }
        if (bl && n10 < n5) {
            System.arraycopy(CHUNK_SEPARATOR, 0, byArray2, n4 - CHUNK_SEPARATOR.length, CHUNK_SEPARATOR.length);
        }
        return byArray2;
    }

    public static byte[] decodeBase64(byte[] byArray) {
        if ((byArray = Base64.discardNonBase64(byArray)).length == 0) {
            return new byte[0];
        }
        int n = byArray.length / 4;
        byte[] byArray2 = null;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray.length;
        while (byArray[n4 - 1] == 61) {
            if (--n4 != 0) continue;
            return new byte[0];
        }
        byArray2 = new byte[n4 - n];
        for (n4 = 0; n4 < n; ++n4) {
            n3 = n4 * 4;
            by5 = byArray[n3 + 2];
            by6 = byArray[n3 + 3];
            by = base64Alphabet[byArray[n3]];
            by2 = base64Alphabet[byArray[n3 + 1]];
            if (by5 != 61 && by6 != 61) {
                by3 = base64Alphabet[by5];
                by4 = base64Alphabet[by6];
                byArray2[n2] = (byte)(by << 2 | by2 >> 4);
                byArray2[n2 + 1] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
                byArray2[n2 + 2] = (byte)(by3 << 6 | by4);
            } else if (by5 == 61) {
                byArray2[n2] = (byte)(by << 2 | by2 >> 4);
            } else if (by6 == 61) {
                by3 = base64Alphabet[by5];
                byArray2[n2] = (byte)(by << 2 | by2 >> 4);
                byArray2[n2 + 1] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            }
            n2 += 3;
        }
        return byArray2;
    }

    static byte[] discardWhitespace(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        block3: for (int i = 0; i < byArray.length; ++i) {
            switch (byArray[i]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
                default: {
                    byArray2[n++] = byArray[i];
                }
            }
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    static byte[] discardNonBase64(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            if (!Base64.isBase64(byArray[i])) continue;
            byArray2[n++] = byArray[i];
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof byte[])) {
            throw new EncoderException("Parameter supplied to Base64 encode is not a byte[]");
        }
        return this.encode((byte[])object);
    }

    public byte[] encode(byte[] byArray) {
        return Base64.encodeBase64(byArray, false);
    }

    static {
        int n;
        CHUNK_SEPARATOR = "\r\n".getBytes();
        base64Alphabet = new byte[255];
        lookUpBase64Alphabet = new byte[64];
        for (n = 0; n < 255; ++n) {
            Base64.base64Alphabet[n] = -1;
        }
        for (n = 90; n >= 65; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 65);
        }
        for (n = 122; n >= 97; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 97 + 26);
        }
        for (n = 57; n >= 48; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 48 + 52);
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        for (n = 0; n <= 25; ++n) {
            Base64.lookUpBase64Alphabet[n] = (byte)(65 + n);
        }
        n = 26;
        int n2 = 0;
        while (n <= 51) {
            Base64.lookUpBase64Alphabet[n] = (byte)(97 + n2);
            ++n;
            ++n2;
        }
        n = 52;
        n2 = 0;
        while (n <= 61) {
            Base64.lookUpBase64Alphabet[n] = (byte)(48 + n2);
            ++n;
            ++n2;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }
}

