/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.net;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringDecoder;
import org.apache.commons.codec.StringEncoder;

public class QuotedPrintableCodec
implements BinaryEncoder,
BinaryDecoder,
StringEncoder,
StringDecoder {
    private String charset = "UTF-8";
    private static final BitSet PRINTABLE_CHARS;
    private static byte ESCAPE_CHAR;
    private static byte TAB;
    private static byte SPACE;

    public QuotedPrintableCodec() {
    }

    public QuotedPrintableCodec(String string) {
        this.charset = string;
    }

    private static final void encodeQuotedPrintable(int n, ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(ESCAPE_CHAR);
        char c = Character.toUpperCase(Character.forDigit(n >> 4 & 0xF, 16));
        char c2 = Character.toUpperCase(Character.forDigit(n & 0xF, 16));
        byteArrayOutputStream.write(c);
        byteArrayOutputStream.write(c2);
    }

    public static final byte[] encodeQuotedPrintable(BitSet bitSet, byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (bitSet == null) {
            bitSet = PRINTABLE_CHARS;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i];
            if (n < 0) {
                n = 256 + n;
            }
            if (bitSet.get(n)) {
                byteArrayOutputStream.write(n);
                continue;
            }
            QuotedPrintableCodec.encodeQuotedPrintable(n, byteArrayOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static final byte[] decodeQuotedPrintable(byte[] byArray) throws DecoderException {
        if (byArray == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by == ESCAPE_CHAR) {
                try {
                    int n = Character.digit((char)byArray[++i], 16);
                    int n2 = Character.digit((char)byArray[++i], 16);
                    if (n == -1 || n2 == -1) {
                        throw new DecoderException("Invalid quoted-printable encoding");
                    }
                    byteArrayOutputStream.write((char)((n << 4) + n2));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new DecoderException("Invalid quoted-printable encoding");
                }
            }
            byteArrayOutputStream.write(by);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] encode(byte[] byArray) {
        return QuotedPrintableCodec.encodeQuotedPrintable(PRINTABLE_CHARS, byArray);
    }

    public byte[] decode(byte[] byArray) throws DecoderException {
        return QuotedPrintableCodec.decodeQuotedPrintable(byArray);
    }

    public String encode(String string) throws EncoderException {
        if (string == null) {
            return null;
        }
        try {
            return this.encode(string, this.getDefaultCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncoderException(unsupportedEncodingException.getMessage());
        }
    }

    public String decode(String string, String string2) throws DecoderException, UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return new String(this.decode(string.getBytes("US-ASCII")), string2);
    }

    public String decode(String string) throws DecoderException {
        if (string == null) {
            return null;
        }
        try {
            return this.decode(string, this.getDefaultCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DecoderException(unsupportedEncodingException.getMessage());
        }
    }

    public Object encode(Object object) throws EncoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.encode((byte[])object);
        }
        if (object instanceof String) {
            return this.encode((String)object);
        }
        throw new EncoderException("Objects of type " + object.getClass().getName() + " cannot be quoted-printable encoded");
    }

    public Object decode(Object object) throws DecoderException {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return this.decode((byte[])object);
        }
        if (object instanceof String) {
            return this.decode((String)object);
        }
        throw new DecoderException("Objects of type " + object.getClass().getName() + " cannot be quoted-printable decoded");
    }

    public String getDefaultCharset() {
        return this.charset;
    }

    public String encode(String string, String string2) throws UnsupportedEncodingException {
        if (string == null) {
            return null;
        }
        return new String(this.encode(string.getBytes(string2)), "US-ASCII");
    }

    static {
        int n;
        PRINTABLE_CHARS = new BitSet(256);
        ESCAPE_CHAR = (byte)61;
        TAB = (byte)9;
        SPACE = (byte)32;
        for (n = 33; n <= 60; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        for (n = 62; n <= 126; ++n) {
            PRINTABLE_CHARS.set(n);
        }
        PRINTABLE_CHARS.set(TAB);
        PRINTABLE_CHARS.set(SPACE);
    }
}

