/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.jdk;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.discovery.jdk.JDKHooks;
import org.apache.commons.discovery.jdk.PsuedoSystemClassLoader;

class JDK12Hooks
extends JDKHooks {
    private static final ClassLoader systemClassLoader = JDK12Hooks.findSystemClassLoader();

    JDK12Hooks() {
    }

    public ClassLoader getThreadContextClassLoader() {
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            classLoader = null;
        }
        return classLoader;
    }

    public ClassLoader getSystemClassLoader() {
        return systemClassLoader;
    }

    public Enumeration getResources(ClassLoader classLoader, String string) throws IOException {
        final URL uRL = classLoader.getResource(string);
        final Enumeration<URL> enumeration = classLoader.getResources(string);
        return new Enumeration(){
            private boolean firstDone;
            private URL next;
            {
                this.firstDone = uRL == null;
                this.next = this.getNext();
            }

            public Object nextElement() {
                URL uRL2 = this.next;
                this.next = this.getNext();
                return uRL2;
            }

            public boolean hasMoreElements() {
                return this.next != null;
            }

            private URL getNext() {
                URL uRL2;
                if (!this.firstDone) {
                    this.firstDone = true;
                    uRL2 = uRL;
                } else {
                    uRL2 = null;
                    while (enumeration.hasMoreElements() && uRL2 == null) {
                        uRL2 = (URL)enumeration.nextElement();
                        if (uRL == null || uRL2 == null || !uRL2.equals(uRL)) continue;
                        uRL2 = null;
                    }
                }
                return uRL2;
            }
        };
    }

    private static ClassLoader findSystemClassLoader() {
        ClassLoader classLoader;
        try {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            classLoader = null;
        }
        if (classLoader == null) {
            classLoader = new PsuedoSystemClassLoader();
        }
        return classLoader;
    }
}

