/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.resource.names;

import java.util.Hashtable;
import org.apache.commons.discovery.ResourceNameDiscover;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.log.DiscoveryLogFactory;
import org.apache.commons.discovery.resource.names.ResourceNameDiscoverImpl;
import org.apache.commons.logging.Log;

public class DiscoverMappedNames
extends ResourceNameDiscoverImpl
implements ResourceNameDiscover {
    private static Log log = DiscoveryLogFactory.newLog(DiscoverMappedNames.class);
    private Hashtable mapping = new Hashtable();

    public static void setLog(Log log) {
        DiscoverMappedNames.log = log;
    }

    public void map(String string, String string2) {
        this.mapping.put(string, string2);
    }

    public void map(String string, String[] stringArray) {
        this.mapping.put(string, stringArray);
    }

    public ResourceNameIterator findResourceNames(String string) {
        Object v;
        if (log.isDebugEnabled()) {
            log.debug("find: resourceName='" + string + "', mapping to constants");
        }
        final String[] stringArray = (v = this.mapping.get(string)) instanceof String ? new String[]{(String)v} : (v instanceof String[] ? (String[])v : null);
        return new ResourceNameIterator(){
            private int idx = 0;

            public boolean hasNext() {
                if (stringArray != null) {
                    while (this.idx < stringArray.length && stringArray[this.idx] == null) {
                        ++this.idx;
                    }
                    return this.idx < stringArray.length;
                }
                return false;
            }

            public String nextResourceName() {
                return this.hasNext() ? stringArray[this.idx++] : null;
            }
        };
    }
}

