/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.tools;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.discovery.jdk.JDKHooks;

public class ManagedProperties {
    private static final HashMap propertiesCache = new HashMap();

    public static String getProperty(String string) {
        return ManagedProperties.getProperty(ManagedProperties.getThreadContextClassLoader(), string);
    }

    public static String getProperty(String string, String string2) {
        return ManagedProperties.getProperty(ManagedProperties.getThreadContextClassLoader(), string, string2);
    }

    public static String getProperty(ClassLoader classLoader, String string) {
        Value value;
        String string2 = System.getProperty(string);
        if (string2 == null && (value = ManagedProperties.getValueProperty(classLoader, string)) != null) {
            string2 = value.value;
        }
        return string2;
    }

    public static String getProperty(ClassLoader classLoader, String string, String string2) {
        String string3 = ManagedProperties.getProperty(classLoader, string);
        return string3 == null ? string2 : string3;
    }

    public static void setProperty(String string, String string2) {
        ManagedProperties.setProperty(string, string2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperty(String string, String string2, boolean bl) {
        if (string != null) {
            HashMap hashMap = propertiesCache;
            synchronized (hashMap) {
                ClassLoader classLoader = ManagedProperties.getThreadContextClassLoader();
                HashMap<String, Value> hashMap2 = (HashMap<String, Value>)propertiesCache.get(classLoader);
                if (string2 == null) {
                    hashMap2.remove(string);
                } else {
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap<String, Value>();
                        propertiesCache.put(classLoader, hashMap2);
                    }
                    hashMap2.put(string, new Value(string2, bl));
                }
            }
        }
    }

    public static void setProperties(Map map) {
        ManagedProperties.setProperties(map, false);
    }

    public static void setProperties(Map map, boolean bl) {
        for (Map.Entry entry : map.entrySet()) {
            ManagedProperties.setProperty(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration propertyNames() {
        Hashtable hashtable = new Hashtable();
        ClassLoader classLoader = ManagedProperties.getThreadContextClassLoader();
        while (true) {
            HashMap hashMap = null;
            HashMap hashMap2 = propertiesCache;
            synchronized (hashMap2) {
                hashMap = (HashMap)propertiesCache.get(classLoader);
            }
            if (hashMap != null) {
                hashtable.putAll(hashMap);
            }
            if (classLoader == null) break;
            classLoader = ManagedProperties.getParent(classLoader);
        }
        return hashtable.keys();
    }

    public static Properties getProperties() {
        Properties properties = new Properties();
        Enumeration enumeration = ManagedProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.put(string, ManagedProperties.getProperty(string));
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Value getValueProperty(ClassLoader classLoader, String string) {
        Value value = null;
        if (string != null) {
            if (classLoader != null) {
                value = ManagedProperties.getValueProperty(ManagedProperties.getParent(classLoader), string);
            }
            if (value == null || value.isDefault) {
                HashMap hashMap = propertiesCache;
                synchronized (hashMap) {
                    Value value2;
                    HashMap hashMap2 = (HashMap)propertiesCache.get(classLoader);
                    if (hashMap2 != null && (value2 = (Value)hashMap2.get(string)) != null) {
                        value = value2;
                    }
                }
            }
        }
        return value;
    }

    private static final ClassLoader getThreadContextClassLoader() {
        return JDKHooks.getJDKHooks().getThreadContextClassLoader();
    }

    private static final ClassLoader getParent(final ClassLoader classLoader) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return classLoader.getParent();
            }
        });
    }

    private static class Value {
        final String value;
        final boolean isDefault;

        Value(String string, boolean bl) {
            this.value = string;
            this.isDefault = bl;
        }
    }
}

