/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.discovery.DiscoveryException;
import org.apache.commons.discovery.Resource;
import org.apache.commons.discovery.ResourceIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.DiscoverResources;

public class ResourceUtils {
    public static String getPackageName(Class clazz) {
        String string;
        Package package_ = clazz.getPackage();
        if (package_ != null) {
            string = package_.getName();
        } else {
            String string2 = clazz.getName();
            string = new String(string2.toCharArray(), 0, string2.lastIndexOf(46));
        }
        return string;
    }

    public static Resource getResource(Class clazz, String string, ClassLoaders classLoaders) throws DiscoveryException {
        DiscoverResources discoverResources = new DiscoverResources(classLoaders);
        ResourceIterator resourceIterator = discoverResources.findResources(string);
        if (clazz != null && !resourceIterator.hasNext() && string.charAt(0) != '/') {
            string = ResourceUtils.getPackageName(clazz).replace('.', '/') + "/" + string;
            resourceIterator = discoverResources.findResources(string);
        }
        return resourceIterator.hasNext() ? resourceIterator.nextResource() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(Class clazz, String string, ClassLoaders classLoaders) throws DiscoveryException {
        Properties properties;
        block7: {
            properties = null;
            if (string != null) {
                try {
                    InputStream inputStream;
                    Resource resource = ResourceUtils.getResource(clazz, string, classLoaders);
                    if (resource == null || (inputStream = resource.getResourceAsStream()) == null) break block7;
                    properties = new Properties();
                    try {
                        properties.load(inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        return properties;
    }
}

