/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.tools;

import java.util.Enumeration;
import org.apache.commons.discovery.ResourceClass;
import org.apache.commons.discovery.ResourceClassIterator;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.classes.DiscoverClasses;
import org.apache.commons.discovery.resource.names.DiscoverServiceNames;
import org.apache.commons.discovery.tools.SPInterface;

public class Service {
    protected Service() {
    }

    public static Enumeration providers(Class clazz) {
        return Service.providers(new SPInterface(clazz), null);
    }

    public static Enumeration providers(final SPInterface sPInterface, ClassLoaders classLoaders) {
        if (classLoaders == null) {
            classLoaders = ClassLoaders.getAppLoaders(sPInterface.getSPClass(), Service.class, true);
        }
        ResourceNameIterator resourceNameIterator = new DiscoverServiceNames(classLoaders).findResourceNames(sPInterface.getSPName());
        final ResourceClassIterator resourceClassIterator = new DiscoverClasses(classLoaders).findResourceClasses(resourceNameIterator);
        return new Enumeration(){
            private Object object = null;

            public boolean hasMoreElements() {
                if (this.object == null) {
                    this.object = this.getNextClassInstance();
                }
                return this.object != null;
            }

            public Object nextElement() {
                Object object = this.object;
                this.object = null;
                return object;
            }

            private Object getNextClassInstance() {
                while (resourceClassIterator.hasNext()) {
                    ResourceClass resourceClass = resourceClassIterator.nextResourceClass();
                    try {
                        return sPInterface.newInstance(resourceClass.loadClass());
                    }
                    catch (Exception exception) {
                    }
                }
                return null;
            }
        };
    }
}

