/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.nntp;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.net.nntp.Threadable;

public class Article
implements Threadable {
    private int articleNumber;
    private String subject;
    private String date;
    private String articleId;
    private String simplifiedSubject;
    private String from;
    private StringBuffer header = new StringBuffer();
    private StringBuffer references;
    private boolean isReply = false;
    public Article kid;
    public Article next;

    public void addHeaderField(String string, String string2) {
        this.header.append(string);
        this.header.append(": ");
        this.header.append(string2);
        this.header.append('\n');
    }

    public void addReference(String string) {
        if (this.references == null) {
            this.references = new StringBuffer();
            this.references.append("References: ");
        }
        this.references.append(string);
        this.references.append("\t");
    }

    public String[] getReferences() {
        if (this.references == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.references.toString().indexOf(58);
        StringTokenizer stringTokenizer = new StringTokenizer(this.references.substring(n), "\t");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return (String[])arrayList.toArray();
    }

    private void simplifySubject() {
        int n = 0;
        String string = this.getSubject();
        int n2 = string.length();
        boolean bl = false;
        while (!bl) {
            int n3;
            bl = true;
            while (n < n2 && string.charAt(n) == ' ') {
                ++n;
            }
            if (!(n >= n2 - 2 || string.charAt(n) != 'r' && string.charAt(n) != 'R' || string.charAt(n + 1) != 'e' && string.charAt(n + 1) != 'E')) {
                if (string.charAt(n + 2) == ':') {
                    n += 3;
                    this.isReply = true;
                    bl = false;
                } else if (n < n2 - 2 && (string.charAt(n + 2) == '[' || string.charAt(n + 2) == '(')) {
                    for (n3 = n + 3; n3 < n2 && string.charAt(n3) >= '0' && string.charAt(n3) <= '9'; ++n3) {
                    }
                    if (n3 < n2 - 1 && (string.charAt(n3) == ']' || string.charAt(n3) == ')') && string.charAt(n3 + 1) == ':') {
                        n = n3 + 2;
                        this.isReply = true;
                        bl = false;
                    }
                }
            }
            if (this.simplifiedSubject == "(no subject)") {
                this.simplifiedSubject = "";
            }
            for (n3 = n2; n3 > n && string.charAt(n3 - 1) < ' '; --n3) {
            }
            if (n == 0 && n3 == n2) {
                this.simplifiedSubject = string;
                continue;
            }
            this.simplifiedSubject = string.substring(n, n3);
        }
    }

    public static void printThread(Article article, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("==>");
        }
        System.out.println(article.getSubject() + "\t" + article.getFrom());
        if (article.kid != null) {
            Article.printThread(article.kid, n + 1);
        }
        if (article.next != null) {
            Article.printThread(article.next, n);
        }
    }

    public String getArticleId() {
        return this.articleId;
    }

    public int getArticleNumber() {
        return this.articleNumber;
    }

    public String getDate() {
        return this.date;
    }

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setArticleId(String string) {
        this.articleId = string;
    }

    public void setArticleNumber(int n) {
        this.articleNumber = n;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public boolean isDummy() {
        return this.getSubject() == null;
    }

    public String messageThreadId() {
        return this.articleId;
    }

    public String[] messageThreadReferences() {
        return this.getReferences();
    }

    public String simplifiedSubject() {
        if (this.simplifiedSubject == null) {
            this.simplifySubject();
        }
        return this.simplifiedSubject;
    }

    public boolean subjectIsReply() {
        if (this.simplifiedSubject == null) {
            this.simplifySubject();
        }
        return this.isReply;
    }

    public void setChild(Threadable threadable) {
        this.kid = (Article)threadable;
        this.flushSubjectCache();
    }

    private void flushSubjectCache() {
        this.simplifiedSubject = null;
    }

    public void setNext(Threadable threadable) {
        this.next = (Article)threadable;
        this.flushSubjectCache();
    }

    public Threadable makeDummy() {
        return new Article();
    }
}

